/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ui.extensions.ICopySourceDelegator;
import org.eclipse.scout.sdk.ui.extensions.IPasteTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public final class CopyAndPasteExtensionPoint {
    private static final String EXTENSION_POINT_NAME = "outlineCopyAndPaste";
    private static final String PASTE_DELEGATOR_ATT_NAME = "pasteTargetDelegator";
    private static final String COPY_DELEGATOR_ATT_NAME = "copySourceDelegator";
    private static List<IPasteTargetDelegator> pasteTargetDelegates = null;
    private static List<ICopySourceDelegator> copySourceDelegates = null;

    private CopyAndPasteExtensionPoint() {
    }

    private static synchronized void init() {
        if (pasteTargetDelegates == null || copySourceDelegates == null) {
            IExtension[] extensions;
            ArrayList<IPasteTargetDelegator> pasteDelegators = new ArrayList<IPasteTargetDelegator>();
            ArrayList<ICopySourceDelegator> copyDelegators = new ArrayList<ICopySourceDelegator>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXTENSION_POINT_NAME);
            IExtension[] iExtensionArray = extensions = xp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        if (element.getAttribute(PASTE_DELEGATOR_ATT_NAME) != null) {
                            IPasteTargetDelegator pasteDelegator = (IPasteTargetDelegator)element.createExecutableExtension(PASTE_DELEGATOR_ATT_NAME);
                            pasteDelegators.add(pasteDelegator);
                        } else if (element.getAttribute(COPY_DELEGATOR_ATT_NAME) != null) {
                            ICopySourceDelegator copyDelegator = (ICopySourceDelegator)element.createExecutableExtension(COPY_DELEGATOR_ATT_NAME);
                            copyDelegators.add(copyDelegator);
                        }
                    }
                    catch (CoreException e) {
                        ScoutSdkUi.logError("Could not create an executable extension of point '" + extension.getExtensionPointUniqueIdentifier() + "'.", e);
                    }
                    ++n4;
                }
                ++n2;
            }
            pasteTargetDelegates = CollectionUtility.arrayList(pasteDelegators);
            copySourceDelegates = CollectionUtility.arrayList(copyDelegators);
        }
    }

    public static List<IPasteTargetDelegator> getPasteTargetDelegators() {
        CopyAndPasteExtensionPoint.init();
        return CollectionUtility.arrayList(pasteTargetDelegates);
    }

    public static List<ICopySourceDelegator> getCopySourceDelegators() {
        CopyAndPasteExtensionPoint.init();
        return CollectionUtility.arrayList(copySourceDelegates);
    }
}

