/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.technology.docx4j;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.MenuNewOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementFormatOperation;
import org.eclipse.scout.sdk.operation.jdt.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodBodySourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.ui.extensions.technology.AbstractScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.extensions.technology.ScoutTechnologyResource;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class Docx4jDesktopTechnologyHandler
extends AbstractScoutTechnologyHandler {
    private static final String EXCEL_EXPORT_MENU_TYPE_NAME = "ExportToExcelMenu";
    private static final String EXCEL_EXPORT_NLS_KEY = "ExportToExcelMenu";

    @Override
    public void selectionChanged(Set<IScoutTechnologyResource> resources, boolean selected, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        DesktopTechnologyResource r = (DesktopTechnologyResource)CollectionUtility.firstElement(resources);
        if (selected) {
            IType menu = r.m_toolsMenuType.getType("ExportToExcelMenu");
            if (!TypeUtility.exists((IJavaElement)menu)) {
                MenuNewOperation mno = new MenuNewOperation("ExportToExcelMenu", r.m_toolsMenuType, false);
                INlsEntry nlsEntry = r.getBundle().getNlsProject().getEntry("ExportToExcelMenu");
                if (nlsEntry == null) {
                    NlsEntry newEntry = new NlsEntry("ExportToExcelMenu", r.getBundle().getNlsProject());
                    newEntry.addTranslation(Language.LANGUAGE_DEFAULT, "Export to &Excel");
                    r.getBundle().getNlsProject().updateRow((INlsEntry)newEntry, monitor);
                }
                mno.setNlsEntry(nlsEntry);
                mno.setSuperTypeSignature(RuntimeClasses.getSuperTypeSignature((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu", (IScoutBundle)r.getBundle()));
                mno.validate();
                mno.run(monitor, workingCopyManager);
                menu = mno.getCreatedMenu();
                workingCopyManager.reconcile(menu.getCompilationUnit(), monitor);
            }
            String scoutXlsxSpreadsheetAdapterFqn = "org.eclipse.scout.rt.docx4j.client.ScoutXlsxSpreadsheetAdapter";
            MethodOverrideOperation execAction = new MethodOverrideOperation("execAction", menu);
            execAction.setMethodBodySourceBuilder(new IMethodBodySourceBuilder(){

                public void createSource(IMethodSourceBuilder methodBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                    String typeRef = SignatureUtility.getTypeReference((String)SignatureCache.createTypeSignature((String)"org.eclipse.scout.rt.docx4j.client.ScoutXlsxSpreadsheetAdapter"), (IImportValidator)validator);
                    String ioFileRef = SignatureUtility.getTypeReference((String)SignatureCache.createTypeSignature((String)"java.io.File"), (IImportValidator)validator);
                    String shellRef = SignatureUtility.getTypeReference((String)SignatureCache.createTypeSignature((String)"org.eclipse.scout.rt.shared.services.common.shell.IShellService"), (IImportValidator)validator);
                    String svcRef = SignatureUtility.getTypeReference((String)SignatureCache.createTypeSignature((String)"org.eclipse.scout.service.SERVICES"), (IImportValidator)validator);
                    source.append("if (getOutline() != null && getOutline().getActivePage() != null) {\n");
                    source.append("  ");
                    source.append(typeRef);
                    source.append(" s = new ");
                    source.append(typeRef);
                    source.append("();\n");
                    source.append("  ");
                    source.append(ioFileRef);
                    source.append(" xlsx = s.exportPage(null, 0, 0, getOutline().getActivePage());\n");
                    source.append("  ");
                    source.append(svcRef);
                    source.append(".getService(");
                    source.append(shellRef);
                    source.append(".class).shellOpen(xlsx.getAbsolutePath());\n");
                    source.append("}");
                }
            });
            execAction.setFormatSource(false);
            execAction.validate();
            execAction.run(monitor, workingCopyManager);
            workingCopyManager.reconcile(execAction.getCreatedMethod().getCompilationUnit(), monitor);
            JavaElementFormatOperation formatOb = new JavaElementFormatOperation((IMember)menu, false);
            formatOb.validate();
            formatOb.run(monitor, workingCopyManager);
        } else {
            IType typeToDelete = r.m_toolsMenuType.getType("ExportToExcelMenu");
            if (TypeUtility.exists((IJavaElement)typeToDelete)) {
                JavaElementDeleteOperation d = new JavaElementDeleteOperation();
                d.addMember((IJavaElement)typeToDelete);
                d.validate();
                d.run(monitor, workingCopyManager);
            }
        }
    }

    @Override
    public TriState getSelection(IScoutBundle project) throws CoreException {
        IType desktopToolsMenu = this.getDesktopToolsMenu(project);
        if (TypeUtility.exists((IJavaElement)desktopToolsMenu) && TypeUtility.exists((IJavaElement)desktopToolsMenu.getType("ExportToExcelMenu"))) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    public boolean isActive(IScoutBundle project) {
        return this.getDesktopToolsMenu(project) != null;
    }

    @Override
    protected void contributeResources(IScoutBundle project, List<IScoutTechnologyResource> list) throws CoreException {
        IType desktopToolsMenu = this.getDesktopToolsMenu(project);
        if (TypeUtility.exists((IJavaElement)desktopToolsMenu) && desktopToolsMenu.getResource() instanceof IFile) {
            DesktopTechnologyResource r = new DesktopTechnologyResource(ScoutTypeUtility.getScoutBundle((IJavaElement)desktopToolsMenu), (IFile)desktopToolsMenu.getResource(), desktopToolsMenu);
            list.add(r);
        }
    }

    private Set<? extends IScoutBundle> getClientBundlesBelow(IScoutBundle startBundle) {
        IScoutBundleFilter filter = ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}), ScoutBundleFilters.getWorkspaceBundlesFilter()});
        return startBundle.getChildBundles(filter, true);
    }

    private IType getDesktopToolsMenu(IScoutBundle startBundle) {
        Set<? extends IScoutBundle> clients = this.getClientBundlesBelow(startBundle);
        IType iDesktop = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.IDesktop");
        if (TypeUtility.exists((IJavaElement)iDesktop)) {
            ICachedTypeHierarchy desktopHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iDesktop);
            Set desktops = desktopHierarchy.getAllSubtypes(iDesktop, ScoutTypeFilters.getClassesInScoutBundles(clients));
            for (IType desktop : desktops) {
                IType toolsMenu = desktop.getType("ToolsMenu");
                if (!TypeUtility.exists((IJavaElement)toolsMenu)) continue;
                return toolsMenu;
            }
        }
        return null;
    }

    private static final class DesktopTechnologyResource
    extends ScoutTechnologyResource {
        private final IType m_toolsMenuType;

        private DesktopTechnologyResource(IScoutBundle bundle, IFile resource, IType toolsMenuType) {
            super(bundle, resource);
            this.m_toolsMenuType = toolsMenuType;
        }
    }
}

