/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.create.MenuNewAction;
import org.eclipse.scout.sdk.ui.action.delete.DeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeComparators;

public class MenuNodePage
extends AbstractScoutTypePage {
    private InnerTypePageDirtyListener m_menuChangedListener;

    public MenuNodePage(IPage parentPage, IType menuType) {
        super("Menu");
        this.setParent(parentPage);
        this.setType(menuType);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.MenuNodePage";
    }

    @Override
    protected String getMethodNameForTranslatedText() {
        return "getConfiguredText";
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_menuChangedListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
            this.m_menuChangedListener = null;
        }
    }

    @Override
    protected void loadChildrenImpl() {
        IType iMenuType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
        if (this.m_menuChangedListener == null) {
            this.m_menuChangedListener = new InnerTypePageDirtyListener(this, iMenuType);
            ScoutSdkCore.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
        }
        Set menus = TypeUtility.getInnerTypes((IType)this.getType(), (ITypeFilter)TypeFilters.getSubtypeFilter((IType)iMenuType), (Comparator)ScoutTypeComparators.getOrderAnnotationComparator());
        for (IType menu : menus) {
            new MenuNodePage(this, menu);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(TypeRenameAction.class, ShowJavaReferencesAction.class, DeleteAction.class, MenuNewAction.class);
    }
}

