/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server;

import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ClassIdNewAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.AbstractBundleNodeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServerServicesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.CommonServicesNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ServerNodePage
extends AbstractBundleNodeTablePage {
    private ICachedTypeHierarchy m_serverSessionHierarchy;

    public ServerNodePage(IPage parent, ScoutBundleNode node) {
        super(parent, node);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerNodePage";
    }

    @Override
    public void unloadPage() {
        if (this.m_serverSessionHierarchy != null) {
            this.m_serverSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_serverSessionHierarchy = null;
        }
    }

    @Override
    protected void loadChildrenImpl() {
        super.loadChildrenImpl();
        if (this.m_serverSessionHierarchy == null) {
            IType iServerSession = TypeUtility.getType((String)"org.eclipse.scout.rt.server.IServerSession");
            this.m_serverSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iServerSession);
            this.m_serverSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        try {
            for (IType serverSession : ScoutTypeUtility.getServerSessionTypes((IScoutBundle)this.getScoutBundle())) {
                new ServerSessionNodePage(this, serverSession);
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ServerSessionNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new ServerServicesTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ServerServicesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new LookupServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + LookupServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new CommonServicesNodePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + CommonServicesNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new LibrariesTablePage(this, this.getScoutBundle());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured while loading '" + LibrariesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(WellformAction.class, FormDataSqlBindingValidateAction.class, ScoutBundleNewAction.class, ClassIdNewAction.class);
    }
}

