/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.ui.action.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.LookupServiceNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class LookupServiceTablePage
extends AbstractPage
implements ITypeResolver {
    private ICachedTypeHierarchy m_serviceHierarchy;

    public LookupServiceTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"LookupServiceTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.LookupServiceTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    protected void loadChildrenImpl() {
        for (IType service : this.getTypes()) {
            Set interfaces = this.m_serviceHierarchy.getSuperInterfaces(service, TypeFilters.getElementNameFilter((String)("I" + service.getElementName())));
            new LookupServiceNodePage(this, service, (IType)CollectionUtility.firstElement((Collection)interfaces));
        }
    }

    public Set<IType> getTypes() {
        IType iLookupService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iLookupService);
            this.m_serviceHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        return this.m_serviceHierarchy.getAllSubtypes(iLookupService, ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle()), TypeComparators.getTypeNameComparator());
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(FormDataSqlBindingValidateAction.class, LookupServiceNewAction.class);
    }
}

