/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.FilterExpressionProperty;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PageFilterExpressionPresenter
extends AbstractPresenter {
    private Text m_textField;
    private Button m_useRegexField;
    private final FilterExpressionProperty m_filterProperty;

    public PageFilterExpressionPresenter(PropertyViewFormToolkit toolkit, Composite parent, FilterExpressionProperty filterProperty) {
        super(toolkit, parent);
        this.m_filterProperty = filterProperty;
        this.createContent(this.getContainer());
        GridLayout glayout = new GridLayout(1, true);
        glayout.horizontalSpacing = 0;
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        this.getContainer().setLayout((Layout)glayout);
    }

    protected void createContent(Composite parent) {
        Composite container = this.getToolkit().createComposite(parent);
        Label label = this.getToolkit().createLabel(container, Texts.get((String)"Find"));
        this.m_textField = this.getToolkit().createText(container, "", 2048);
        this.m_useRegexField = this.getToolkit().createButton(container, Texts.get((String)"UseRegularExpression"), 32);
        this.m_textField.setText(this.m_filterProperty.getFilterText());
        this.m_useRegexField.setSelection(this.m_filterProperty.isRegexFilter());
        this.m_textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageFilterExpressionPresenter.this.doVerifyInput();
            }
        });
        this.m_useRegexField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageFilterExpressionPresenter.this.doVerifyInput();
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 50;
        data.verticalAlignment = 2;
        label.setLayoutData((Object)data);
        data = new GridData(1808);
        this.m_textField.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.m_useRegexField.setLayoutData((Object)data);
        container.setLayoutData((Object)new GridData(1808));
    }

    private void doVerifyInput() {
        String s = this.m_textField.getText();
        s = s == null ? "" : s.trim();
        try {
            this.m_textField.setBackground(null);
            String newValue = s;
            this.m_filterProperty.updateFilter(newValue, this.m_useRegexField.getSelection());
        }
        catch (Exception e) {
            this.m_textField.setBackground(this.m_textField.getDisplay().getSystemColor(3));
        }
    }
}

