/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.util.HashMap;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.ui.extensions.view.property.ISinglePropertyViewPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.AbstractSectionBasedPart;
import org.eclipse.scout.sdk.ui.view.properties.part.Section;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractSinglePageSectionBasedViewPart
extends AbstractSectionBasedPart
implements ISinglePropertyViewPart {
    private static final HashMap<String, HashMap<String, Boolean>> EXPANSION_SETTINGS = new HashMap();
    private IPage m_page;

    @Override
    public IPage getPage() {
        return this.m_page;
    }

    @Override
    public void setPage(IPage page) {
        this.m_page = page;
    }

    protected String getPartKey() {
        IPage p = this.getPage();
        if (p == null) {
            return null;
        }
        return p.toString();
    }

    @Override
    protected void cleanup() {
        this.cacheSectionExpansionState();
        super.cleanup();
    }

    private void cacheSectionExpansionState() {
        Section[] sections = this.getSections();
        HashMap<String, Boolean> pageCache = EXPANSION_SETTINGS.get(this.getPartKey());
        if (pageCache == null) {
            pageCache = new HashMap(sections.length);
            EXPANSION_SETTINGS.put(this.getPartKey(), pageCache);
        }
        Section[] sectionArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            Section s = sectionArray[n2];
            pageCache.put(s.getSectionId(), s.isExpanded());
            ++n2;
        }
    }

    protected boolean wasSectionExpanded(String sectionId, boolean defaultValue) {
        TriState state = this.wasSectionExpanded(sectionId);
        if (state == TriState.UNDEFINED) {
            return defaultValue;
        }
        return state.getBooleanValue();
    }

    protected TriState wasSectionExpanded(String sectionId) {
        HashMap<String, Boolean> pageCache = EXPANSION_SETTINGS.get(this.getPartKey());
        if (pageCache == null) {
            return TriState.UNDEFINED;
        }
        Boolean expanded = pageCache.get(sectionId);
        if (expanded == null) {
            return TriState.UNDEFINED;
        }
        if (expanded.booleanValue()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    protected Control createHead(Composite parent) {
        Composite headArea = this.getFormToolkit().createComposite(parent);
        Label title = this.getFormToolkit().createLabel(headArea, this.getPage().getName(), 72);
        headArea.setLayout((Layout)new GridLayout(1, true));
        GridData titleData = new GridData(800);
        titleData.widthHint = 100;
        title.setLayoutData((Object)titleData);
        return headArea;
    }
}

