/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithTableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.TypeOpenLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.LinksPresenter;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.JdtTypePropertyPart;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class PageWithTablePropertyPart
extends JdtTypePropertyPart {
    private static final String SECTION_ID_LINKS = "section.links";

    @Override
    protected void createSections() {
        ISection linkSection = this.createSection(SECTION_ID_LINKS, Texts.get((String)"Links"));
        this.fillLinkSection(linkSection.getSectionClient());
        linkSection.setExpanded(this.wasSectionExpanded(SECTION_ID_LINKS, true));
        super.createSections();
    }

    @Override
    public PageWithTableNodePage getPage() {
        return (PageWithTableNodePage)super.getPage();
    }

    protected void fillLinkSection(Composite parent) {
        final LinksPresenter presenter = new LinksPresenter(this.getFormToolkit(), parent);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 200;
        presenter.getContainer().setLayoutData((Object)layoutData);
        final ProgressIndicator indicator = new ProgressIndicator(presenter.getContainer(), 65538);
        indicator.beginAnimatedTask();
        GridData indicatorData = new GridData(768);
        indicatorData.horizontalSpan = 2;
        indicatorData.heightHint = 5;
        indicator.setLayoutData((Object)indicatorData);
        Job j = new Job("load links..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (presenter != null && !presenter.isDisposed()) {
                    LinksPresenterModel model = new LinksPresenterModel();
                    IType pageWithTable = PageWithTablePropertyPart.this.getPage().getType();
                    if (TypeUtility.exists((IJavaElement)pageWithTable)) {
                        model.addGlobalLink(new TypeOpenLink(pageWithTable));
                        try {
                            int flags;
                            ITypeHierarchy pageSuperTypeHierarchy = ScoutTypeUtility.getSupertypeHierarchy((IType)pageWithTable);
                            IType pageSuperClass = pageSuperTypeHierarchy.getSuperclass(pageWithTable);
                            if (TypeUtility.exists((IJavaElement)pageSuperClass) && !Flags.isAbstract((int)(flags = pageSuperClass.getFlags())) && !Flags.isInterface((int)flags)) {
                                TypeOpenLink lnk = new TypeOpenLink(pageSuperClass);
                                lnk.setName(pageSuperClass.getElementName());
                                model.addGlobalLink(lnk);
                            }
                        }
                        catch (JavaModelException e) {
                            ScoutSdkUi.logError(e);
                        }
                        IType pageDataType = null;
                        try {
                            pageDataType = ScoutTypeUtility.findDtoForPage((IType)PageWithTablePropertyPart.this.getPage().getType());
                            if (TypeUtility.exists((IJavaElement)pageDataType)) {
                                model.addGlobalLink(new TypeOpenLink(pageDataType));
                            }
                        }
                        catch (JavaModelException e) {
                            ScoutSdkUi.logError(e);
                        }
                    }
                    final LinksPresenterModel finalModel = model;
                    presenter.getContainer().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (presenter != null && !presenter.isDisposed()) {
                                indicator.dispose();
                                presenter.setLinksProperty(finalModel);
                                PageWithTablePropertyPart.this.getForm().layout(true, true);
                                PageWithTablePropertyPart.this.getForm().updateToolBar();
                                PageWithTablePropertyPart.this.getForm().reflow(true);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
    }
}

