/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.library;

import java.io.File;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.proposal.resources.IoFileLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.resources.ResourcesContentProvider;
import org.eclipse.scout.sdk.ui.fields.table.AutoResizeColumnTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class JarSelectionWizardPage
extends AbstractWorkspaceWizardPage {
    private static final String PREF_FILE_DIALOG_PATH = "fileDialogPath";
    public static final String PROP_JAR_FILES = "jarFiles";
    private TableViewer m_jarViewer;
    private Button m_removeButton;
    private Button m_addButton;

    public JarSelectionWizardPage() {
        super(JarSelectionWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewLibraryBundle"));
        this.setJarFilesInternal(new TreeSet<File>(new P_FileComparator()));
    }

    @Override
    protected void createContent(Composite parent) {
        AutoResizeColumnTable table = new AutoResizeColumnTable(parent, 65540);
        table.setHeaderVisible(true);
        TableColumn fileNameCol = new TableColumn((Table)table, 16384);
        fileNameCol.setText(Texts.get((String)"Name"));
        fileNameCol.setWidth(100);
        TableColumn pathColumn = new TableColumn((Table)table, 16384);
        pathColumn.setText(Texts.get((String)"Path"));
        pathColumn.setWidth(200);
        this.m_jarViewer = new TableViewer((Table)table);
        IoFileLabelProvider labelProvider = new IoFileLabelProvider();
        this.m_jarViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_jarViewer.setContentProvider((IContentProvider)new P_JarFileContentProvider(labelProvider));
        this.m_jarViewer.setInput(this.getJarFiles());
        this.m_jarViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JarSelectionWizardPage.this.m_removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        Composite buttonList = new Composite(parent, 0);
        this.m_addButton = new Button(buttonList, 0x800008);
        this.m_addButton.setText(Texts.get((String)"Add"));
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarSelectionWizardPage.this.openJarSelectionDialog();
            }
        });
        this.m_removeButton = new Button(buttonList, 0x800008);
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.setText(Texts.get((String)"Remove"));
        this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set<File> jarFiles;
                ISelection currentSelection = JarSelectionWizardPage.this.m_jarViewer.getSelection();
                if (!currentSelection.isEmpty() && (jarFiles = JarSelectionWizardPage.this.getJarFiles()).remove(((IStructuredSelection)currentSelection).getFirstElement())) {
                    JarSelectionWizardPage.this.setJarFiels(jarFiles);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(2, false));
        this.m_jarViewer.getControl().setLayoutData((Object)new GridData(1808));
        buttonList.setLayoutData((Object)new GridData(130));
        buttonList.setLayout((Layout)new GridLayout(1, true));
        this.m_addButton.setLayoutData((Object)new GridData(768));
        this.m_removeButton.setLayoutData((Object)new GridData(768));
    }

    private void openJarSelectionDialog() {
        IDialogSettings prefs = ScoutSdkUi.getDefault().getDialogSettingsSection(String.valueOf(JarSelectionWizardPage.class.getName()) + ".FileDialog", true);
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setFilterExtensions(new String[]{"*.jar"});
        dialog.setText(Texts.get((String)"JARFileSelection"));
        String filterPath = prefs.get(PREF_FILE_DIALOG_PATH);
        if (StringUtility.hasText((CharSequence)filterPath)) {
            dialog.setFilterPath(filterPath);
        }
        boolean ok = dialog.open() != null;
        prefs.put(PREF_FILE_DIALOG_PATH, dialog.getFilterPath());
        if (ok) {
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File file = new File(dialog.getFilterPath(), fileName);
                if (file.exists()) {
                    Set<File> jarFiles = this.getJarFiles();
                    jarFiles.add(file);
                    this.setJarFiels(jarFiles);
                }
                ++n2;
            }
        }
    }

    public Set<File> getJarFiles() {
        return (Set)this.getProperty(PROP_JAR_FILES);
    }

    public void setJarFiels(Set<File> jarFiles) {
        try {
            this.setStateChanging(true);
            this.setJarFilesInternal(jarFiles);
            if (this.isControlCreated()) {
                this.m_jarViewer.setInput(jarFiles);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setJarFilesInternal(Set<File> jarFiles) {
        this.setPropertyAlwaysFire(PROP_JAR_FILES, jarFiles);
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusJarFiles());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusJarFiles() throws JavaModelException {
        Set<File> jarFiles = this.getJarFiles();
        if (jarFiles == null || jarFiles.isEmpty()) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoJarFilesSelected"));
        }
        return Status.OK_STATUS;
    }

    private class P_FileComparator
    implements Comparator<File> {
        private P_FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return CompareUtility.compareTo((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    }

    private class P_JarFileContentProvider
    extends ResourcesContentProvider {
        public P_JarFileContentProvider(ILabelProvider labelProvider) {
            super(labelProvider);
        }

        @Override
        public Object[] getElements() {
            Set<File> jarFiles = JarSelectionWizardPage.this.getJarFiles();
            if (jarFiles != null) {
                return jarFiles.toArray(new File[jarFiles.size()]);
            }
            return new File[0];
        }
    }
}

