/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.ast.visitor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.scout.sdk.util.ast.visitor.DefaultAstVisitor;
import org.eclipse.scout.sdk.util.ast.visitor.TypeSignatureResolveVisitor;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;

public class VariableResolveVisitor
extends DefaultAstVisitor {
    private final Set<String> m_assignedTypes;
    private final String m_variableName;
    private final ASTNode m_rootNode;
    private final ASTNode m_stopNode;
    private final IJavaElement m_containerElement;
    private boolean m_debug = false;
    private boolean m_canceled;
    private String m_indent = "";
    private String m_variableTypeSignature;
    private P_Variable m_currentVariable;
    private int m_mode = -1;

    public VariableResolveVisitor(String variableName, IJavaElement containerElement, ASTNode rootNode, ASTNode stopNode) {
        this.m_variableName = variableName;
        this.m_containerElement = containerElement;
        this.m_rootNode = rootNode;
        this.m_stopNode = stopNode;
        this.m_assignedTypes = new HashSet<String>();
    }

    public void preVisit(ASTNode node) {
        if (node.equals((Object)this.m_stopNode)) {
            this.m_canceled = true;
        }
        if (this.m_debug && !this.m_canceled) {
            SdkUtilActivator.logInfo(String.valueOf(this.m_indent) + "varResolve " + node.getNodeType() + "  " + node + "     ");
            this.m_indent = String.valueOf(this.m_indent) + "  ";
        }
    }

    public void postVisit(ASTNode node) {
        if (this.m_debug && !this.m_canceled) {
            this.m_indent = this.m_indent.replaceFirst("\\s\\s$", "");
            SdkUtilActivator.logInfo(String.valueOf(this.m_indent) + "end " + node.getNodeType());
        }
    }

    @Override
    public boolean visitNode(ASTNode node) {
        return !this.m_canceled;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (this.m_canceled) {
            return false;
        }
        this.m_mode = node.getNodeType();
        this.m_currentVariable = new P_Variable();
        return true;
    }

    public void endVisit(SingleVariableDeclaration node) {
        if (this.m_canceled) {
            return;
        }
        if (this.m_mode == node.getNodeType()) {
            if (this.m_currentVariable != null) {
                this.store(this.m_currentVariable);
                this.m_currentVariable = null;
            }
            this.m_mode = -1;
        }
    }

    @Override
    public boolean visit(SimpleType node) {
        if (this.m_canceled) {
            return false;
        }
        if (this.m_currentVariable != null) {
            switch (this.m_mode) {
                case 7: 
                case 44: 
                case 60: {
                    if (this.m_currentVariable.variableTypeName != null) break;
                    try {
                        String resolvedSignature;
                        this.m_currentVariable.variableTypeName = resolvedSignature = SignatureUtility.getResolvedSignature(Signature.createTypeSignature((String)node.getName().getFullyQualifiedName(), (boolean)false), JdtUtility.findDeclaringType(this.m_containerElement));
                    }
                    catch (CoreException e) {
                        SdkUtilActivator.logError(e);
                    }
                    return false;
                }
            }
        }
        return super.visit(node);
    }

    @Override
    public boolean visit(SimpleName node) {
        if (this.m_canceled) {
            return false;
        }
        if (this.m_currentVariable != null) {
            switch (this.m_mode) {
                case 7: 
                case 44: 
                case 59: {
                    if (this.m_currentVariable.variableName != null) break;
                    if (this.m_variableName.equals(node.getFullyQualifiedName())) {
                        this.m_currentVariable.variableName = this.m_variableName;
                    } else {
                        this.m_currentVariable = null;
                    }
                    return false;
                }
            }
        }
        return super.visit(node);
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        if (this.m_canceled) {
            return false;
        }
        this.m_mode = node.getNodeType();
        this.m_currentVariable = new P_Variable();
        return true;
    }

    public void endVisit(VariableDeclarationStatement node) {
        if (this.m_canceled) {
            return;
        }
        if (this.m_mode == node.getNodeType()) {
            if (this.m_currentVariable != null) {
                this.store(this.m_currentVariable);
                this.m_currentVariable = null;
            }
            this.m_mode = -1;
        }
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        if (this.m_canceled) {
            return false;
        }
        this.m_mode = node.getNodeType();
        if (this.m_currentVariable == null) {
            this.m_currentVariable = new P_Variable();
        }
        return true;
    }

    public void endVisit(VariableDeclarationFragment node) {
        if (this.m_canceled) {
            return;
        }
        if (this.m_mode == node.getNodeType()) {
            if (this.m_currentVariable != null) {
                this.store(this.m_currentVariable);
                this.m_currentVariable = null;
            }
            this.m_mode = -1;
        }
    }

    @Override
    public boolean visit(Assignment node) {
        if (this.m_canceled) {
            return false;
        }
        this.m_mode = node.getNodeType();
        if (this.m_currentVariable == null) {
            this.m_currentVariable = new P_Variable();
        }
        return true;
    }

    public void endVisit(Assignment node) {
        if (this.m_canceled) {
            return;
        }
        if (this.m_mode == node.getNodeType()) {
            if (this.m_currentVariable != null) {
                this.store(this.m_currentVariable);
                this.m_currentVariable = null;
            }
            this.m_mode = -1;
        }
    }

    @Override
    public boolean visit(MethodInvocation node) {
        if (this.m_canceled) {
            return false;
        }
        if (this.m_currentVariable != null) {
            TypeSignatureResolveVisitor innerVisitor = new TypeSignatureResolveVisitor(this.m_rootNode, this.m_containerElement);
            node.accept((ASTVisitor)innerVisitor);
            String[] assignedSignatures = innerVisitor.getAssignedSignatures();
            if (assignedSignatures.length > 0) {
                String[] stringArray = assignedSignatures;
                int n = assignedSignatures.length;
                int n2 = 0;
                while (n2 < n) {
                    String as = stringArray[n2];
                    this.m_assignedTypes.add(as);
                    ++n2;
                }
            }
            if (this.m_variableTypeSignature == null && innerVisitor.getTypeSignature() != null) {
                this.m_variableTypeSignature = innerVisitor.getTypeSignature();
            }
            return false;
        }
        return super.visit(node);
    }

    private void store(P_Variable var) {
        if (var != null && var.isAssigned()) {
            if (this.m_variableTypeSignature == null) {
                this.m_variableTypeSignature = var.variableTypeName;
            }
            for (String s : var.assignedTypeName) {
                this.m_assignedTypes.add(s);
            }
        }
    }

    public String[] getAssignedTypesSignatures() {
        return this.m_assignedTypes.toArray(new String[this.m_assignedTypes.size()]);
    }

    public String getVariableTypeSignature() {
        return this.m_variableTypeSignature;
    }

    private class P_Variable {
        public String variableTypeName;
        public String variableName;
        public HashSet<String> assignedTypeName = new HashSet();

        private P_Variable() {
        }

        public boolean isAssigned() {
            return this.variableName != null && (this.assignedTypeName != null || !this.variableTypeName.isEmpty());
        }
    }
}

