/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeCache;

public final class TypeCache
implements ITypeCache {
    private static final TypeCache INSTANCE = new TypeCache();
    private static final Comparator<IType> COMPARATOR = new P_TypeMatchComparator();
    private static final String PDE_BUNDLE_POOL_IDENTIFYER = ".bundle_pool";
    private final Map<String, TreeSet<IType>> m_cache = new HashMap<String, TreeSet<IType>>();
    private final P_ResourceListener m_resourceChangeListener = new P_ResourceListener();

    public static TypeCache getInstance() {
        return INSTANCE;
    }

    private TypeCache() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.m_resourceChangeListener);
        this.clearCache();
    }

    public synchronized void clearCache() {
        this.m_cache.clear();
    }

    public synchronized Set<IType> getAllCachedTypes() {
        HashSet<IType> types = new HashSet<IType>();
        for (Set set : this.m_cache.values()) {
            types.addAll(set);
        }
        return types;
    }

    @Override
    public IType getType(String typeName) {
        TreeSet<IType> types = this.getTypesInternal(typeName);
        if (types != null && types.size() > 0) {
            return types.first();
        }
        return null;
    }

    @Override
    public Set<IType> getTypes(String typeName) {
        TreeSet<IType> types = this.getTypesInternal(typeName);
        if (types == null) {
            return new TreeSet<IType>();
        }
        return new TreeSet<IType>((SortedSet<IType>)types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<IType> getTypesInternal(String typeName) {
        if (StringUtility.isNullOrEmpty((CharSequence)typeName)) {
            return null;
        }
        typeName = typeName.replace('$', '.');
        TreeSet<IType> types = null;
        TypeCache typeCache = this;
        synchronized (typeCache) {
            types = this.m_cache.get(typeName);
            if (types != null) {
                if (types.size() > 0) {
                    Iterator<IType> it = types.iterator();
                    while (it.hasNext()) {
                        IType type = it.next();
                        if (TypeUtility.exists((IJavaElement)type)) continue;
                        it.remove();
                    }
                }
                if (types.size() == 0) {
                    this.m_cache.remove(typeName);
                    types = null;
                }
            }
        }
        if (types == null) {
            try {
                types = this.resolveType(typeName);
                typeCache = this;
                synchronized (typeCache) {
                    if (types != null && types.size() > 0) {
                        this.m_cache.put(typeName, types);
                    }
                }
            }
            catch (CoreException e) {
                SdkUtilActivator.logError("error resolving type '" + typeName + "'.", e);
            }
        }
        return types;
    }

    private TreeSet<IType> resolveType(final String fqn) throws CoreException {
        String fastPat = Signature.getSimpleName((String)fqn);
        final TreeSet<IType> matchList = new TreeSet<IType>(COMPARATOR);
        new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createWorkspaceScope(), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType t;
                Object element = match.getElement();
                if (element instanceof IType && (t = (IType)element).getFullyQualifiedName('.').indexOf(fqn) >= 0) {
                    matchList.add(t);
                }
            }
        }, null);
        return matchList;
    }

    void elementChanged(JdtEvent e) {
        switch (e.getEventType()) {
            case 1: 
            case 4: {
                if (e.getElementType() == 2) {
                    if ((e.getFlags() & 0x200) == 0 && e.getFlags() != 0) break;
                    this.clearCache();
                    break;
                }
                if (e.getElementType() != 3 || (e.getFlags() & 0x81C0) == 0 && e.getFlags() != 0) break;
                this.clearCache();
            }
        }
    }

    private final class P_ResourceListener
    implements IResourceChangeListener {
        private P_ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta visitDelta) {
                            IResource resource = visitDelta.getResource();
                            if (resource.getType() == 4 && (visitDelta.getFlags() & 0x4002) != 0) {
                                TypeCache.this.clearCache();
                            }
                            return resource.getType() > 4;
                        }
                    });
                } else if (event.getType() == 4 && event.getResource().getType() == 4) {
                    TypeCache.this.clearCache();
                }
            }
            catch (CoreException e) {
                SdkUtilActivator.logWarning(e);
            }
        }
    }

    private static final class P_TypeMatchComparator
    implements Comparator<IType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private P_TypeMatchComparator() {
        }

        @Override
        public int compare(IType o1, IType o2) {
            boolean p2;
            boolean b2;
            if (o1 == o2) {
                return 0;
            }
            boolean b1 = o1.isBinary();
            if (b1 != (b2 = o2.isBinary())) {
                if (b1) {
                    return 1;
                }
                return -1;
            }
            String path1 = this.buildPath(o1);
            String path2 = this.buildPath(o2);
            boolean p1 = path1.contains(TypeCache.PDE_BUNDLE_POOL_IDENTIFYER);
            if (p1 != (p2 = path2.contains(TypeCache.PDE_BUNDLE_POOL_IDENTIFYER))) {
                if (p1) {
                    return -1;
                }
                return 1;
            }
            return path2.compareTo(path1);
        }

        private String buildPath(IType t) {
            String fqn = t.getFullyQualifiedName();
            String portableString = t.getPath().toPortableString();
            StringBuilder sb = new StringBuilder(fqn.length() + portableString.length());
            sb.append(fqn);
            sb.append(portableString);
            return sb.toString();
        }
    }
}

