/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.IResolvedTypeParameter;
import org.eclipse.scout.sdk.util.signature.ITypeParameterMapping;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.internal.TypeParameterMapping;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;

public final class SignatureUtility {
    public static final char C_ARBITRARY_ARRAY = '|';
    public static final int ARBITRARY_ARRAY_SIGNATURE = 29;
    public static final String SIG_OBJECT = SignatureCache.createTypeSignature(Object.class.getName());

    private SignatureUtility() {
    }

    public static String unboxPrimitiveSignature(String signature) {
        if (Signature.getTypeSignatureKind((String)signature) == 2) {
            if ("Z".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Boolean.class.getName());
            } else if ("B".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Byte.class.getName());
            } else if ("C".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Character.class.getName());
            } else if ("D".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Double.class.getName());
            } else if ("F".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Float.class.getName());
            } else if ("I".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Integer.class.getName());
            } else if ("J".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Long.class.getName());
            } else if ("S".equals(signature)) {
                signature = SignatureCache.createTypeSignature(Short.class.getName());
            }
        }
        return signature;
    }

    public static int getTypeSignatureKind(String signature) {
        if (signature == null || signature.length() < 1) {
            throw new IllegalArgumentException("signature is null or less than 1 char.");
        }
        char c = signature.charAt(0);
        if (c == '|') {
            return 29;
        }
        return Signature.getTypeSignatureKind((String)signature);
    }

    public static String getResolvedSignature(String signature, IType signatureOwner) throws CoreException {
        return SignatureUtility.getResolvedSignature(signature, signatureOwner, null);
    }

    public static String getResolvedSignature(String signature, IType signatureOwner, IType contextType) throws CoreException {
        Map<String, ITypeParameterMapping> mappings;
        ITypeParameterMapping mapping;
        Map<String, IResolvedTypeParameter> genericParameters = null;
        if (TypeUtility.exists((IJavaElement)contextType) && TypeUtility.exists((IJavaElement)signatureOwner) && (mapping = (mappings = SignatureUtility.resolveTypeParameters(contextType)).get(signatureOwner.getFullyQualifiedName())) != null) {
            genericParameters = mapping.getTypeParameters();
        }
        return SignatureUtility.getResolvedSignature(signatureOwner, genericParameters, signature);
    }

    public static String getResolvedSignature(IType contextType, Map<String, ? extends IResolvedTypeParameter> parameterSignatures, String unresolvedSignature) throws JavaModelException {
        StringBuilder sigBuilder = new StringBuilder();
        unresolvedSignature = SignatureUtility.ensureSourceTypeParametersAreCorrect(unresolvedSignature, contextType);
        switch (SignatureUtility.getTypeSignatureKind(unresolvedSignature)) {
            case 5: {
                sigBuilder.append(unresolvedSignature.charAt(0));
                if (unresolvedSignature.length() <= 1) break;
                sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, unresolvedSignature.substring(1)));
                break;
            }
            case 4: {
                sigBuilder.append('[');
                sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, unresolvedSignature.substring(1)));
                break;
            }
            case 29: {
                sigBuilder.append('|');
                sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, unresolvedSignature.substring(1)));
                break;
            }
            case 2: {
                if (SignatureUtility.endsWith(unresolvedSignature, ';')) {
                    unresolvedSignature = unresolvedSignature.substring(0, unresolvedSignature.length() - 1);
                }
                sigBuilder.append(unresolvedSignature);
                break;
            }
            case 3: {
                IResolvedTypeParameter typeGeneric = null;
                if (parameterSignatures != null) {
                    typeGeneric = parameterSignatures.get(Signature.getSignatureSimpleName((String)unresolvedSignature));
                }
                String sig = null;
                if (typeGeneric != null) {
                    sig = (String)CollectionUtility.firstElement(typeGeneric.getBoundsSignatures());
                }
                if (SignatureUtility.isUnresolved(sig)) {
                    sig = SignatureUtility.resolveSignature(sig, contextType);
                }
                if (sig != null) {
                    sigBuilder.append(sig);
                    break;
                }
                sigBuilder.append(SIG_OBJECT);
                break;
            }
            case 1: {
                String[] typeArguments = Signature.getTypeArguments((String)unresolvedSignature);
                unresolvedSignature = Signature.getTypeErasure((String)unresolvedSignature);
                unresolvedSignature = unresolvedSignature.replace('$', '.');
                if (SignatureUtility.isUnresolved(unresolvedSignature)) {
                    unresolvedSignature = SignatureUtility.resolveSignature(unresolvedSignature, contextType);
                }
                if (SignatureUtility.endsWith(unresolvedSignature, ';')) {
                    unresolvedSignature = unresolvedSignature.substring(0, unresolvedSignature.length() - 1);
                }
                sigBuilder.append(unresolvedSignature);
                if (typeArguments.length > 0) {
                    sigBuilder.append('<');
                    int i = 0;
                    while (i < typeArguments.length) {
                        sigBuilder.append(SignatureUtility.getResolvedSignature(contextType, parameterSignatures, typeArguments[i]));
                        ++i;
                    }
                    sigBuilder.append('>');
                }
                sigBuilder.append(';');
                break;
            }
            default: {
                SdkUtilActivator.logWarning("Unhandled signature type: '" + Signature.getTypeSignatureKind((String)unresolvedSignature) + "'.");
            }
        }
        return sigBuilder.toString();
    }

    public static boolean isUnresolved(String signature) {
        if (signature == null) {
            return false;
        }
        if (SignatureUtility.startsWith(signature, '+')) {
            signature = signature.substring(1);
        }
        return SignatureUtility.startsWith(signature, 'Q');
    }

    private static String resolveSignature(String unresolvedSignature, IType contextType) throws JavaModelException {
        String referencedTypeSignature;
        IType t;
        String name = Signature.toString((String)unresolvedSignature);
        if (StringUtility.hasText((CharSequence)Signature.getSignatureQualifier((String)unresolvedSignature)) && TypeUtility.exists((IJavaElement)(t = TypeUtility.getTypeBySignature(unresolvedSignature))) && t.getFullyQualifiedName().equals(name)) {
            return SignatureCache.createTypeSignature(t.getFullyQualifiedName().replace('$', '.'));
        }
        if (TypeUtility.exists((IJavaElement)contextType) && (referencedTypeSignature = SignatureUtility.getReferencedTypeSignature(contextType, name, false)) != null) {
            return referencedTypeSignature;
        }
        return unresolvedSignature;
    }

    private static boolean endsWith(String stringToSearchIn, char charToFind) {
        return stringToSearchIn != null && !stringToSearchIn.isEmpty() && stringToSearchIn.charAt(stringToSearchIn.length() - 1) == charToFind;
    }

    private static boolean startsWith(String stringToSearchIn, char charToFind) {
        return stringToSearchIn != null && !stringToSearchIn.isEmpty() && stringToSearchIn.charAt(0) == charToFind;
    }

    public static boolean isEqualSignature(String signature1, String signature2) {
        if (signature1 == null && signature2 == null) {
            return true;
        }
        if (signature1 == null || signature2 == null) {
            return false;
        }
        signature1 = IRegEx.DOLLAR_REPLACEMENT.matcher(signature1).replaceAll(".");
        signature2 = IRegEx.DOLLAR_REPLACEMENT.matcher(signature2).replaceAll(".");
        return signature1.equals(signature2);
    }

    public static String getTypeReference(String signature, IImportValidator validator) throws CoreException {
        StringBuilder sigBuilder = new StringBuilder();
        int arrayCount = 0;
        boolean isArbitraryArray = false;
        switch (SignatureUtility.getTypeSignatureKind(signature)) {
            case 5: {
                sigBuilder.append("?");
                if (signature.length() <= 1) break;
                sigBuilder.append(" extends ");
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(1), validator));
                break;
            }
            case 4: {
                arrayCount = Signature.getArrayCount((String)signature);
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(arrayCount), validator));
                break;
            }
            case 29: {
                isArbitraryArray = true;
                sigBuilder.append(SignatureUtility.getTypeReference(signature.substring(1), validator));
                break;
            }
            case 2: {
                sigBuilder.append(Signature.getSignatureSimpleName((String)signature));
                break;
            }
            case 3: {
                sigBuilder.append(Signature.toString((String)signature));
                break;
            }
            default: {
                String[] typeArguments = Signature.getTypeArguments((String)signature);
                signature = Signature.getTypeErasure((String)signature).replace('$', '.');
                sigBuilder.append(validator.getTypeName(signature));
                if (typeArguments == null || typeArguments.length <= 0) break;
                sigBuilder.append('<');
                int i = 0;
                while (i < typeArguments.length) {
                    if (i > 0) {
                        sigBuilder.append(", ");
                    }
                    sigBuilder.append(SignatureUtility.getTypeReference(typeArguments[i], validator));
                    ++i;
                }
                sigBuilder.append('>');
            }
        }
        int i = 0;
        while (i < arrayCount) {
            sigBuilder.append("[]");
            ++i;
        }
        if (isArbitraryArray) {
            sigBuilder.append("...");
        }
        return sigBuilder.toString();
    }

    public static List<String> getMethodParameterSignatureResolved(IMethod method) throws CoreException {
        return SignatureUtility.getMethodParameterSignatureResolved(method, method.getDeclaringType());
    }

    public static List<String> getMethodParameterSignatureResolved(IMethod jdtMethod, IType contextType) throws CoreException {
        Map<String, ITypeParameterMapping> mappings;
        ITypeParameterMapping mapping;
        Map<String, IResolvedTypeParameter> parameters = null;
        if (jdtMethod.getParameterTypes().length > 0 && (mapping = (mappings = SignatureUtility.resolveTypeParameters(contextType)).get(jdtMethod.getDeclaringType().getFullyQualifiedName())) != null) {
            parameters = mapping.getTypeParameters();
        }
        return SignatureUtility.getMethodParameterSignatureResolved(jdtMethod, parameters);
    }

    public static List<String> getMethodParameterSignatureResolved(IMethod jdtMethod, Map<String, IResolvedTypeParameter> generics) throws CoreException {
        List<String> methodParameterSignature = SignatureUtility.getMethodParameterSignature(jdtMethod);
        IType methodOwnerType = jdtMethod.getDeclaringType();
        int i = 0;
        while (i < methodParameterSignature.size()) {
            methodParameterSignature.set(i, SignatureUtility.getResolvedSignature(methodOwnerType, generics, methodParameterSignature.get(i)));
            ++i;
        }
        return methodParameterSignature;
    }

    public static List<String> getMethodParameterSignature(IMethod method) throws JavaModelException {
        String[] paramNames = method.getParameterNames();
        ArrayList paramSignatures = CollectionUtility.arrayList((Object[])method.getParameterTypes());
        if (paramSignatures.size() > 0) {
            String regex;
            String source;
            String lastSig = (String)paramSignatures.get(paramSignatures.size() - 1);
            String lastParamName = paramNames[paramNames.length - 1];
            if (Signature.getTypeSignatureKind((String)lastSig) == 4 && (source = method.getSource()) != null && Pattern.compile(regex = String.valueOf(method.getElementName()) + "\\s*\\(.*([\\.]{3})\\s*" + lastParamName + "\\s*\\)", 8).matcher(source).find()) {
                paramSignatures.set(paramSignatures.size() - 1, lastSig.replaceFirst("^\\[", "|"));
            }
        }
        return paramSignatures;
    }

    public static String getReturnTypeSignatureResolved(IMethod method, IType contextType) throws CoreException {
        String returnTypeSignature = method.getReturnType();
        IType methodDeclaringType = method.getDeclaringType();
        returnTypeSignature = SignatureUtility.getResolvedSignature(returnTypeSignature, methodDeclaringType, contextType);
        return returnTypeSignature;
    }

    public static String ensureSourceTypeParametersAreCorrect(String signature, IType signatureOwner) throws JavaModelException {
        ITypeParameter[] typeParameters;
        if (!TypeUtility.exists((IJavaElement)signatureOwner) || signatureOwner.isBinary()) {
            return signature;
        }
        if (Signature.getTypeSignatureKind((String)signature) == 3) {
            return signature;
        }
        ITypeParameter[] iTypeParameterArray = typeParameters = signatureOwner.getTypeParameters();
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeParameter tp = iTypeParameterArray[n2];
            String typeParamName = tp.getElementName();
            if (CompareUtility.equals((Object)typeParamName, (Object)Signature.getSignatureSimpleName((String)signature))) {
                return new StringBuilder(typeParamName.length() + 2).append('T').append(typeParamName).append(';').toString();
            }
            ++n2;
        }
        IType declaringType = signatureOwner.getDeclaringType();
        if (TypeUtility.exists((IJavaElement)declaringType)) {
            return SignatureUtility.ensureSourceTypeParametersAreCorrect(signature, declaringType);
        }
        return signature;
    }

    public static String getMethodIdentifier(IMethod method) throws CoreException {
        return SignatureUtility.getMethodIdentifier(method.getElementName(), SignatureUtility.getMethodParameterSignatureResolved(method, method.getDeclaringType()));
    }

    public static String getMethodIdentifier(String methodName, List<String> resolvedParamSignatures) {
        StringBuilder methodIdBuilder = new StringBuilder();
        methodIdBuilder.append(methodName);
        methodIdBuilder.append('(');
        Iterator<String> iterator = resolvedParamSignatures.iterator();
        if (iterator.hasNext()) {
            methodIdBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                methodIdBuilder.append(',');
                methodIdBuilder.append(iterator.next());
            }
        }
        methodIdBuilder.append(')');
        return methodIdBuilder.toString();
    }

    public static String getFullyQualifiedName(String signature) {
        int arrayCount = Signature.getArrayCount((String)(signature = Signature.getTypeErasure((String)signature)));
        if (arrayCount > 0) {
            signature = signature.substring(arrayCount);
        }
        String fqn = Signature.toString((String)signature);
        return fqn;
    }

    public static Map<String, ITypeParameterMapping> resolveTypeParameters(String signature, String superClassSignature, List<String> interfaceSignatures) throws CoreException {
        IType superType;
        if (!StringUtility.hasText((CharSequence)signature)) {
            return CollectionUtility.emptyHashMap();
        }
        HashMap<String, TypeParameterMapping> collector = new HashMap<String, TypeParameterMapping>();
        TypeParameterMapping first = new TypeParameterMapping(signature, superClassSignature, interfaceSignatures);
        collector.put(Signature.toString((String)signature), first);
        if (StringUtility.hasText((CharSequence)superClassSignature) && TypeUtility.exists((IJavaElement)(superType = TypeUtility.getTypeBySignature(superClassSignature)))) {
            TypeParameterMapping.buildMapping(superType, null, collector, first);
        }
        if (CollectionUtility.hasElements(interfaceSignatures)) {
            for (String ifcSig : interfaceSignatures) {
                IType interfaceType = TypeUtility.getTypeBySignature(ifcSig);
                if (!TypeUtility.exists((IJavaElement)interfaceType)) continue;
                TypeParameterMapping.buildMapping(interfaceType, null, collector, first);
            }
        }
        return new HashMap<String, ITypeParameterMapping>(collector);
    }

    public static String resolveTypeParameter(IType type, String paramDefiningSuperTypeFqn, int paramIndex) throws CoreException {
        return SignatureUtility.resolveTypeParameter(type, null, paramDefiningSuperTypeFqn, paramIndex);
    }

    public static String resolveTypeParameter(IType type, ITypeHierarchy supertypeHierarchy, String paramDefiningSuperTypeFqn, int paramIndex) throws CoreException {
        return SignatureUtility.resolveTypeParameter(type, supertypeHierarchy, paramDefiningSuperTypeFqn, paramIndex, null);
    }

    public static String resolveTypeParameter(IType type, ITypeHierarchy supertypeHierarchy, String paramDefiningSuperTypeFqn, int paramIndex, Collection<IType> declaringChildContextsInToOut) throws CoreException {
        if (!TypeUtility.exists((IJavaElement)type) || !StringUtility.hasText((CharSequence)paramDefiningSuperTypeFqn) || paramIndex < 0) {
            return null;
        }
        HashMap<String, TypeParameterMapping> collector = new HashMap<String, TypeParameterMapping>();
        TypeParameterMapping.buildMapping(type, supertypeHierarchy, collector, declaringChildContextsInToOut);
        ITypeParameterMapping mapping = (ITypeParameterMapping)collector.get(paramDefiningSuperTypeFqn);
        if (mapping == null) {
            return null;
        }
        Set<String> bounds = mapping.getTypeParameterBounds(paramIndex);
        return (String)CollectionUtility.firstElement(bounds);
    }

    public static Map<String, ITypeParameterMapping> resolveTypeParameters(IType type) throws CoreException {
        return SignatureUtility.resolveTypeParameters(type, null);
    }

    public static Map<String, ITypeParameterMapping> resolveTypeParameters(IType type, ITypeHierarchy supertypeHierarchy) throws CoreException {
        return SignatureUtility.resolveTypeParameters(type, supertypeHierarchy, null);
    }

    public static Map<String, ITypeParameterMapping> resolveTypeParameters(IType type, ITypeHierarchy supertypeHierarchy, Collection<IType> declaringChildContextsInToOut) throws CoreException {
        if (!TypeUtility.exists((IJavaElement)type)) {
            return CollectionUtility.emptyHashMap();
        }
        HashMap<String, TypeParameterMapping> collector = new HashMap<String, TypeParameterMapping>();
        TypeParameterMapping.buildMapping(type, supertypeHierarchy, collector, declaringChildContextsInToOut);
        return new HashMap<String, ITypeParameterMapping>(collector);
    }

    public static String getReferencedTypeSignature(IType declaringType, String typeName, boolean searchOnClassPath) throws JavaModelException {
        String referencedTypeFqn = TypeUtility.getReferencedTypeFqn(declaringType, typeName, searchOnClassPath);
        if (referencedTypeFqn != null) {
            return SignatureCache.createTypeSignature(referencedTypeFqn);
        }
        return null;
    }
}

