/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.util.signature.IResolvedTypeParameter;
import org.eclipse.scout.sdk.util.signature.ITypeParameterMapping;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.signature.internal.ResolvedTypeParameter;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;

public class TypeParameterMapping
implements ITypeParameterMapping {
    private final IType m_type;
    private final String m_fullyQualifiedName;
    private final Map<String, ResolvedTypeParameter> m_typeParametersByName;
    private final List<ResolvedTypeParameter> m_typeParametersByIndex;
    private final Map<String, List<String>> m_superParametersByType;
    private final Map<String, TypeParameterMapping> m_superMappings;
    private final Map<String, TypeParameterMapping> m_subMappings;

    public TypeParameterMapping(String signature, String superTypeSignature, List<String> superInterfacesSignatures) throws CoreException {
        this.m_type = null;
        this.m_superMappings = new LinkedHashMap<String, TypeParameterMapping>();
        this.m_subMappings = new LinkedHashMap<String, TypeParameterMapping>();
        this.m_fullyQualifiedName = Signature.toString((String)Signature.getTypeErasure((String)signature));
        String[] localParameterSignatures = Signature.getTypeParameters((String)signature);
        this.m_typeParametersByName = new LinkedHashMap<String, ResolvedTypeParameter>(localParameterSignatures.length);
        this.m_typeParametersByIndex = new ArrayList<ResolvedTypeParameter>(localParameterSignatures.length);
        String[] stringArray = localParameterSignatures;
        int n = localParameterSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String localParamSig = stringArray[n2];
            ResolvedTypeParameter parameter = new ResolvedTypeParameter(this, localParamSig, this.m_typeParametersByName.size());
            this.m_typeParametersByName.put(Signature.getSignatureSimpleName((String)localParamSig), parameter);
            this.m_typeParametersByIndex.add(parameter);
            ++n2;
        }
        this.m_superParametersByType = this.getSuperTypeParameters(superTypeSignature, superInterfacesSignatures, null);
    }

    public TypeParameterMapping(IType t, TypeParameterMapping child, Map<String, IResolvedTypeParameter> declaringTypeParams) throws CoreException {
        this.m_type = t;
        this.m_fullyQualifiedName = t.getFullyQualifiedName();
        ITypeParameter[] typeParameters = this.getType().getTypeParameters();
        this.m_typeParametersByName = new LinkedHashMap<String, ResolvedTypeParameter>(typeParameters.length);
        this.m_typeParametersByIndex = new ArrayList<ResolvedTypeParameter>(typeParameters.length);
        int i = 0;
        while (i < typeParameters.length) {
            ITypeParameter myTypeParam = typeParameters[i];
            Set<String> childBounds = null;
            String curParamNameInSuperTypeDeclaration = this.getParamNameInSuperTypeDeclaration(child, i);
            if (curParamNameInSuperTypeDeclaration != null) {
                ResolvedTypeParameter matchingChildTypeParam = this.getMatchingChildTypeParam(child, curParamNameInSuperTypeDeclaration);
                if (matchingChildTypeParam != null) {
                    childBounds = matchingChildTypeParam.getBoundsSignatures();
                } else {
                    childBounds = new LinkedHashSet<String>(1);
                    childBounds.add(curParamNameInSuperTypeDeclaration);
                }
            }
            ResolvedTypeParameter parameter = new ResolvedTypeParameter(this, child, myTypeParam, childBounds, this.m_typeParametersByName, this.m_typeParametersByName.size());
            this.m_typeParametersByName.put(myTypeParam.getElementName(), parameter);
            this.m_typeParametersByIndex.add(parameter);
            ++i;
        }
        this.m_superParametersByType = this.getSuperTypeParameters(t.getSuperclassTypeSignature(), CollectionUtility.arrayList((Object[])t.getSuperInterfaceTypeSignatures()), declaringTypeParams);
        this.m_superMappings = new LinkedHashMap<String, TypeParameterMapping>();
        this.m_subMappings = new LinkedHashMap<String, TypeParameterMapping>();
        this.connectWithChild(child);
    }

    private ResolvedTypeParameter getMatchingChildTypeParam(TypeParameterMapping child, String curParamNameInSuperTypeDeclaration) {
        if (Signature.getTypeSignatureKind((String)curParamNameInSuperTypeDeclaration) == 3) {
            return child.getTypeParameter(Signature.getSignatureSimpleName((String)curParamNameInSuperTypeDeclaration));
        }
        return null;
    }

    private String getParamNameInSuperTypeDeclaration(TypeParameterMapping child, int typeParamIndex) {
        List<String> paramNamesInSuperTypeDeclaration;
        if (child != null && (paramNamesInSuperTypeDeclaration = child.getSuperTypeParameters(this.getType())) != null && paramNamesInSuperTypeDeclaration.size() > typeParamIndex) {
            String curParamNameInSuperTypeDeclaration = paramNamesInSuperTypeDeclaration.get(typeParamIndex);
            return curParamNameInSuperTypeDeclaration;
        }
        return null;
    }

    private void connectWithChild(TypeParameterMapping child) {
        if (child != null) {
            child.addSuperMapping(this);
            int i = 0;
            for (ResolvedTypeParameter param : this.m_typeParametersByName.values()) {
                String curParamNameInSuperTypeDeclaration;
                if ((curParamNameInSuperTypeDeclaration = this.getParamNameInSuperTypeDeclaration(child, i++)) == null) continue;
                ResolvedTypeParameter matchingChildTypeParam = this.getMatchingChildTypeParam(child, curParamNameInSuperTypeDeclaration);
                if (matchingChildTypeParam == null) {
                    matchingChildTypeParam = this.getTypeParameterOfSigArgument(child, curParamNameInSuperTypeDeclaration);
                }
                if (matchingChildTypeParam == null) continue;
                matchingChildTypeParam.addReference(param);
            }
        }
    }

    private ResolvedTypeParameter getTypeParameterOfSigArgument(TypeParameterMapping child, String sig) {
        List<String> typeVarArgs = this.getTypeVariableSignatureArguments(sig);
        while (CollectionUtility.size(typeVarArgs) == 1) {
            String curTypeVarArg = typeVarArgs.get(0);
            ResolvedTypeParameter matchingChildTypeParam = this.getMatchingChildTypeParam(child, curTypeVarArg);
            if (matchingChildTypeParam != null) {
                return matchingChildTypeParam;
            }
            typeVarArgs = this.getTypeVariableSignatureArguments(curTypeVarArg);
        }
        return null;
    }

    private List<String> getTypeVariableSignatureArguments(String sig) {
        String[] args = Signature.getTypeArguments((String)sig);
        if (args.length < 1) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (Signature.getTypeSignatureKind((String)arg) == 3) {
                result.add(arg);
            }
            ++n2;
        }
        return result;
    }

    private static IType findContextType(Collection<IType> declaringChildContextsInToOut, ITypeHierarchy childHierarchy, IType superTypeToSearch) {
        for (IType candidate : declaringChildContextsInToOut) {
            if (!childHierarchy.getAllSupertypes(candidate).contains(superTypeToSearch)) continue;
            return candidate;
        }
        return null;
    }

    private static Deque<IType> getDeclaringTypesWithParameters(IType startType) throws JavaModelException {
        LinkedList<IType> result = new LinkedList<IType>();
        IType t = startType;
        while (TypeUtility.exists((IJavaElement)t)) {
            if (Flags.isStatic((int)t.getFlags())) break;
            if (TypeUtility.isGenericType(t)) {
                result.add(t);
            }
            t = t.getDeclaringType();
        }
        return result;
    }

    public static void buildMapping(IType type, ITypeHierarchy supertypeHierarchy, Map<String, TypeParameterMapping> collector, TypeParameterMapping child) throws CoreException {
        TypeParameterMapping.buildMappingRecInternal(type, supertypeHierarchy, collector, child, null);
    }

    public static void buildMapping(IType type, ITypeHierarchy supertypeHierarchy, Map<String, TypeParameterMapping> collector, Collection<IType> declaringChildContextsInToOut) throws CoreException {
        Deque<IType> declaringTypesInToOut;
        LinkedHashMap<String, IResolvedTypeParameter> declaringTypeParamMappings = null;
        if (CollectionUtility.hasElements(declaringChildContextsInToOut) && !(declaringTypesInToOut = TypeParameterMapping.getDeclaringTypesWithParameters(type)).isEmpty()) {
            ITypeHierarchy localTypeHierarchy = TypeUtility.getLocalTypeHierarchy(declaringChildContextsInToOut);
            Iterator<IType> outToInIterator = declaringTypesInToOut.descendingIterator();
            while (outToInIterator.hasNext()) {
                Map<String, IResolvedTypeParameter> typeParameters;
                Map<String, ITypeParameterMapping> resolveTypeParameters;
                ITypeParameterMapping paramMapping;
                IType declaringType = outToInIterator.next();
                IType childContext = TypeParameterMapping.findContextType(declaringChildContextsInToOut, localTypeHierarchy, declaringType);
                if (!TypeUtility.exists((IJavaElement)childContext) || (paramMapping = (resolveTypeParameters = SignatureUtility.resolveTypeParameters(childContext, localTypeHierarchy)).get(declaringType.getFullyQualifiedName())) == null || (typeParameters = paramMapping.getTypeParameters()).isEmpty()) continue;
                if (declaringTypeParamMappings == null) {
                    declaringTypeParamMappings = new LinkedHashMap<String, IResolvedTypeParameter>();
                }
                declaringTypeParamMappings.putAll(typeParameters);
            }
        }
        TypeParameterMapping.buildMappingRecInternal(type, supertypeHierarchy, collector, null, declaringTypeParamMappings);
    }

    private static void buildMappingRecInternal(IType type, ITypeHierarchy supertypeHierarchy, Map<String, TypeParameterMapping> collector, TypeParameterMapping child, Map<String, IResolvedTypeParameter> declaringTypeParams) throws CoreException {
        if (!TypeUtility.exists((IJavaElement)type)) {
            return;
        }
        String fullyQualifiedName = type.getFullyQualifiedName();
        TypeParameterMapping existing = collector.get(fullyQualifiedName);
        if (existing != null && child != null) {
            existing.connectWithChild(child);
            return;
        }
        if (supertypeHierarchy == null) {
            supertypeHierarchy = TypeUtility.getSupertypeHierarchy(type);
        }
        TypeParameterMapping curLevel = new TypeParameterMapping(type, child, declaringTypeParams);
        String objectClassFqn = Object.class.getName();
        collector.put(fullyQualifiedName, curLevel);
        if (supertypeHierarchy != null) {
            for (IType superType : supertypeHierarchy.getSupertypes(type)) {
                if (objectClassFqn.equals(superType.getFullyQualifiedName())) continue;
                TypeParameterMapping.buildMappingRecInternal(superType, supertypeHierarchy, collector, curLevel, declaringTypeParams);
            }
        }
    }

    private Map<String, List<String>> getSuperTypeParameters(String superclassTypeSignature, List<String> superInterfacesSignatures, Map<String, IResolvedTypeParameter> declaringTypeParams) throws CoreException {
        List<String> superTypeSigParams;
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(CollectionUtility.size(superInterfacesSignatures) + 1);
        if (superclassTypeSignature != null && !SignatureUtility.SIG_OBJECT.equals(superclassTypeSignature) && CollectionUtility.hasElements(superTypeSigParams = this.getTypeParametersForTypeSignature(superclassTypeSignature, declaringTypeParams))) {
            result.put(Signature.toString((String)Signature.getTypeErasure((String)superclassTypeSignature)), superTypeSigParams);
        }
        if (CollectionUtility.hasElements(superInterfacesSignatures)) {
            for (String superIfcSig : superInterfacesSignatures) {
                List<String> superInterfaceSigParams;
                if (superIfcSig == null || !CollectionUtility.hasElements(superInterfaceSigParams = this.getTypeParametersForTypeSignature(superIfcSig, declaringTypeParams))) continue;
                result.put(Signature.toString((String)Signature.getTypeErasure((String)superIfcSig)), superInterfaceSigParams);
            }
        }
        return result;
    }

    private List<String> getTypeParametersForTypeSignature(String sig, Map<String, IResolvedTypeParameter> declaringTypeParams) throws CoreException {
        String[] superTypeArgs = Signature.getTypeArguments((String)sig);
        if (superTypeArgs.length < 1) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(superTypeArgs.length);
        String[] stringArray = superTypeArgs;
        int n = superTypeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String superSig = stringArray[n2];
            if (Signature.getTypeSignatureKind((String)(superSig = SignatureUtility.ensureSourceTypeParametersAreCorrect(superSig, this.getType()))) == 3) {
                if (CollectionUtility.containsKey(declaringTypeParams, (Object)Signature.getSignatureSimpleName((String)superSig))) {
                    result.add(SignatureUtility.getResolvedSignature(this.getType(), declaringTypeParams, superSig));
                } else {
                    result.add(superSig);
                }
            } else {
                result.add(SignatureUtility.getResolvedSignature(this.getType(), this.m_typeParametersByName, superSig));
            }
            ++n2;
        }
        return result;
    }

    private void addSuperMapping(TypeParameterMapping superMapping) {
        this.m_superMappings.put(superMapping.getFullyQualifiedName(), superMapping);
        superMapping.m_subMappings.put(this.m_fullyQualifiedName, this);
    }

    @Override
    public Map<String, ITypeParameterMapping> getSuperMappings() {
        return new LinkedHashMap<String, ITypeParameterMapping>(this.m_superMappings);
    }

    @Override
    public Map<String, ITypeParameterMapping> getSubMappings() {
        return new LinkedHashMap<String, ITypeParameterMapping>(this.m_subMappings);
    }

    @Override
    public TypeParameterMapping getSubMapping(String fullyQualifiedName) {
        return this.m_subMappings.get(fullyQualifiedName);
    }

    @Override
    public TypeParameterMapping getSuperMapping(String fullyQualifiedName) {
        return this.m_superMappings.get(fullyQualifiedName);
    }

    private List<String> getSuperTypeParameters(IType type) {
        if (!TypeUtility.exists((IJavaElement)type)) {
            return null;
        }
        List<String> superTypeParameters = this.m_superParametersByType.get(type.getFullyQualifiedName());
        if (superTypeParameters != null) {
            return superTypeParameters;
        }
        return this.m_superParametersByType.get(type.getElementName());
    }

    @Override
    public ResolvedTypeParameter getTypeParameter(int index) {
        if (index < this.m_typeParametersByIndex.size()) {
            return this.m_typeParametersByIndex.get(index);
        }
        return null;
    }

    @Override
    public Set<String> getTypeParameterBounds(int index) {
        ResolvedTypeParameter typeParameter = this.getTypeParameter(index);
        if (typeParameter == null) {
            return null;
        }
        return typeParameter.getBoundsSignatures();
    }

    @Override
    public Set<String> getTypeParameterBounds(String name) {
        ResolvedTypeParameter typeParameter = this.getTypeParameter(name);
        if (typeParameter == null) {
            return null;
        }
        return typeParameter.getBoundsSignatures();
    }

    @Override
    public int getParameterCount() {
        return this.m_typeParametersByName.size();
    }

    @Override
    public ResolvedTypeParameter getTypeParameter(String name) {
        return this.m_typeParametersByName.get(name);
    }

    @Override
    public Map<String, IResolvedTypeParameter> getTypeParameters() {
        return new LinkedHashMap<String, IResolvedTypeParameter>(this.m_typeParametersByName);
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.m_fullyQualifiedName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_fullyQualifiedName == null ? 0 : this.m_fullyQualifiedName.hashCode());
        result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeParameterMapping)) {
            return false;
        }
        TypeParameterMapping other = (TypeParameterMapping)obj;
        if (this.m_fullyQualifiedName == null ? other.m_fullyQualifiedName != null : !this.m_fullyQualifiedName.equals(other.m_fullyQualifiedName)) {
            return false;
        }
        return !(this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type));
    }

    private void printSuperType(StringBuilder builder, Map.Entry<String, List<String>> superType) {
        builder.append(superType.getKey());
        Iterator<String> iterator = superType.getValue().iterator();
        if (iterator.hasNext()) {
            builder.append('<');
            builder.append(iterator.next());
            while (iterator.hasNext()) {
                builder.append(", ");
                builder.append(iterator.next());
            }
            builder.append('>');
        }
    }

    public String toString() {
        Iterator<Map.Entry<String, List<String>>> superIt;
        StringBuilder builder = new StringBuilder(this.getFullyQualifiedName());
        Iterator<ResolvedTypeParameter> it = this.m_typeParametersByName.values().iterator();
        if (it.hasNext()) {
            builder.append('<');
            builder.append(it.next().toString());
            while (it.hasNext()) {
                builder.append(", ");
                builder.append(it.next().toString());
            }
            builder.append('>');
        }
        if ((superIt = this.m_superParametersByType.entrySet().iterator()).hasNext()) {
            builder.append(" extends ");
            this.printSuperType(builder, superIt.next());
            while (superIt.hasNext()) {
                builder.append(", ");
                this.printSuperType(builder, superIt.next());
            }
        }
        return builder.toString();
    }
}

