/*******************************************************************************
 * Copyright (c) 2011 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Daniel Wiehl (BSI Business Systems Integration AG) - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsIcons;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsRuntimeClasses;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.CredentialValidationStrategyNewAction;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class CredentialValidationStrategyTablePage extends AbstractPage {

  private ICachedTypeHierarchy m_hierarchy;

  private ITypeHierarchyChangedListener m_hierarchyChangedListener;

  public CredentialValidationStrategyTablePage(IPage parent) {
    setParent(parent);
    setImageDescriptor(JaxWsSdk.getImageDescriptor(JaxWsIcons.CredentialValidationStrategyFolder));
    setName(Texts.get("CredentialValidation1"));

    m_hierarchy = TypeUtility.getTypeHierarchy(TypeUtility.getType(JaxWsRuntimeClasses.ICredentialValidationStrategy));
    m_hierarchyChangedListener = new P_TypeHierarchyChangedListener();
    m_hierarchy.addHierarchyListener(m_hierarchyChangedListener);
  }

  @Override
  public String getPageId() {
    return IJaxWsPageConstants.CREDENTIAL_VALIDATION_STRATEGY_TABLE_PAGE;
  }

  @Override
  public void unloadPage() {
    if (m_hierarchy != null && m_hierarchyChangedListener != null) {
      m_hierarchy.removeHierarchyListener(m_hierarchyChangedListener);
    }
  }

  @Override
  public boolean isFolder() {
    return true;
  }

  @Override
  public void refresh(boolean clearCache) {
    if (clearCache) {
      if (m_hierarchy == null) {
        m_hierarchy = TypeUtility.getTypeHierarchy(TypeUtility.getType(JaxWsRuntimeClasses.ICredentialValidationStrategy));
        m_hierarchyChangedListener = new P_TypeHierarchyChangedListener();
        m_hierarchy.addHierarchyListener(m_hierarchyChangedListener);
      }
      else {
        m_hierarchy.invalidate();
      }
    }
    super.refresh(clearCache);
  }

  @Override
  public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
    return newSet(CredentialValidationStrategyNewAction.class);
  }

  @Override
  protected void loadChildrenImpl() {
    if (m_hierarchy == null) {
      return;
    }

    // Scout SDK hierarchy (IPrimaryTypeTypeHierarchy) cannot be used as type creation events are not propagates because they are created by JDT NewClassWizardPage.
    List<IType> types = new ArrayList<IType>();
    try {
      for (IType type : m_hierarchy.getAllSubtypes(TypeUtility.getType(JaxWsRuntimeClasses.ICredentialValidationStrategy))) {
        if (TypeUtility.isOnClasspath(type, getScoutBundle().getJavaProject())
            && !type.isInterface() && !Flags.isAbstract(type.getFlags()) && !Signature.getQualifier(type.getFullyQualifiedName()).contains("internal")) {
          types.add(type);
        }
      }
    }
    catch (JavaModelException e) {
      JaxWsSdk.logError(e);
    }
    JaxWsSdkUtility.sortTypesByName(types, true);

    for (IType type : types) {
      new CredentialValidationStrategyNodePage(this, type);
    }
  }

  private class P_TypeHierarchyChangedListener implements ITypeHierarchyChangedListener {
    @Override
    public void hierarchyInvalidated() {
      markStructureDirty();
    }
  }
}
