/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.util.LinkedList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class SourceFolderCreateOrUpdateOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private IPath m_sourceFolder;

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public IPath getSourceFolder() {
        return this.m_sourceFolder;
    }

    public void setSourceFolder(IPath sourceFolder) {
        this.m_sourceFolder = sourceFolder;
    }

    public void validate() {
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFolder folder = JaxWsSdkUtility.getFolder(this.m_bundle, this.m_sourceFolder.makeRelativeTo(this.m_bundle.getProject().getFullPath()), true);
        LinkedList<IClasspathEntry> classpathEntries = new LinkedList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = this.m_bundle.getJavaProject().getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getPath().equals((Object)folder.getFullPath())) {
                return;
            }
            classpathEntries.add(entry);
            ++n2;
        }
        classpathEntries.add(JavaCore.newSourceEntry((IPath)folder.getFullPath()));
        this.m_bundle.getJavaProject().setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), this.m_bundle.getJavaProject().getOutputLocation(), monitor);
    }

    public String getOperationName() {
        return SourceFolderCreateOrUpdateOperation.class.getName();
    }
}

