/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.pages;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.ShowJavaReferencesAction;
import org.eclipse.scout.sdk.ui.action.delete.DeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.IJaxWsPageConstants;

public class SessionFactoryNodePage
extends AbstractPage
implements ITypePage {
    private IType m_type;

    public SessionFactoryNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setName(type.getElementName());
        this.m_type = type;
        if (type.isBinary()) {
            this.setImageDescriptor(JaxWsSdk.getImageDescriptor("session_binary.png"));
        } else {
            this.setImageDescriptor(JaxWsSdk.getImageDescriptor("session.png"));
        }
    }

    public String getPageId() {
        return IJaxWsPageConstants.SESSION_FACTORY_NODE_PAGE;
    }

    public int getQuality() {
        int quality = 0;
        if (this.getType().exists()) {
            quality = ScoutSeverityManager.getInstance().getSeverityOf((Object)this.getType());
        }
        return quality;
    }

    public boolean handleDoubleClickedDelegate() {
        if (this.getType() != null) {
            try {
                JavaUI.openInEditor((IJavaElement)this.getType());
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("could not open type in editor", e);
            }
            return true;
        }
        return false;
    }

    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        if (!this.m_type.isBinary()) {
            return this.newSet(new Class[]{DeleteAction.class, TypeRenameAction.class, ShowJavaReferencesAction.class});
        }
        return this.newSet(new Class[]{ShowJavaReferencesAction.class});
    }

    public boolean isFolder() {
        return false;
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }
}

