/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.BuildPropertyWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.BuildProperty;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class BuildPropertiesWizardPage
extends AbstractWorkspaceWizardPage {
    private List<BuildProperty> m_properties;
    private TableViewer m_tableViewer;
    private Button m_addButton;
    private Button m_editButton;
    private Button m_removeButton;

    public BuildPropertiesWizardPage() {
        super(BuildPropertiesWizardPage.class.getName());
        this.setTitle(Texts.get("WsBuildDirectives"));
        this.setDescription(Texts.get("DescriptionBuildDirectives"));
    }

    protected void createContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        Composite tableComposite = new Composite(container, 0);
        this.m_tableViewer = new TableViewer(new Table(tableComposite, 67584));
        this.m_tableViewer.setUseHashlookup(true);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        this.m_tableViewer.getTable().setLinesVisible(false);
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuildProperty property = (BuildProperty)((IStructuredSelection)BuildPropertiesWizardPage.this.m_tableViewer.getSelection()).getFirstElement();
                if (BuildPropertiesWizardPage.this.openEditPropertyWizard(property) != null) {
                    BuildPropertiesWizardPage.this.m_tableViewer.refresh((Object)property);
                }
            }
        });
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildPropertiesWizardPage.this.m_editButton.setEnabled(!event.getSelection().isEmpty());
                BuildPropertiesWizardPage.this.m_removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.m_tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && BuildPropertiesWizardPage.this.m_removeButton.isEnabled()) {
                    IStructuredSelection selection = (IStructuredSelection)BuildPropertiesWizardPage.this.m_tableViewer.getSelection();
                    for (BuildProperty property : selection) {
                        BuildPropertiesWizardPage.this.m_properties.remove(property);
                    }
                    BuildPropertiesWizardPage.this.m_tableViewer.refresh();
                }
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.m_tableViewer, 16384, 0);
        nameColumn.setLabelProvider((CellLabelProvider)new P_LabelProvider());
        nameColumn.getColumn().setResizable(false);
        nameColumn.getColumn().setText(Texts.get("Directive"));
        TableViewerColumn valueColumn = new TableViewerColumn(this.m_tableViewer, 16384, 1);
        valueColumn.setLabelProvider((CellLabelProvider)new P_LabelProvider());
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setText(Texts.get("Value"));
        this.m_tableViewer.setContentProvider((IContentProvider)new P_ContentProvider());
        this.m_tableViewer.setInput(this.m_properties);
        Composite buttonComposite = new Composite(container, 0);
        this.m_addButton = new Button(buttonComposite, 0x800008);
        this.m_addButton.setText(Texts.get("Add"));
        this.m_addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildProperty property = new BuildProperty();
                if ((property = BuildPropertiesWizardPage.this.openEditPropertyWizard(property)) != null) {
                    BuildPropertiesWizardPage.this.m_properties.add(property);
                    BuildPropertiesWizardPage.this.m_tableViewer.refresh();
                }
            }
        });
        this.m_editButton = new Button(buttonComposite, 0x800008);
        this.m_editButton.setText(Texts.get("Edit"));
        this.m_editButton.setEnabled(false);
        this.m_editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildProperty property = (BuildProperty)((IStructuredSelection)BuildPropertiesWizardPage.this.m_tableViewer.getSelection()).getFirstElement();
                if (BuildPropertiesWizardPage.this.openEditPropertyWizard(property) != null) {
                    BuildPropertiesWizardPage.this.m_tableViewer.refresh((Object)property);
                }
            }
        });
        this.m_removeButton = new Button(buttonComposite, 0x800008);
        this.m_removeButton.setText(Texts.get("Remove"));
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BuildPropertiesWizardPage.this.m_tableViewer.getSelection();
                for (BuildProperty property : selection) {
                    BuildPropertiesWizardPage.this.m_properties.remove(property);
                }
                BuildPropertiesWizardPage.this.m_tableViewer.refresh();
            }
        });
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        tableComposite.setLayoutData((Object)gd);
        gd = new GridData(1040);
        gd.horizontalAlignment = 128;
        buttonComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        this.m_addButton.setLayoutData((Object)new GridData(768));
        this.m_editButton.setLayoutData((Object)new GridData(768));
        this.m_removeButton.setLayoutData((Object)new GridData(768));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(30));
        tableLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(70));
    }

    private BuildProperty openEditPropertyWizard(BuildProperty property) {
        if (property == null) {
            return null;
        }
        HashSet<String> illegalNames = new HashSet<String>();
        for (BuildProperty prop : this.m_properties) {
            if (CompareUtility.equals((Object)property.getName(), (Object)prop.getName())) continue;
            illegalNames.add(prop.getName());
        }
        BuildPropertyWizard wizard = new BuildPropertyWizard();
        wizard.setDirective(property.getName());
        wizard.setValue(property.getValue());
        wizard.setIllegalNames(illegalNames);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setHelpAvailable(false);
        if (wizardDialog.open() == 0) {
            property.setName(wizard.getDirective());
            property.setValue(wizard.getValue());
            return property;
        }
        return null;
    }

    public List<BuildProperty> getProperties() {
        return this.m_properties;
    }

    public void setProperties(List<BuildProperty> properties) {
        this.m_properties = properties;
    }

    public class P_ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            List properties = (List)inputElement;
            return properties.toArray(new BuildProperty[properties.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class P_LabelProvider
    extends CellLabelProvider {
        private P_LabelProvider() {
        }

        public void update(ViewerCell cell) {
            BuildProperty property = (BuildProperty)cell.getElement();
            if (cell.getColumnIndex() == 0) {
                cell.setText(property.getName());
                cell.setImage(JaxWsSdk.getImage("property_obj.gif"));
            } else {
                cell.setText(property.getValue());
            }
        }
    }
}

