/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposalProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.eclipse.scout.sdk.ws.jaxws.validator.IUrlPatternValidation;
import org.eclipse.scout.sdk.ws.jaxws.validator.UrlPatternValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsPropertiesExistingWsdlWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_SERVICE = "service";
    public static final String PROP_PORT = "port";
    public static final String PROP_PORT_TYPE = "portType";
    public static final String PROP_DERIVE_OTHER_NAME = "deriveOtherNames";
    public static final String PROP_ALIAS = "alias";
    public static final String PROP_URL_PATTERN = "urlPattern";
    public static final String PROP_WSDL_DEFINITION = "wsdlDefinition";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private String m_jaxWsServletAlias;
    private ProposalTextField m_serviceField;
    private ProposalTextField m_portField;
    private StyledTextField m_portTypeField;
    private Button m_deriveOtherNameButton;
    private StyledTextField m_alias;
    private StyledTextField m_urlPattern;
    private Document m_sunJaxWsXml;
    private Set<String> m_illegalAliasNames;
    private Set<String> m_illegalUrlPatterns;
    private WebserviceEnum m_webserviceEnum;

    public WsPropertiesExistingWsdlWizardPage(IScoutBundle bundle, WebserviceEnum webserviceEnum) {
        super(WsPropertiesExistingWsdlWizardPage.class.getName());
        this.setTitle(Texts.get("ConfigureWebserviceProperties"));
        this.setDescription(Texts.get("ConfigureWebserviceProperties"));
        this.m_bundle = bundle;
        this.m_webserviceEnum = webserviceEnum;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_sunJaxWsXml = ResourceFactory.getSunJaxWsResource(bundle).loadXml();
        this.m_jaxWsServletAlias = "/jaxws";
        this.setDeriveOtherNames(true);
        this.loadIllegalValues();
    }

    protected void createContent(Composite parent) {
        this.m_serviceField = this.getFieldToolkit().createProposalField(parent, Texts.get("Service"));
        this.m_serviceField.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        this.m_serviceField.addProposalAdapterListener(new IProposalAdapterListener(){

            public void proposalAccepted(ContentProposalEvent event) {
                Object proposal = event.proposal;
                if (proposal != null) {
                    WsPropertiesExistingWsdlWizardPage.this.setServiceInternal(((P_ServiceProposal)((Object)proposal)).getService());
                } else {
                    WsPropertiesExistingWsdlWizardPage.this.setServiceInternal(null);
                }
                WsPropertiesExistingWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_portField = this.getFieldToolkit().createProposalField(parent, Texts.get("Port"));
        this.m_portField.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        this.m_portField.addProposalAdapterListener(new IProposalAdapterListener(){

            public void proposalAccepted(ContentProposalEvent event) {
                Object proposal = event.proposal;
                if (proposal != null) {
                    WsPropertiesExistingWsdlWizardPage.this.setPortInternal(((P_PortProposal)((Object)proposal)).getPort());
                } else {
                    WsPropertiesExistingWsdlWizardPage.this.setPortInternal(null);
                }
                WsPropertiesExistingWsdlWizardPage.this.pingStateChanging();
            }
        });
        this.m_portField.setEnabled(false);
        this.m_portTypeField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("PortType"));
        this.m_portTypeField.setEnabled(false);
        if (this.m_webserviceEnum == WebserviceEnum.PROVIDER) {
            this.m_deriveOtherNameButton = new Button(parent, 32);
            this.m_deriveOtherNameButton.setSelection(this.isDeriveOtherNames());
            this.m_deriveOtherNameButton.setText(Texts.get("DeriveOtherNamesFormPortTypeChosen"));
            this.m_deriveOtherNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WsPropertiesExistingWsdlWizardPage.this.setDeriveOtherNames(WsPropertiesExistingWsdlWizardPage.this.m_deriveOtherNameButton.getSelection());
                    if (WsPropertiesExistingWsdlWizardPage.this.isDeriveOtherNames()) {
                        WsPropertiesExistingWsdlWizardPage.this.deriveOtherNames();
                    }
                }
            });
            this.m_alias = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Alias"));
            this.m_alias.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WsPropertiesExistingWsdlWizardPage.this.setAliasInternal(WsPropertiesExistingWsdlWizardPage.this.m_alias.getText());
                    WsPropertiesExistingWsdlWizardPage.this.pingStateChanging();
                }
            });
            this.m_urlPattern = this.getFieldToolkit().createStyledTextField(parent, Texts.get("UrlPattern"));
            this.m_urlPattern.setReadOnlyPrefix(new Path(PathNormalizer.toServletAlias(this.m_jaxWsServletAlias)).addTrailingSeparator().toString());
            this.m_urlPattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WsPropertiesExistingWsdlWizardPage.this.setUrlPatternInternal(WsPropertiesExistingWsdlWizardPage.this.m_urlPattern.getText());
                    WsPropertiesExistingWsdlWizardPage.this.pingStateChanging();
                }
            });
        }
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_serviceField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_serviceField, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_portField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_portField, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_portTypeField.setLayoutData((Object)formData);
        if (this.m_webserviceEnum == WebserviceEnum.PROVIDER) {
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_portTypeField, 5, 1024);
            formData.left = new FormAttachment(40, 5);
            formData.right = new FormAttachment(100, 0);
            this.m_deriveOtherNameButton.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_deriveOtherNameButton, 30, 1024);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.m_alias.setLayoutData((Object)formData);
            formData = new FormData();
            formData.top = new FormAttachment((Control)this.m_alias, 5, 1024);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.m_urlPattern.setLayoutData((Object)formData);
        }
    }

    protected void validatePage(final MultiStatus multiStatus) {
        if (!this.isControlCreated()) {
            return;
        }
        if (this.getWsdlDefinition() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("WsdlCouldNotBeParsed")));
            return;
        }
        if (this.getServiceProposals().length == 0) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "WSDL definition must contain one service element at least.\nPlease ensure to have specified the main WSDL file and not an imported, dependent one."));
            return;
        }
        if (this.m_alias != null) {
            if (StringUtility.isNullOrEmpty((CharSequence)this.getAlias())) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_alias.getLabelText())));
            } else if (this.m_illegalAliasNames.contains(this.getAlias())) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XWithYDoesAlreadyExist", this.m_alias.getLabelText(), this.getAlias())));
            } else {
                IStatus status = this.m_bundle.getProject().getWorkspace().validateName(this.getAlias(), 1);
                if (!status.isOK()) {
                    multiStatus.add(status);
                }
            }
        }
        if (this.m_urlPattern != null) {
            final String urlPattern = this.getUrlPattern();
            UrlPatternValidator.validate(urlPattern, this.m_jaxWsServletAlias, new IUrlPatternValidation(){

                @Override
                public void onWrongSeparators() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", "Invalid URL pattern '" + urlPattern + "'. Must start with a slash with no empty segments and no trailing slash."));
                }

                @Override
                public void onNotStartingWithServletAlias() {
                    multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XshouldStartWithY", WsPropertiesExistingWsdlWizardPage.this.m_urlPattern.getLabelText(), WsPropertiesExistingWsdlWizardPage.this.m_jaxWsServletAlias)));
                }

                @Override
                public void onIllegalCharacters() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidUrlX", urlPattern)));
                }

                @Override
                public void onEmpty() {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", WsPropertiesExistingWsdlWizardPage.this.m_urlPattern.getLabelText())));
                }
            });
            if (this.m_illegalUrlPatterns.contains(urlPattern)) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XWithYDoesAlreadyExist", this.m_urlPattern.getLabelText(), urlPattern)));
            }
        }
        if (this.getService() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_serviceField.getLabelText())));
        } else if (this.getPort() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_portField.getLabelText())));
        } else if (this.getPortType() == null) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustNotBeEmpty", this.m_portTypeField.getLabelText())));
        }
    }

    public Definition getWsdlDefinition() {
        return (Definition)this.m_propertySupport.getProperty(PROP_WSDL_DEFINITION);
    }

    public void setWsdlDefinition(Definition wsdlDefinition) {
        this.m_propertySupport.setProperty(PROP_WSDL_DEFINITION, (Object)wsdlDefinition);
        this.setStateChanging(true);
        try {
            this.setService(null);
            this.setPort(null);
            this.setPortType(null);
            SimpleProposal[] serviceProposals = this.getServiceProposals();
            SimpleProposalProvider serviceProvider = new SimpleProposalProvider(serviceProposals);
            this.m_serviceField.setContentProvider((IContentProvider)serviceProvider);
            if (serviceProposals.length > 0) {
                this.setService(serviceProposals[0].getService());
            } else {
                this.setService(null);
            }
            this.m_serviceField.setEnabled(serviceProposals.length > 0);
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setAlias(String alias) {
        try {
            this.setStateChanging(true);
            this.setAliasInternal(alias);
            if (this.isControlCreated() && this.m_alias != null) {
                this.m_alias.setText(alias);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAliasInternal(String alias) {
        this.m_propertySupport.setPropertyString(PROP_ALIAS, alias);
    }

    public String getAlias() {
        return this.m_propertySupport.getPropertyString(PROP_ALIAS);
    }

    public void setUrlPattern(String urlPattern) {
        try {
            this.setStateChanging(true);
            this.setUrlPatternInternal(urlPattern);
            if (this.isControlCreated() && this.m_urlPattern != null) {
                this.m_urlPattern.setText(urlPattern);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setUrlPatternInternal(String urlPattern) {
        this.m_propertySupport.setPropertyString(PROP_URL_PATTERN, urlPattern);
    }

    public String getUrlPattern() {
        return this.m_propertySupport.getPropertyString(PROP_URL_PATTERN);
    }

    public void setJaxWsServletAlias(String jaxWsServletAlias) {
        this.m_jaxWsServletAlias = jaxWsServletAlias;
        if (this.isControlCreated()) {
            this.m_urlPattern.setReadOnlyPrefix(new Path(PathNormalizer.toServletAlias(this.m_jaxWsServletAlias)).addTrailingSeparator().toString());
        }
    }

    public void setService(Service service) {
        try {
            this.setStateChanging(true);
            this.setServiceInternal(service);
            if (this.isControlCreated()) {
                if (service != null) {
                    this.m_serviceField.acceptProposal((Object)new P_ServiceProposal(service));
                } else {
                    this.m_serviceField.acceptProposal(null);
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setServiceInternal(Service service) {
        this.m_propertySupport.setProperty(PROP_SERVICE, (Object)service);
        SimpleProposal[] portProposals = this.getPortProposals();
        SimpleProposalProvider portProvider = new SimpleProposalProvider(portProposals);
        if (this.isControlCreated()) {
            this.m_portField.setEnabled(service != null);
            this.m_portField.setContentProvider((IContentProvider)portProvider);
        }
        if (portProposals.length > 0) {
            this.setPort(portProposals[0].getPort());
        } else {
            this.setPort(null);
        }
    }

    public Service getService() {
        return (Service)this.m_propertySupport.getProperty(PROP_SERVICE);
    }

    public void setPort(Port port) {
        try {
            this.setStateChanging(true);
            this.setPortInternal(port);
            if (this.isControlCreated()) {
                if (port != null) {
                    this.m_portField.acceptProposal((Object)new P_PortProposal(port));
                } else {
                    this.m_portField.acceptProposal(null);
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPortInternal(Port port) {
        this.m_propertySupport.setProperty(PROP_PORT, (Object)port);
        if (port != null && port.getBinding() != null && port.getBinding().getPortType() != null) {
            this.setPortType(port.getBinding().getPortType());
        } else {
            this.setPortType(null);
        }
    }

    public Port getPort() {
        return (Port)this.m_propertySupport.getProperty(PROP_PORT);
    }

    public void setPortType(PortType portType) {
        try {
            this.setStateChanging(true);
            this.setPortTypeInternal(portType);
            if (this.isControlCreated()) {
                if (portType != null) {
                    this.m_portTypeField.setText(StringUtility.nvl((Object)portType.getQName().getLocalPart(), (String)""));
                    this.m_portTypeField.setToolTipText(StringUtility.nvl((Object)portType.getQName().toString(), (String)""));
                } else {
                    this.m_portTypeField.setText("");
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPortTypeInternal(PortType portType) {
        this.m_propertySupport.setProperty(PROP_PORT_TYPE, (Object)portType);
        if (this.isControlCreated() && this.m_deriveOtherNameButton != null) {
            this.m_deriveOtherNameButton.setEnabled(portType != null);
            this.m_deriveOtherNameButton.setSelection(portType != null);
        }
        this.deriveOtherNames();
    }

    public PortType getPortType() {
        return (PortType)this.m_propertySupport.getProperty(PROP_PORT_TYPE);
    }

    public void setDeriveOtherNames(boolean deriveOtherNames) {
        try {
            this.setStateChanging(true);
            this.setDeriveOtherNamesInternal(deriveOtherNames);
            if (this.isControlCreated()) {
                this.m_deriveOtherNameButton.setSelection(deriveOtherNames);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setDeriveOtherNamesInternal(boolean deriveOtherNames) {
        this.m_propertySupport.setPropertyBool(PROP_DERIVE_OTHER_NAME, deriveOtherNames);
    }

    public boolean isDeriveOtherNames() {
        return this.m_propertySupport.getPropertyBool(PROP_DERIVE_OTHER_NAME);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    private void loadIllegalValues() {
        HashSet<String> illegalAliases = new HashSet<String>();
        HashSet<String> illegalUrlPatterns = new HashSet<String>();
        if (this.m_sunJaxWsXml != null) {
            String fqn = StringUtility.join((String)":", (Object[])new Object[]{JaxWsSdkUtility.getXmlPrefix(this.m_sunJaxWsXml.getDocumentElement()), "endpoint"});
            for (Element xmlSunJaxWs : JaxWsSdkUtility.getChildElements(this.m_sunJaxWsXml.getDocumentElement().getChildNodes(), fqn)) {
                SunJaxWsBean sunJaxWsBean = new SunJaxWsBean(xmlSunJaxWs);
                illegalAliases.add(sunJaxWsBean.getAlias());
                illegalUrlPatterns.add(sunJaxWsBean.getUrlPattern());
            }
        }
        this.m_illegalAliasNames = illegalAliases;
        this.m_illegalUrlPatterns = illegalUrlPatterns;
    }

    private void deriveOtherNames() {
        if (!this.isDeriveOtherNames()) {
            return;
        }
        String portTypeName = null;
        PortType portType = this.getPortType();
        if (portType != null && (portTypeName = portType.getQName().getLocalPart()) != null) {
            portTypeName = String.valueOf(JaxWsSdkUtility.getPlainPortTypeName(portTypeName)) + "Service";
        }
        this.setAlias(portTypeName);
        this.setUrlPattern(portTypeName);
    }

    private P_ServiceProposal[] getServiceProposals() {
        if (this.getWsdlDefinition() != null) {
            Collection services = this.getWsdlDefinition().getServices().values();
            ArrayList<P_ServiceProposal> proposals = new ArrayList<P_ServiceProposal>(services.size());
            for (Object service : services) {
                proposals.add(new P_ServiceProposal((Service)service));
            }
            return proposals.toArray(new P_ServiceProposal[proposals.size()]);
        }
        return new P_ServiceProposal[0];
    }

    private P_PortProposal[] getPortProposals() {
        if (this.getService() != null) {
            Collection ports = this.getService().getPorts().values();
            ArrayList<P_PortProposal> proposals = new ArrayList<P_PortProposal>(ports.size());
            for (Object port : ports) {
                proposals.add(new P_PortProposal((Port)port));
            }
            return proposals.toArray(new P_PortProposal[proposals.size()]);
        }
        return new P_PortProposal[0];
    }

    private final class P_PortProposal
    extends SimpleProposal {
        private static final String DATA_PORT = "dataPort";

        private P_PortProposal(Port port) {
            super(port.getName(), JaxWsSdk.getImage("port_obj.gif"));
            this.setData(DATA_PORT, port);
        }

        public String getTextSelected() {
            Port port = this.getPort();
            return "{" + port.getBinding().getPortType().getQName().getNamespaceURI() + "}" + port.getName();
        }

        public Port getPort() {
            return (Port)this.getData(DATA_PORT);
        }
    }

    private final class P_ServiceProposal
    extends SimpleProposal {
        private static final String DATA_SERVICE = "dataService";

        private P_ServiceProposal(Service service) {
            super(service.getQName().getLocalPart(), JaxWsSdk.getImage("service_obj.gif"));
            this.setData(DATA_SERVICE, service);
        }

        public String getTextSelected() {
            return this.getService().getQName().toString();
        }

        public Service getService() {
            return (Service)this.getData(DATA_SERVICE);
        }
    }
}

