/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.tooltip.JavadocTooltip;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class WsProviderImplClassWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_PACKAGE = "package";
    public static final String PROP_TYPE_NAME = "name";
    public static final String PROP_ANNOTATE_IMPL = "createScoutWsAnnotation";
    public static final String PROP_SESSION = "session";
    public static final String PROP_AUTHENTICATION_HANDLER = "authenticationHandler";
    public static final String PROP_CREDENTIAL_VALIDATION_STRATEGY = "credentialValidationStrategy";
    private BasicPropertySupport m_propertySupport;
    private IScoutBundle m_bundle;
    private StyledTextField m_packageField;
    private Button m_packageBrowseButton;
    private StyledTextField m_typeNameField;
    private Button m_annotateImplButton;
    private Text m_descriptionScoutAnnotation;
    private Text m_descriptionSessionFactory;
    private Text m_descriptionAuthenticationHandler;
    private Text m_descriptionCredentialValidationStrategy;
    private Composite m_containerAnnotation;
    private StyledTextField m_sessionFactoryField;
    private Button m_sessionFactoryBrowseButton;
    private StyledTextField m_authenticationHandlerField;
    private Button m_authenticationHandlerBrowseButton;
    private StyledTextField m_credentialValidationStrategyField;
    private Button m_credentialValidationStrategyButton;
    private JavadocTooltip m_tooltipSessionFactory;
    private JavadocTooltip m_tooltipAuthenticationHandler;
    private JavadocTooltip m_tooltipCredentialValidationStrategy;

    public WsProviderImplClassWizardPage(IScoutBundle bundle) {
        super(WsProviderImplClassWizardPage.class.getName());
        this.setTitle(Texts.get("ConfigureImplementingClass"));
        this.setDescription(Texts.get("ConfigureImplementingClass"));
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_bundle = bundle;
        this.applyDefaults();
    }

    private void applyDefaults() {
        this.setAnnotateImplClass(true);
        this.setSessionFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.DefaultServerSessionFactory").getFullyQualifiedName());
        this.setAuthenticationHandler(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.BasicAuthenticationHandler").getFullyQualifiedName());
        this.setCredentialValidationStrategy(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ConfigIniCredentialValidationStrategy").getFullyQualifiedName());
        this.setPackageName(JaxWsSdkUtility.getRecommendedProviderImplPackageName(this.m_bundle));
    }

    public void postActivate() {
        this.setSessionFactory(this.getSessionFactory());
        this.setAuthenticationHandler(this.getAuthenticationHandler());
        this.setCredentialValidationStrategy(this.getCredentialValidationStrategy());
    }

    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Name"));
        this.m_typeNameField.setReadOnlySuffix("WebService");
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsProviderImplClassWizardPage.this.setTypeNameInternal(WsProviderImplClassWizardPage.this.m_typeNameField.getText());
                WsProviderImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageField = this.getFieldToolkit().createStyledTextField(parent, Texts.get("Package"));
        this.m_packageField.setText(this.getPackageName());
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsProviderImplClassWizardPage.this.setPackageNameInternal(WsProviderImplClassWizardPage.this.m_packageField.getText());
                WsProviderImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageBrowseButton = new Button(parent, 0x800008);
        this.m_packageBrowseButton.setText(Texts.get("Browse"));
        this.m_packageBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment[] packageFragment = WsProviderImplClassWizardPage.this.openBrowsePackagesDialog();
                if (packageFragment != null && packageFragment.length > 0) {
                    WsProviderImplClassWizardPage.this.setPackageName(packageFragment[0].getElementName());
                }
            }
        });
        this.m_annotateImplButton = new Button(parent, 32);
        this.m_annotateImplButton.setText(Texts.get("AnnotateImplClass", TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getElementName()));
        this.m_annotateImplButton.setSelection(this.isAnnotateImplClass());
        this.m_annotateImplButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsProviderImplClassWizardPage.this.setAnnotateImplClass(WsProviderImplClassWizardPage.this.m_annotateImplButton.getSelection());
            }
        });
        this.m_containerAnnotation = new Composite(parent, 0);
        this.m_descriptionScoutAnnotation = new Text(this.m_containerAnnotation, 74);
        this.m_descriptionScoutAnnotation.setEnabled(false);
        this.m_descriptionScoutAnnotation.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionScoutAnnotation.setText(Texts.get("DescriptionScoutWebServiceAnnotation", TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getElementName()));
        this.m_descriptionSessionFactory = new Text(this.m_containerAnnotation, 74);
        this.m_descriptionSessionFactory.setEnabled(false);
        this.m_descriptionSessionFactory.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionSessionFactory.setText(Texts.get("DescriptionSessionFactory"));
        this.m_sessionFactoryField = this.getFieldToolkit().createStyledTextField(this.m_containerAnnotation, Texts.get("SessionFactory"));
        this.m_sessionFactoryField.setText(this.getSessionFactory());
        this.m_sessionFactoryField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsProviderImplClassWizardPage.this.setSessionFactoryInternal(WsProviderImplClassWizardPage.this.m_sessionFactoryField.getText());
                WsProviderImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_tooltipSessionFactory = new JavadocTooltip((Control)this.m_sessionFactoryField.getTextComponent());
        this.m_sessionFactoryBrowseButton = new Button(this.m_containerAnnotation, 0x800008);
        this.m_sessionFactoryBrowseButton.setText(Texts.get("Browse"));
        this.m_sessionFactoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaSearchScope searchScope = WsProviderImplClassWizardPage.this.createSubClassesSearchScope(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory"));
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"*.*");
                    dialog.setTitle(Texts.get("SessionFactory"));
                    dialog.setMessage(Texts.get("ChooseXY", Texts.get("SessionFactory")));
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0 && dialog.getResult() != null) {
                        IType type = (IType)dialog.getResult()[0];
                        WsProviderImplClassWizardPage.this.setSessionFactory(type.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException exception) {
                    JaxWsSdk.logError(exception);
                }
            }
        });
        this.m_descriptionAuthenticationHandler = new Text(this.m_containerAnnotation, 74);
        this.m_descriptionAuthenticationHandler.setEnabled(false);
        this.m_descriptionAuthenticationHandler.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionAuthenticationHandler.setText(Texts.get("DescriptionAuthenticationMechanism"));
        this.m_authenticationHandlerField = this.getFieldToolkit().createStyledTextField(this.m_containerAnnotation, Texts.get("AuthenticationMechanism"));
        this.m_authenticationHandlerField.setText(this.getAuthenticationHandler());
        this.m_authenticationHandlerField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsProviderImplClassWizardPage.this.setAuthenticationHandlerInternal(WsProviderImplClassWizardPage.this.m_authenticationHandlerField.getText());
                WsProviderImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_tooltipAuthenticationHandler = new JavadocTooltip((Control)this.m_authenticationHandlerField.getTextComponent());
        this.m_authenticationHandlerBrowseButton = new Button(this.m_containerAnnotation, 0x800008);
        this.m_authenticationHandlerBrowseButton.setText(Texts.get("Browse"));
        this.m_authenticationHandlerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaSearchScope searchScope = WsProviderImplClassWizardPage.this.createSubClassesSearchScope(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler"));
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"*.*");
                    dialog.setTitle(Texts.get("AuthenticationMechanism"));
                    dialog.setMessage(Texts.get("ChooseXY", Texts.get("AuthenticationMechanism")));
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0 && dialog.getResult() != null) {
                        IType type = (IType)dialog.getResult()[0];
                        WsProviderImplClassWizardPage.this.setAuthenticationHandler(type.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException exception) {
                    JaxWsSdk.logError(exception);
                }
            }
        });
        this.m_descriptionCredentialValidationStrategy = new Text(this.m_containerAnnotation, 74);
        this.m_descriptionCredentialValidationStrategy.setEnabled(false);
        this.m_descriptionCredentialValidationStrategy.setForeground(ScoutSdkUi.getDisplay().getSystemColor(16));
        this.m_descriptionCredentialValidationStrategy.setText(Texts.get("DescriptionCredentialValidationValidation"));
        this.m_credentialValidationStrategyField = this.getFieldToolkit().createStyledTextField(this.m_containerAnnotation, Texts.get("CredentialValidationStrategy"));
        this.m_credentialValidationStrategyField.setText(this.getCredentialValidationStrategy());
        this.m_credentialValidationStrategyField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsProviderImplClassWizardPage.this.setCredentialValidationStrategyInternal(WsProviderImplClassWizardPage.this.m_credentialValidationStrategyField.getText());
                WsProviderImplClassWizardPage.this.pingStateChanging();
            }
        });
        this.m_tooltipCredentialValidationStrategy = new JavadocTooltip((Control)this.m_credentialValidationStrategyField.getTextComponent());
        this.m_credentialValidationStrategyButton = new Button(this.m_containerAnnotation, 0x800008);
        this.m_credentialValidationStrategyButton.setText(Texts.get("Browse"));
        this.m_credentialValidationStrategyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IJavaSearchScope searchScope = WsProviderImplClassWizardPage.this.createSubClassesSearchScope(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy"));
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)ScoutSdkUi.getShell(), null, (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"*.*");
                    dialog.setTitle(Texts.get("CredentialValidationStrategy"));
                    dialog.setMessage(Texts.get("ChooseXY", Texts.get("CredentialValidationStrategy")));
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0 && dialog.getResult() != null) {
                        IType type = (IType)dialog.getResult()[0];
                        WsProviderImplClassWizardPage.this.setCredentialValidationStrategy(type.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException exception) {
                    JaxWsSdk.logError(exception);
                }
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_typeNameField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_typeNameField, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_packageField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_packageBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_packageField, 20, 1024);
        formData.left = new FormAttachment(40, 5);
        formData.right = new FormAttachment(100, 0);
        this.m_annotateImplButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_annotateImplButton, 5, 1024);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_containerAnnotation.setLayoutData((Object)formData);
        this.m_containerAnnotation.setLayout((Layout)new FormLayout());
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionScoutAnnotation.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionScoutAnnotation, 10, 1024);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionSessionFactory.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionSessionFactory, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_sessionFactoryField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_sessionFactoryField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_sessionFactoryBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_sessionFactoryBrowseButton, 10, 1024);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionAuthenticationHandler.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionAuthenticationHandler, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_authenticationHandlerField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_authenticationHandlerField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_authenticationHandlerBrowseButton.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_authenticationHandlerBrowseButton, 10, 1024);
        formData.left = new FormAttachment(40, 2);
        formData.right = new FormAttachment(100, 0);
        this.m_descriptionCredentialValidationStrategy.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_descriptionCredentialValidationStrategy, 5, 1024);
        formData.left = new FormAttachment(0, 50);
        formData.right = new FormAttachment(100, -75);
        this.m_credentialValidationStrategyField.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.m_credentialValidationStrategyField, 0, 128);
        formData.left = new FormAttachment(100, -70);
        formData.right = new FormAttachment(100, 0);
        this.m_credentialValidationStrategyButton.setLayoutData((Object)formData);
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (this.m_bundle == null) {
            return;
        }
        this.validateType(multiStatus);
        if (this.isAnnotateImplClass()) {
            this.validateFactoryType(multiStatus, Texts.get("SessionFactory"), this.getSessionFactory(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory"), JaxWsSdkUtility.getRecommendedSessionPackageName(this.m_bundle));
            this.validateFactoryType(multiStatus, Texts.get("AuthenticationFactory"), this.getAuthenticationHandler(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler"), JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
            this.validateFactoryType(multiStatus, Texts.get("CredentialValidationFactory"), this.getCredentialValidationStrategy(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy"), JaxWsSdkUtility.getRecommendedProviderSecurityPackageName(this.m_bundle));
        }
    }

    protected void validateType(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getPackageName())) {
            multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UsageOfDefaultPackageDiscouraged")));
        } else {
            multiStatus.add(JavaConventionsUtil.validatePackageName((String)this.getPackageName(), (IJavaElement)this.m_bundle.getJavaProject()));
            String recommendedPackageName = JaxWsSdkUtility.getRecommendedProviderImplPackageName(this.m_bundle);
            if (!this.getPackageName().equals(recommendedPackageName)) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("ByConventionXShouldByY", Texts.get("Package"), recommendedPackageName)));
            }
        }
        if (StringUtility.isNullOrEmpty((CharSequence)this.getTypeName()) || this.getTypeName().equals("WebService")) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("MissingNameForImplementingClass")));
        } else {
            multiStatus.add(JavaConventionsUtil.validateJavaTypeName((String)this.getTypeName(), (IJavaElement)this.m_bundle.getJavaProject()));
            if (Character.isLowerCase(this.getTypeName().charAt(0))) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("LowerCaseTypeName")));
            }
        }
        if (multiStatus.getSeverity() < 4) {
            String fullyQualifiedName = StringUtility.join((String)".", (Object[])new Object[]{this.getPackageName(), this.getTypeName()});
            try {
                if (TypeUtility.existsType((String)fullyQualifiedName)) {
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("TypeAlreadyExsits", fullyQualifiedName)));
                }
            }
            catch (Exception e) {
                multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidJavaType", fullyQualifiedName)));
            }
        }
    }

    protected void validateFactoryType(MultiStatus multiStatus, String label, String qualifiedName, IType interfaceType, String recommendedPackage) {
        if (StringUtility.isNullOrEmpty((CharSequence)qualifiedName)) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("NoClassSpecified", label)));
            return;
        }
        String packageName = Signature.getQualifier((String)qualifiedName);
        String className = StringUtility.isNullOrEmpty((CharSequence)packageName) ? qualifiedName : Signature.getSimpleName((String)qualifiedName);
        if (StringUtility.isNullOrEmpty((CharSequence)packageName)) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("UsageOfDefaultPackageNotAllowed")));
            return;
        }
        multiStatus.add(JavaConventionsUtil.validatePackageName((String)packageName, (IJavaElement)this.m_bundle.getJavaProject()));
        try {
            String fqn = StringUtility.join((String)".", (Object[])new Object[]{packageName, className});
            if (TypeUtility.existsType((String)fqn)) {
                IType type = TypeUtility.getType((String)fqn);
                if (!TypeUtility.getSupertypeHierarchy((IType)type).contains(interfaceType)) {
                    type.getJavadocRange().getOffset();
                    type.getJavadocRange().getLength();
                    multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("XMustBeOfTheTypeY", label, interfaceType.getFullyQualifiedName())));
                }
            } else if (!packageName.equals(recommendedPackage)) {
                multiStatus.add((IStatus)new Status(2, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("ByConventionXShouldByY", Texts.get(PROP_PACKAGE), recommendedPackage)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTypeName(String typeName) {
        try {
            typeName = NamingUtility.ensureStartWithUpperCase((String)typeName);
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.m_propertySupport.setProperty(PROP_TYPE_NAME, (Object)typeName);
    }

    public String getTypeName() {
        return this.m_propertySupport.getPropertyString(PROP_TYPE_NAME);
    }

    public void setPackageName(String packageName) {
        try {
            this.setStateChanging(true);
            this.setPackageNameInternal(packageName);
            if (this.isControlCreated()) {
                this.m_packageField.setText(packageName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setPackageNameInternal(String packageName) {
        this.m_propertySupport.setPropertyString(PROP_PACKAGE, packageName);
    }

    public String getPackageName() {
        return this.m_propertySupport.getPropertyString(PROP_PACKAGE);
    }

    public void setAnnotateImplClass(boolean annotateImplClass) {
        try {
            this.setStateChanging(true);
            this.setAnnotateImplClassInternal(annotateImplClass);
            if (this.isControlCreated()) {
                this.m_annotateImplButton.setSelection(annotateImplClass);
                JaxWsSdkUtility.setView(this.m_containerAnnotation, annotateImplClass);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAnnotateImplClassInternal(boolean annotateImplClass) {
        this.m_propertySupport.setProperty(PROP_ANNOTATE_IMPL, (Object)annotateImplClass);
    }

    public boolean isAnnotateImplClass() {
        return this.m_propertySupport.getPropertyBool(PROP_ANNOTATE_IMPL);
    }

    public void setSessionFactory(String sessionFactory) {
        try {
            this.setStateChanging(true);
            this.setSessionFactoryInternal(sessionFactory);
            if (this.isControlCreated()) {
                this.m_sessionFactoryField.setText(sessionFactory);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSessionFactoryInternal(String sessionFactory) {
        this.m_propertySupport.setPropertyString(PROP_SESSION, sessionFactory);
        if (this.isControlCreated()) {
            try {
                IType type;
                this.m_tooltipSessionFactory.setMember(null);
                if (TypeUtility.existsType((String)sessionFactory) && TypeUtility.getSupertypeHierarchy((IType)(type = TypeUtility.getType((String)sessionFactory))).contains(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory"))) {
                    this.m_tooltipSessionFactory.setMember((IMember)type);
                }
            }
            catch (Exception e) {
                JaxWsSdk.logWarning("Could not render tooltip", e);
            }
        }
    }

    public String getSessionFactory() {
        return this.m_propertySupport.getPropertyString(PROP_SESSION);
    }

    public void setAuthenticationHandler(String authenticationHandler) {
        try {
            this.setStateChanging(true);
            this.setAuthenticationHandlerInternal(authenticationHandler);
            if (this.isControlCreated()) {
                this.m_authenticationHandlerField.setText(authenticationHandler);
                if (this.isAnnotateImplClass()) {
                    boolean authenticationSet = JaxWsSdkUtility.isProviderAuthenticationSet(authenticationHandler);
                    this.m_credentialValidationStrategyField.setEnabled(authenticationSet);
                    this.m_credentialValidationStrategyButton.setEnabled(authenticationSet);
                }
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setAuthenticationHandlerInternal(String authenticationHandler) {
        this.m_propertySupport.setPropertyString(PROP_AUTHENTICATION_HANDLER, authenticationHandler);
        if (this.isControlCreated()) {
            this.m_tooltipAuthenticationHandler.setMember(null);
            if (TypeUtility.existsType((String)authenticationHandler)) {
                IType type = TypeUtility.getType((String)authenticationHandler);
                try {
                    if (TypeUtility.getSupertypeHierarchy((IType)type).contains(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler"))) {
                        this.m_tooltipAuthenticationHandler.setMember((IMember)type);
                    }
                }
                catch (Exception e) {
                    JaxWsSdk.logWarning("Could not render tooltip", e);
                }
            }
        }
    }

    public String getAuthenticationHandler() {
        return this.m_propertySupport.getPropertyString(PROP_AUTHENTICATION_HANDLER);
    }

    public void setCredentialValidationStrategy(String credentialValidationStrategy) {
        try {
            this.setStateChanging(true);
            this.setCredentialValidationStrategyInternal(credentialValidationStrategy);
            if (this.isControlCreated()) {
                this.m_credentialValidationStrategyField.setText(credentialValidationStrategy);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setCredentialValidationStrategyInternal(String credentialValidationStrategy) {
        this.m_propertySupport.setPropertyString(PROP_CREDENTIAL_VALIDATION_STRATEGY, credentialValidationStrategy);
        if (this.isControlCreated()) {
            this.m_tooltipCredentialValidationStrategy.setMember(null);
            if (TypeUtility.existsType((String)credentialValidationStrategy)) {
                IType type = TypeUtility.getType((String)credentialValidationStrategy);
                try {
                    if (TypeUtility.getSupertypeHierarchy((IType)type).contains(TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy"))) {
                        this.m_tooltipCredentialValidationStrategy.setMember((IMember)type);
                    }
                }
                catch (Exception e) {
                    JaxWsSdk.logWarning("Could not render tooltip", e);
                }
            }
        }
    }

    public String getCredentialValidationStrategy() {
        return this.m_propertySupport.getPropertyString(PROP_CREDENTIAL_VALIDATION_STRATEGY);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    private IPackageFragment[] openBrowsePackagesDialog() {
        IPackageFragment[] packageFragments = null;
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.m_bundle.getJavaProject()});
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)ScoutSdkUi.getShell(), (IRunnableContext)context, (IJavaSearchScope)searchScope, (boolean)false, (boolean)true, null);
        dialog.setTitle(Texts.get("Package"));
        dialog.setMessage(Texts.get("ChoosePackageForImplementingClass"));
        if (dialog.open() == 0 && dialog.getResult() != null) {
            Object[] result = dialog.getResult();
            packageFragments = Arrays.asList(result).toArray(new IPackageFragment[result.length]);
        }
        return packageFragments;
    }

    private IJavaSearchScope createSubClassesSearchScope(IType superType) {
        IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
        return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
    }
}

