/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;

public class EclipseFileHandle
implements IFileHandle<IFile> {
    private final IResource m_resource;

    public EclipseFileHandle(IResource resource) {
        this.m_resource = resource;
    }

    @Override
    public IFileHandle<IFile> getParent() {
        return new EclipseFileHandle((IResource)this.m_resource.getParent());
    }

    @Override
    public InputStream getInputStream() {
        if (this.m_resource instanceof IFile) {
            try {
                return ((IFile)this.m_resource).getContents();
            }
            catch (CoreException e) {
                JaxWsSdk.logError(String.format("Failed to get InputStream of file '%s'", this.m_resource.getName()), e);
            }
        }
        return null;
    }

    @Override
    public boolean exists() {
        return this.m_resource.exists();
    }

    @Override
    public String getName() {
        return this.m_resource.getName();
    }

    @Override
    public IPath getFullPath() {
        return this.m_resource.getLocation();
    }

    @Override
    public IFileHandle<IFile> getChild(IPath path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile child = root.getFile(this.m_resource.getFullPath().append(path));
        if (child.exists()) {
            return new EclipseFileHandle((IResource)child);
        }
        return null;
    }

    @Override
    public IFile getFile() {
        if (this.m_resource instanceof IFile) {
            return (IFile)this.m_resource;
        }
        return null;
    }

    public int hashCode() {
        return this.m_resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.m_resource.equals((Object)((EclipseFileHandle)obj).m_resource);
    }
}

