/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.util;

import java.util.ArrayList;
import java.util.Arrays;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.SelectionDialog;
import org.eclipse.scout.sdk.ws.jaxws.util.IFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.ISchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaArtifactVisitor;
import org.eclipse.scout.sdk.ws.jaxws.util.SchemaUtility;
import org.eclipse.swt.widgets.Shell;

public final class GlobalBindingRegistrationHelper {
    private GlobalBindingRegistrationHelper() {
    }

    public static SchemaCandidate popupForSchema(IFile wsdlFile) throws CoreException {
        SchemaCandidate[] schemaCandidates = GlobalBindingRegistrationHelper.getSchemaCandidates(wsdlFile);
        if (schemaCandidates.length == 0) {
            JaxWsSdk.logWarning("No XML schema found to apply customized binding");
            return null;
        }
        if (schemaCandidates.length == 1) {
            return schemaCandidates[0];
        }
        P_SelectionDialog dialog = new P_SelectionDialog(ScoutSdkUi.getShell());
        dialog.setElements(Arrays.asList(schemaCandidates));
        if (dialog.open() == 0) {
            return (SchemaCandidate)dialog.getElement();
        }
        throw new CoreException(Status.CANCEL_STATUS);
    }

    public static SchemaCandidate[] getSchemaCandidates(IFile wsdlFile) {
        final ArrayList schemaCandidates = new ArrayList();
        SchemaUtility.visitArtifacts(wsdlFile, (ISchemaArtifactVisitor<IFile>)new SchemaArtifactVisitor<IFile>(){

            @Override
            protected void onWsdlArtifact(SchemaUtility.WsdlArtifact<IFile> wsdlArtifact) {
                Schema[] schemaArray = wsdlArtifact.getInlineSchemas();
                int n = schemaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Schema inlineSchema = schemaArray[n2];
                    schemaCandidates.add(new SchemaCandidate(inlineSchema, wsdlArtifact));
                    ++n2;
                }
            }
        });
        return schemaCandidates.toArray(new SchemaCandidate[schemaCandidates.size()]);
    }

    private static class P_SelectionDialog
    extends SelectionDialog<SchemaCandidate> {
        public P_SelectionDialog(Shell shell) {
            super(shell, "XML schema selection", "Which XML schema should be customized?");
        }

        @Override
        protected String getConfiguredNameColumnText() {
            return "TargetNamespace";
        }

        @Override
        protected String getConfiguredDescriptionColumnText() {
            return "Schema defining WSDL file";
        }

        @Override
        protected boolean getConfiguredIsDescriptionColumnVisible() {
            return true;
        }

        @Override
        protected void execDecorateElement(SchemaCandidate candidate, ViewerCell cell) {
            if (cell.getColumnIndex() == 0) {
                cell.setText(StringUtility.nvl((Object)SchemaUtility.getSchemaTargetNamespace(candidate.getSchema()), (String)"?"));
                cell.setImage(JaxWsSdk.getImage("wsdl_file_obj.gif"));
            } else {
                IFileHandle fileHandle = candidate.getWsdlArtifact().getFileHandle();
                String text = fileHandle != null ? fileHandle.getName() : "?";
                if (candidate.getWsdlArtifact().getTypeEnum() == SchemaUtility.WsdlArtifact.TypeEnum.ROOT_WSDL) {
                    text = String.valueOf(text) + " (Root WSDL file)";
                }
                cell.setText(text);
            }
        }
    }

    public static class SchemaCandidate {
        private Schema m_schema;
        private SchemaUtility.WsdlArtifact<IFile> m_wsdlArtifact;

        public SchemaCandidate(Schema schema, SchemaUtility.WsdlArtifact<IFile> wsdlArtifact) {
            this.m_schema = schema;
            this.m_wsdlArtifact = wsdlArtifact;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public void setSchema(Schema schema) {
            this.m_schema = schema;
        }

        public SchemaUtility.WsdlArtifact<IFile> getWsdlArtifact() {
            return this.m_wsdlArtifact;
        }

        public void setWsdlArtifact(SchemaUtility.WsdlArtifact<IFile> wsdlArtifact) {
            this.m_wsdlArtifact = wsdlArtifact;
        }
    }
}

