/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy;
import org.eclipse.scout.service.ServiceUtility;

public class ConfigIniCredentialValidationStrategy
implements ICredentialValidationStrategy {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ConfigIniCredentialValidationStrategy.class);
    private String m_credentials;
    private Map<String, String> m_credentialsMap = new HashMap<String, String>();

    public ConfigIniCredentialValidationStrategy() {
        ServiceUtility.injectConfigProperties((Object)this);
        this.init();
    }

    @Override
    public boolean isValidUser(String username, String passwordPlainText) throws Exception {
        if (!StringUtility.hasText((CharSequence)username) || !StringUtility.hasText((CharSequence)passwordPlainText)) {
            return false;
        }
        if (this.m_credentialsMap.containsKey(username.toLowerCase())) {
            return CompareUtility.equals((Object)this.m_credentialsMap.get(username.toLowerCase()), (Object)passwordPlainText);
        }
        return false;
    }

    protected void init() {
        String[] credentialList;
        if (!StringUtility.hasText((CharSequence)this.m_credentials) || this.m_credentials.split(";").length == 0) {
            LOG.info("No user's credentials configured. " + this.getExampleConfig());
            return;
        }
        String[] stringArray = credentialList = this.m_credentials.split(";");
        int n = credentialList.length;
        int n2 = 0;
        while (n2 < n) {
            String credentials = stringArray[n2];
            String[] userpass = credentials.split("=", 2);
            if (userpass.length == 2) {
                String username = userpass[0];
                if (!StringUtility.hasText((CharSequence)username)) {
                    LOG.warn("Configured username must not be empty. " + this.getExampleConfig());
                } else {
                    String password = userpass[1];
                    if (!StringUtility.hasText((CharSequence)password)) {
                        LOG.warn("Configured password must not be empty. " + this.getExampleConfig());
                    } else {
                        this.m_credentialsMap.put(username.toLowerCase(), password);
                    }
                }
            } else {
                LOG.warn("username and password must be separated by the equals sign. " + this.getExampleConfig());
            }
            ++n2;
        }
    }

    public void setCredentials(String credentials) {
        this.m_credentials = credentials;
    }

    private String getExampleConfig() {
        return "Please see the exmaple config: " + ConfigIniCredentialValidationStrategy.class.getName() + "#credentials=sean\\=XXXX;jack\\=XXXX;kimberley\\=XXXX";
    }
}

