/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.TreeChains;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.TreeContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.DefaultTreeEventHistory;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeUIFacade;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.IVirtualTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTree
extends AbstractPropertyObserver
implements ITree,
IContributionOwner,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTree.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private ITreeUIFacade m_uiFacade;
    private List<IMenu> m_menus;
    private boolean m_initialized;
    private boolean m_enabledGranted;
    private boolean m_enabledProperty;
    private ITreeNode m_rootNode;
    private int m_treeChanging;
    private boolean m_autoDiscardOnDelete;
    private boolean m_autoTitle;
    private final HashMap<Object, ITreeNode> m_deletedNodes;
    private List<TreeEvent> m_treeEventBuffer = new ArrayList<TreeEvent>();
    private Set<ITreeNode> m_nodeDecorationBuffer = new HashSet<ITreeNode>();
    private Set<ITreeNode> m_selectedNodes = new HashSet<ITreeNode>();
    private final List<ITreeNodeFilter> m_nodeFilters;
    private final int m_uiProcessorCount = 0;
    private List<IKeyStroke> m_baseKeyStrokes;
    private IEventHistory<TreeEvent> m_eventHistory;
    private boolean m_actionRunning;
    private boolean m_saveAndRestoreScrollbars;
    private ITreeNode m_lastSeenDropNode;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractTree, ITreeExtension<? extends AbstractTree>> m_objectExtensions;
    private List<IMenu> m_currentNodeMenus;
    private int m_processTreeBufferLoopDetection;

    public AbstractTree() {
        this(true);
    }

    public AbstractTree(boolean callInitialzier) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTree(this);
        }
        this.m_deletedNodes = new HashMap();
        this.m_nodeFilters = new ArrayList<ITreeNodeFilter>(1);
        this.m_actionRunning = false;
        this.m_objectExtensions = new ObjectExtensions((Object)this);
        if (callInitialzier) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.interceptInitConfig();
            this.m_initialized = true;
        }
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredAutoTitle() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=40.0)
    protected boolean getConfiguredMultiSelect() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=42.0)
    protected boolean getConfiguredMultiCheck() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=45.0)
    protected boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=46.0)
    protected int getConfiguredNodeHeightHint() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredDragEnabled() {
        return false;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=51.0)
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=52.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredAutoDiscardOnDelete() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredRootNodeVisible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=71.0)
    protected boolean getConfiguredRootHandlesVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredScrollToSelection() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredSaveAndRestoreScrollbars() {
        return false;
    }

    private List<Class<? extends IKeyStroke>> getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitTree() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeTree() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=18.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected TransferObject execDrag(ITreeNode node) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=30.0)
    protected TransferObject execDrag(Collection<ITreeNode> nodes) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execDrop(ITreeNode node, TransferObject t) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=45.0)
    protected void execDropTargetChanged(ITreeNode node) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateCell(ITreeNode node, Cell cell) throws ProcessingException {
        if (cell.getIconId() == null && this.getIconId() != null) {
            cell.setIconId(this.getIconId());
        }
        node.decorateCell();
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execNodesSelected(TreeEvent e) throws ProcessingException {
    }

    @Deprecated
    protected void execNodeClick(ITreeNode node) throws ProcessingException {
        TreeEvent e = new TreeEvent((ITree)this, 820, node);
        this.fireTreeEventInternal(e);
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execNodeClick(ITreeNode node, MouseButton mouseButton) throws ProcessingException {
        TreeEvent e = new TreeEvent((ITree)this, 820, node);
        this.fireTreeEventInternal(e);
        this.execNodeClick(node);
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execNodeAction(ITreeNode node) throws ProcessingException {
        TreeEvent e = new TreeEvent((ITree)this, 705, node);
        this.fireTreeEventInternal(e);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractTree.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.m_enabledGranted = true;
        this.m_eventHistory = this.createEventHistory();
        this.m_uiFacade = new P_UIFacade();
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setTitle(this.getConfiguredTitle());
        this.setIconId(this.getConfiguredIconId());
        this.setAutoTitle(this.getConfiguredAutoTitle());
        this.setCheckable(this.getConfiguredCheckable());
        this.setNodeHeightHint(this.getConfiguredNodeHeightHint());
        this.setMultiCheck(this.getConfiguredMultiCheck());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setAutoDiscardOnDelete(this.getConfiguredAutoDiscardOnDelete());
        this.setDragEnabled(this.getConfiguredDragEnabled());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setRootNodeVisible(this.getConfiguredRootNodeVisible());
        this.setRootHandlesVisible(this.getConfiguredRootHandlesVisible());
        this.setScrollToSelection(this.getConfiguredScrollToSelection());
        this.setSaveAndRestoreScrollbars(this.getConfiguredSaveAndRestoreScrollbars());
        this.setRootNode(new AbstractTreeNode(){});
        this.addTreeListener(new TreeAdapter(){

            @Override
            public void treeChanged(TreeEvent e) {
                IEventHistory<TreeEvent> h = AbstractTree.this.getEventHistory();
                if (h != null) {
                    h.notifyEvent(e);
                }
                switch (e.getType()) {
                    case 730: {
                        AbstractTree.this.m_lastSeenDropNode = null;
                        if (e.getDragObject() != null) break;
                        try {
                            TransferObject transferObject = AbstractTree.this.interceptDrag(e.getNode());
                            if (transferObject == null) {
                                transferObject = AbstractTree.this.interceptDrag(e.getNodes());
                            }
                            e.setDragObject(transferObject);
                        }
                        catch (Throwable t) {
                            LOG.error("Drag", t);
                        }
                        break;
                    }
                    case 740: {
                        AbstractTree.this.m_lastSeenDropNode = null;
                        if (e.getDropObject() == null) break;
                        try {
                            AbstractTree.this.interceptDrop(e.getNode(), e.getDropObject());
                        }
                        catch (Throwable t) {
                            LOG.error("Drop", t);
                        }
                        break;
                    }
                    case 40: {
                        AbstractTree.this.rebuildKeyStrokesInternal();
                        break;
                    }
                    case 860: {
                        try {
                            if (AbstractTree.this.m_lastSeenDropNode != null && AbstractTree.this.m_lastSeenDropNode == e.getNode()) break;
                            AbstractTree.this.m_lastSeenDropNode = e.getNode();
                            AbstractTree.this.interceptDropTargetChanged(e.getNode());
                        }
                        catch (Throwable t) {
                            LOG.error("DropTargetChanged", t);
                        }
                        break;
                    }
                    case 735: {
                        AbstractTree.this.m_lastSeenDropNode = null;
                    }
                }
            }
        });
        List<Class<? extends IKeyStroke>> configuredKeyStrokes = this.getConfiguredKeyStrokes();
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>(configuredKeyStrokes.size());
        for (Class<? extends IKeyStroke> keystrokeClazz : configuredKeyStrokes) {
            try {
                ksList.add((IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, keystrokeClazz));
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + keystrokeClazz.getName() + "'.", t));
            }
        }
        if (ConfigurationUtility.isMethodOverwrite(AbstractTree.class, (String)"execNodeAction", (Class[])new Class[]{ITreeNode.class}, this.getClass())) {
            ksList.add(new KeyStroke("ENTER"){

                @Override
                protected void execAction() throws ProcessingException {
                    AbstractTree.this.fireNodeAction(AbstractTree.this.getSelectedNode());
                }
            });
        }
        List contributedKeyStrokes = this.m_contributionHolder.getContributionsByClass(IKeyStroke.class);
        contributedKeyStrokes.addAll(contributedKeyStrokes);
        this.m_baseKeyStrokes = ksList;
        this.setKeyStrokesInternal(this.m_baseKeyStrokes);
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
                menus.addOrdered((IOrdered)menu);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + menuClazz.getName() + "'.", (Throwable)e));
            }
        }
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("Error occured while dynamically contributing menus.", (Throwable)e);
        }
        menus.addAllOrdered((Collection)contributedMenus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        TreeContextMenu contextMenu = new TreeContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
        this.setContextMenuInternal(contextMenu);
    }

    @Override
    public final void initTree() throws ProcessingException {
        this.initTreeInternal();
        ActionUtility.initActions(this.getMenus());
        this.interceptInitTree();
    }

    protected void initTreeInternal() throws ProcessingException {
    }

    @Override
    public final void disposeTree() {
        this.disposeTreeInternal();
        try {
            this.interceptDisposeTree();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    protected void disposeTreeInternal() {
    }

    public final List<? extends ITreeExtension<? extends AbstractTree>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ITreeExtension<? extends AbstractTree> createLocalExtension() {
        return new LocalTreeExtension<AbstractTree>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public ITreeContextMenu getContextMenu() {
        return (ITreeContextMenu)this.propertySupport.getProperty("contextMenu");
    }

    protected void setContextMenuInternal(ITreeContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenu", (Object)contextMenu);
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenu(Class<T> menuType) throws ProcessingException {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), menuType));
    }

    @Override
    public boolean hasNodeFilters() {
        return this.m_nodeFilters.size() > 0;
    }

    @Override
    public List<ITreeNodeFilter> getNodeFilters() {
        return CollectionUtility.arrayList(this.m_nodeFilters);
    }

    @Override
    public void addNodeFilter(ITreeNodeFilter filter) {
        if (filter != null) {
            boolean exists = false;
            for (ITreeNodeFilter existingFilter : this.m_nodeFilters) {
                if (existingFilter != filter) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.m_nodeFilters.add(filter);
            }
            this.applyNodeFilters();
        }
    }

    @Override
    public void removeNodeFilter(ITreeNodeFilter filter) {
        if (filter != null) {
            this.m_nodeFilters.remove(filter);
            this.applyNodeFilters();
        }
    }

    @Override
    public void applyNodeFilters() {
        this.applyNodeFiltersRecInternal(this.getRootNode(), true, 0);
        this.fireNodeFilterChanged();
    }

    private void applyNodeFiltersRecInternal(ITreeNode inode, boolean parentAccepted, int level) {
        if (inode == null) {
            return;
        }
        inode.setFilterAccepted(true);
        if (this.m_nodeFilters.size() > 0) {
            for (ITreeNodeFilter filter : this.m_nodeFilters) {
                if (filter.accept(inode, level)) continue;
                inode.setFilterAccepted(false);
                break;
            }
        }
        if (!inode.isFilterAccepted() && this.isSelectedNode(inode)) {
            this.deselectNode(inode);
        }
        if (!parentAccepted && inode.isFilterAccepted()) {
            ITreeNode tmp = inode.getParentNode();
            while (tmp != null) {
                if (tmp instanceof AbstractTreeNode) {
                    ((AbstractTreeNode)tmp).setFilterAccepted(true);
                }
                tmp = tmp.getParentNode();
            }
        }
        for (ITreeNode child : inode.getChildNodes()) {
            this.applyNodeFiltersRecInternal(child, inode.isFilterAccepted(), level + 1);
        }
    }

    @Override
    public void requestFocus() {
        this.fireRequestFocus();
    }

    @Override
    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isAutoTitle() {
        return this.m_autoTitle;
    }

    @Override
    public void setAutoTitle(boolean b) {
        this.m_autoTitle = b;
    }

    @Override
    public String getIconId() {
        String iconId = this.propertySupport.getPropertyString("iconId");
        if (iconId != null && iconId.length() == 0) {
            iconId = null;
        }
        return iconId;
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public boolean isCheckable() {
        return this.propertySupport.getPropertyBool("checkable");
    }

    @Override
    public void setCheckable(boolean b) {
        this.propertySupport.setPropertyBool("checkable", b);
    }

    @Override
    public int getNodeHeightHint() {
        return this.propertySupport.getPropertyInt("propNodeHeightHint");
    }

    @Override
    public void setNodeHeightHint(int h) {
        this.propertySupport.setPropertyInt("propNodeHeightHint", h);
    }

    @Override
    public boolean isDragEnabled() {
        return this.propertySupport.getPropertyBool("dragEnabled");
    }

    @Override
    public void setDragEnabled(boolean b) {
        this.propertySupport.setPropertyBool("dragEnabled", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setEnabledPermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGranted(b);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledGranted(boolean b) {
        this.m_enabledGranted = b;
        this.calculateEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabledProperty = b;
        this.calculateEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    private void calculateEnabled() {
        this.propertySupport.setPropertyBool("enabled", this.m_enabledGranted && this.m_enabledProperty);
    }

    @Override
    public String getPathText(ITreeNode selectedNode) {
        return this.getPathText(selectedNode, " - ");
    }

    @Override
    public String getPathText(ITreeNode selectedNode, String delimiter) {
        ITreeNode root = this.getRootNode();
        StringBuffer pathStr = new StringBuffer("");
        ITreeNode node = selectedNode;
        while (node != null) {
            if (node != root || this.isRootNodeVisible()) {
                if (pathStr.length() != 0) {
                    pathStr.insert(0, delimiter);
                }
                pathStr.insert(0, node.getCell().getText());
            }
            node = node.getParentNode();
        }
        return pathStr.toString();
    }

    private void rebuildTitleInternal() {
        this.setTitle(this.getPathText(this.getSelectedNode()));
    }

    private void rebuildKeyStrokesInternal() {
        final ArrayList menus = new ArrayList();
        final IActionFilter activeFilter = ActionUtility.createMenuFilterMenuTypes(this.getContextMenu().getCurrentMenuTypes(), true);
        this.getContextMenu().acceptVisitor(new IActionVisitor(){

            @Override
            public int visit(IAction action) {
                IMenu menu;
                if (action instanceof IMenu && (menu = (IMenu)action).isEnabled() && !menu.isSeparator() && !menu.hasChildActions() && activeFilter.accept(menu)) {
                    menus.add(menu);
                }
                return 1;
            }
        });
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>(this.m_baseKeyStrokes);
        for (IMenu menu : menus) {
            if (menu.getKeyStroke() == null) continue;
            try {
                KeyStroke ks = new KeyStroke(menu.getKeyStroke(), menu);
                ks.initAction();
                ksList.add(ks);
            }
            catch (ProcessingException e) {
                LOG.error("could not initialize key stroke '" + menu.getKeyStroke() + "'", (Throwable)e);
            }
        }
        this.setKeyStrokesInternal(ksList);
    }

    @Override
    public ITreeNode findNode(Object primaryKey) {
        List<ITreeNode> a = this.findNodes(CollectionUtility.hashSet((Object)primaryKey));
        if (a != null && a.size() > 0) {
            return (ITreeNode)CollectionUtility.firstElement(a);
        }
        return null;
    }

    @Override
    public List<ITreeNode> findNodes(Collection<?> primaryKeys) {
        if (primaryKeys == null || primaryKeys.size() <= 0) {
            return CollectionUtility.emptyArrayList();
        }
        final HashSet keySet = new HashSet(primaryKeys);
        P_AbstractCollectingTreeVisitor v = new P_AbstractCollectingTreeVisitor(this){

            @Override
            public boolean visit(ITreeNode node) {
                if (keySet.remove(node.getPrimaryKey())) {
                    this.addNodeToList(node);
                }
                return !keySet.isEmpty();
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getNodes();
    }

    @Override
    public void setRootNode(ITreeNode root) {
        if (this.m_rootNode != null) {
            this.m_rootNode.setTreeInternal(null, true);
            root.nodeRemovedNotify();
        }
        this.m_rootNode = root;
        if (this.m_rootNode != null) {
            this.m_rootNode.setTreeInternal(this, true);
            this.m_rootNode.nodeAddedNotify();
            if (!this.isRootNodeVisible()) {
                try {
                    this.m_rootNode.ensureChildrenLoaded();
                }
                catch (ProcessingException e) {
                    LOG.error("expanding root node of " + this.getTitle(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isRootNodeVisible() {
        return this.propertySupport.getPropertyBool("rootNodeVisible");
    }

    @Override
    public void setRootNodeVisible(boolean b) {
        this.propertySupport.setPropertyBool("rootNodeVisible", b);
    }

    @Override
    public boolean isRootHandlesVisible() {
        return this.propertySupport.getPropertyBool("rootHandlesVisible");
    }

    @Override
    public void setRootHandlesVisible(boolean b) {
        this.propertySupport.setPropertyBool("rootHandlesVisible", b);
    }

    @Override
    public boolean isTreeChanging() {
        return this.m_treeChanging > 0;
    }

    @Override
    public void setTreeChanging(boolean b) {
        if (b) {
            ++this.m_treeChanging;
            if (this.m_treeChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_treeChanging > 0) {
            --this.m_treeChanging;
            if (this.m_treeChanging == 0) {
                try {
                    this.processTreeBuffers();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    @Override
    public boolean isNodeExpanded(ITreeNode node) {
        if (node != null) {
            return node.isExpanded();
        }
        return false;
    }

    @Override
    public void setNodeExpanded(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isExpanded() != b) {
            try {
                if (b) {
                    node.ensureChildrenLoaded();
                    this.ensureParentExpanded(node.getParentNode());
                }
                node.setExpandedInternal(b);
                this.fireNodeExpanded(node, b);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public boolean isAncestorNodeOf(ITreeNode parent, ITreeNode child) {
        ITreeNode t = child;
        while (t != null && t != parent) {
            t = t.getParentNode();
        }
        return t == parent;
    }

    @Override
    public boolean isAutoDiscardOnDelete() {
        return this.m_autoDiscardOnDelete;
    }

    @Override
    public void setAutoDiscardOnDelete(boolean on) {
        this.m_autoDiscardOnDelete = on;
    }

    @Override
    public void setNodeEnabledPermission(ITreeNode node, Permission p) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabledPermissionInternal(p);
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), CollectionUtility.hashSet((Object)node));
            }
        }
    }

    @Override
    public boolean isNodeEnabled(ITreeNode node) {
        if (node != null) {
            return node.isEnabled();
        }
        return false;
    }

    @Override
    public boolean isNodeEnabledGranted(ITreeNode node) {
        if (node != null) {
            return node.isEnabledGranted();
        }
        return false;
    }

    @Override
    public void setNodeEnabled(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabledInternal(b);
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
            }
        }
    }

    @Override
    public void setNodeEnabledGranted(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabledGrantedInternal(b);
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
            }
        }
    }

    @Override
    public void setNodeVisiblePermission(ITreeNode node, Permission p) {
        if ((node = this.resolveNode(node)) != null) {
            node.setVisiblePermissionInternal(p);
        }
    }

    @Override
    public boolean isNodeVisible(ITreeNode node) {
        if (node != null) {
            return node.isVisible();
        }
        return false;
    }

    @Override
    public boolean isNodeVisibleGranted(ITreeNode node) {
        if (node != null) {
            return node.isVisibleGranted();
        }
        return false;
    }

    @Override
    public void setNodeVisible(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            node.setVisibleInternal(b);
        }
    }

    @Override
    public void setNodeVisibleGranted(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            node.setVisibleGrantedInternal(b);
        }
    }

    @Override
    public boolean isNodeLeaf(ITreeNode node) {
        if (node != null) {
            return node.isLeaf();
        }
        return false;
    }

    @Override
    public void setNodeLeaf(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isLeaf() != b) {
            node.setLeafInternal(b);
            this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
        }
    }

    @Override
    public boolean isNodeChecked(ITreeNode node) {
        if (node != null) {
            return node.isChecked();
        }
        return false;
    }

    @Override
    public void setNodeChecked(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isChecked() != b) {
            ArrayList<ITreeNode> changedNodes = new ArrayList<ITreeNode>();
            node.setCheckedInternal(b);
            changedNodes.add(node);
            ITreeNode commonParent = node.getParentNode();
            if (b && !this.isMultiCheck()) {
                for (ITreeNode cn : this.getCheckedNodes()) {
                    if (cn == node) continue;
                    cn.setCheckedInternal(false);
                    changedNodes.add(cn);
                }
                commonParent = TreeUtility.findLowestCommonAncestorNode(changedNodes);
            }
            this.fireNodesUpdated(commonParent, changedNodes);
        }
    }

    @Override
    public int getNodeStatus(ITreeNode node) {
        if (node != null) {
            return node.getStatus();
        }
        return 0;
    }

    @Override
    public void setNodeStatus(ITreeNode node, int status) {
        if ((node = this.resolveNode(node)) != null && node.getStatus() != status) {
            node.setStatusInternal(status);
            this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
        }
    }

    @Override
    public Object getContainer() {
        return this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(Object container) {
        this.propertySupport.setProperty("container", container);
    }

    private void ensureParentExpanded(ITreeNode parent) {
        if (parent != null) {
            this.ensureParentExpanded(parent.getParentNode());
            if (!parent.isExpanded()) {
                this.setNodeExpanded(parent, true);
            }
        }
    }

    @Override
    public void ensureVisible(ITreeNode node) {
        this.fireNodeEnsureVisible(node);
    }

    @Override
    public void expandAll(ITreeNode parent) {
        this.expandAllRec(parent, 0);
    }

    private void expandAllRec(ITreeNode parent, int level) {
        this.setNodeExpanded(parent, true);
        if (level >= 32) {
            LOG.warn("detected loop on tree node " + parent);
        } else {
            List<ITreeNode> children = parent.getChildNodes();
            for (ITreeNode child : children) {
                this.expandAllRec(child, level + 1);
            }
        }
    }

    @Override
    public void collapseAll(ITreeNode parent) {
        try {
            this.setTreeChanging(true);
            ArrayList<ITreeNode> list = new ArrayList<ITreeNode>();
            this.fetchAllCollapsingNodesRec(parent, 0, list);
            int n = list.size();
            int i = n - 1;
            while (i >= 0) {
                this.setNodeExpanded(list.get(i), false);
                --i;
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    private void fetchAllCollapsingNodesRec(ITreeNode parent, int level, List<ITreeNode> list) {
        if (level >= 32) {
            LOG.warn("detected loop on tree node " + parent);
        } else if (parent.isExpanded()) {
            list.add(parent);
            List<ITreeNode> children = parent.getChildNodes();
            for (ITreeNode child : children) {
                this.fetchAllCollapsingNodesRec(child, level + 1, list);
            }
        }
    }

    @Override
    public List<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.arrayList((Collection)this.propertySupport.getPropertyList("keyStroks"));
    }

    @Override
    public void setKeyStrokes(List<? extends IKeyStroke> keyStrokes) {
        this.m_baseKeyStrokes = CollectionUtility.arrayListWithoutNullElements(keyStrokes);
        this.rebuildKeyStrokesInternal();
    }

    private void setKeyStrokesInternal(List<? extends IKeyStroke> keyStrokes) {
        this.propertySupport.setPropertyList("keyStroks", keyStrokes);
    }

    @Override
    public void addChildNode(ITreeNode parent, ITreeNode child) {
        if (child != null) {
            this.addChildNodes(parent, CollectionUtility.arrayList((Object)child));
        }
    }

    @Override
    public void addChildNode(int startIndex, ITreeNode parent, ITreeNode child) {
        if (child != null) {
            this.addChildNodes(startIndex, parent, CollectionUtility.arrayList((Object)child));
        }
    }

    @Override
    public void addChildNodes(ITreeNode parent, List<? extends ITreeNode> children) {
        this.addChildNodes(parent.getChildNodeCount(), parent, children);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addChildNodes(int startIndex, ITreeNode parent, List<? extends ITreeNode> children) {
        if (!CollectionUtility.hasElements(children)) {
            return;
        }
        try {
            void var5_8;
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            ((AbstractTreeNode)parent).addChildNodesInternal(startIndex, children, true);
            ArrayList<ITreeNode> newChildren = new ArrayList<ITreeNode>();
            for (ITreeNode iTreeNode : children) {
                if (iTreeNode.getParentNode() == null) continue;
                newChildren.add(iTreeNode);
            }
            this.decorateAffectedNodeCells(parent, newChildren);
            boolean bl = false;
            ITreeNode tmp = parent;
            while (tmp != null) {
                tmp = tmp.getParentNode();
                ++var5_8;
            }
            for (ITreeNode child : newChildren) {
                this.applyNodeFiltersRecInternal(child, parent.isFilterAccepted(), (int)var5_8);
            }
            this.fireNodesInserted(parent, newChildren);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void updateNode(ITreeNode node) {
        if (node != null) {
            this.updateChildNodes(node.getParentNode(), CollectionUtility.hashSet((Object)node));
        }
    }

    @Override
    public void updateChildNodes(ITreeNode parent, Collection<? extends ITreeNode> children) {
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            List<ITreeNode> resolvedChildren = this.resolveNodes(children);
            this.decorateAffectedNodeCells(parent, resolvedChildren);
            this.fireNodesUpdated(parent, resolvedChildren);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void updateChildNodeOrder(ITreeNode parent, List<? extends ITreeNode> newChildren) {
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            List<ITreeNode> newChildrenResolved = this.resolveNodes(newChildren);
            if (newChildren.size() > 0 && newChildrenResolved.size() == newChildren.size()) {
                ((AbstractTreeNode)parent).setChildNodeOrderInternal(newChildrenResolved);
                this.decorateAffectedNodeCells(parent, newChildrenResolved);
                this.fireChildNodeOrderChanged(parent, newChildrenResolved);
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void removeNode(ITreeNode node) {
        ITreeNode parent = node.getParentNode();
        ITreeNode child = node;
        this.removeChildNode(parent, child);
    }

    @Override
    public void removeChildNode(ITreeNode parent, ITreeNode child) {
        this.removeChildNodes(parent, CollectionUtility.hashSet((Object)child));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeChildNodes(ITreeNode parent, Collection<? extends ITreeNode> children) {
        if (!CollectionUtility.hasElements(children)) {
            return;
        }
        try {
            void var3_6;
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            if (parent == null) {
                return;
            }
            children = this.resolveNodes(children);
            this.deselectNodes(children);
            ((AbstractTreeNode)parent).removeChildNodesInternal(children, true);
            this.decorateAffectedNodeCells(parent, parent.getChildNodes());
            if (!this.isAutoDiscardOnDelete()) {
                for (ITreeNode iTreeNode : children) {
                    if (iTreeNode.getStatus() == 1) continue;
                    iTreeNode.setStatusInternal(3);
                    this.m_deletedNodes.put(iTreeNode.getPrimaryKey(), iTreeNode);
                }
            }
            boolean bl = false;
            ITreeNode tmp = parent;
            while (tmp != null) {
                tmp = tmp.getParentNode();
                ++var3_6;
            }
            for (ITreeNode child : parent.getChildNodes()) {
                this.applyNodeFiltersRecInternal(child, parent.isFilterAccepted(), (int)var3_6);
            }
            this.fireNodesDeleted(parent, children);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void removeAllChildNodes(ITreeNode parent) {
        if (parent != null) {
            this.removeChildNodes(parent, parent.getChildNodes());
        }
    }

    @Override
    public void clearDeletedNodes() {
        Iterator<ITreeNode> it = this.m_deletedNodes.values().iterator();
        while (it.hasNext()) {
            it.next().setTreeInternal(null, true);
        }
        this.m_deletedNodes.clear();
    }

    @Override
    public Set<ITreeNode> resolveVirtualNodes(Collection<? extends ITreeNode> nodes) throws ProcessingException {
        if (!CollectionUtility.hasElements(nodes)) {
            return CollectionUtility.hashSet((Object[])new ITreeNode[0]);
        }
        try {
            this.setTreeChanging(true);
            HashSet<ITreeNode> resolvedNodes = new HashSet<ITreeNode>(nodes.size());
            for (ITreeNode iTreeNode : nodes) {
                ITreeNode resolvedNode = this.resolveVirtualNode(iTreeNode);
                if (resolvedNode == null) continue;
                resolvedNodes.add(resolvedNode);
            }
            HashSet<ITreeNode> hashSet = resolvedNodes;
            return hashSet;
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public ITreeNode resolveVirtualNode(ITreeNode node) throws ProcessingException {
        if (node instanceof IVirtualTreeNode) {
            IVirtualTreeNode vnode = (IVirtualTreeNode)node;
            if (vnode.getResolvedNode() != null && vnode.getResolvedNode().getTree() == this) {
                return vnode.getResolvedNode();
            }
            if (vnode.getTree() != this) {
                return null;
            }
            ITreeNode parentNode = vnode.getParentNode();
            if (parentNode == null) {
                return null;
            }
            try {
                this.setTreeChanging(true);
                ITreeNode resolvedNode = parentNode.resolveVirtualChildNode(vnode);
                if (resolvedNode != vnode && vnode.getResolvedNode() == null) {
                    vnode.setResolvedNode(resolvedNode);
                }
                ITreeNode iTreeNode = resolvedNode;
                return iTreeNode;
            }
            finally {
                this.setTreeChanging(false);
            }
        }
        return node;
    }

    @Override
    public boolean visitTree(ITreeVisitor v) {
        return this.visitNodeRec(this.getRootNode(), v);
    }

    @Override
    public boolean visitNode(ITreeNode node, ITreeVisitor v) {
        return this.visitNodeRec(node, v);
    }

    private boolean visitNodeRec(ITreeNode node, ITreeVisitor v) {
        if (node == null) {
            return true;
        }
        boolean b = v.visit(node);
        if (!b) {
            return b;
        }
        List<ITreeNode> a = node.getChildNodes();
        for (ITreeNode childNode : a) {
            if (childNode.getTree() == null || (b = this.visitNodeRec(childNode, v))) continue;
            return b;
        }
        return true;
    }

    @Override
    public boolean visitVisibleTree(ITreeVisitor v) {
        return this.visitVisibleNodeRec(this.getRootNode(), v, this.isRootNodeVisible());
    }

    private boolean visitVisibleNodeRec(ITreeNode node, ITreeVisitor v, boolean includeParent) {
        if (node.isVisible()) {
            boolean b;
            if (includeParent && !(b = v.visit(node))) {
                return b;
            }
            if (node.isExpanded()) {
                List<ITreeNode> a = node.getFilteredChildNodes();
                for (ITreeNode filteredChildNode : a) {
                    boolean b2;
                    if (filteredChildNode.getTree() == null || (b2 = this.visitVisibleNodeRec(filteredChildNode, v, true))) continue;
                    return b2;
                }
            }
        }
        return true;
    }

    @Override
    public int getDeletedNodeCount() {
        return this.m_deletedNodes.size();
    }

    @Override
    public Set<ITreeNode> getDeletedNodes() {
        return CollectionUtility.hashSet(this.m_deletedNodes.values());
    }

    @Override
    public int getInsertedNodeCount() {
        P_AbstractCountingTreeVisitor v = new P_AbstractCountingTreeVisitor(this){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusInserted()) {
                    this.addCount(1);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getCount();
    }

    @Override
    public Set<ITreeNode> getInsertedNodes() {
        P_AbstractCollectingTreeVisitor v = new P_AbstractCollectingTreeVisitor(this){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusInserted()) {
                    this.addNodeToList(node);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return CollectionUtility.hashSet(v.getNodes());
    }

    @Override
    public int getUpdatedNodeCount() {
        P_AbstractCountingTreeVisitor v = new P_AbstractCountingTreeVisitor(this){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusUpdated()) {
                    this.addCount(1);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getCount();
    }

    @Override
    public Set<ITreeNode> getUpdatedNodes() {
        P_AbstractCollectingTreeVisitor v = new P_AbstractCollectingTreeVisitor(this){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusUpdated()) {
                    this.addNodeToList(node);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return CollectionUtility.hashSet(v.getNodes());
    }

    @Override
    public int getSelectedNodeCount() {
        return this.m_selectedNodes.size();
    }

    @Override
    public ITreeNode getSelectedNode() {
        if (this.m_selectedNodes.size() > 0) {
            return this.m_selectedNodes.iterator().next();
        }
        return null;
    }

    @Override
    public Set<ITreeNode> getSelectedNodes() {
        return CollectionUtility.hashSet(this.m_selectedNodes);
    }

    @Override
    public boolean isSelectedNode(ITreeNode node) {
        if ((node = this.resolveNode(node)) != null) {
            return this.m_selectedNodes.contains(node);
        }
        return false;
    }

    @Override
    public void selectNode(ITreeNode node) {
        this.selectNode(node, false);
    }

    @Override
    public void selectNode(ITreeNode node, boolean append) {
        if (node != null) {
            this.selectNodes(CollectionUtility.hashSet((Object)node), append);
        } else {
            this.selectNodes(null, append);
        }
    }

    @Override
    public void selectNodes(Collection<? extends ITreeNode> nodes, boolean append) {
        nodes = this.resolveNodes(nodes);
        try {
            nodes = this.resolveVirtualNodes(nodes);
        }
        catch (ProcessingException e) {
            LOG.warn("could not resolve virtual nodes.", (Throwable)e);
        }
        if (nodes == null) {
            nodes = CollectionUtility.hashSet((Object[])new ITreeNode[0]);
        }
        HashSet<ITreeNode> newSelection = new HashSet<ITreeNode>();
        if (append) {
            newSelection.addAll(this.m_selectedNodes);
            newSelection.addAll(nodes);
        } else {
            newSelection.addAll(nodes);
        }
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITreeNode first = (ITreeNode)newSelection.iterator().next();
            newSelection.clear();
            newSelection.add(first);
        }
        if (!this.m_selectedNodes.equals(newSelection) || !this.m_selectedNodes.containsAll(nodes)) {
            Set<ITreeNode> oldSelection = this.m_selectedNodes;
            this.fireBeforeNodesSelected(oldSelection, newSelection);
            this.m_selectedNodes = newSelection;
            this.fireNodesSelected(oldSelection, this.m_selectedNodes);
        }
    }

    @Override
    public void selectNextNode() {
        final ITreeNode current = this.getSelectedNode();
        if (current != null) {
            final Holder foundVisited = new Holder(ITreeNode.class);
            ITreeVisitor v = new ITreeVisitor(){
                boolean foundCurrent;

                @Override
                public boolean visit(ITreeNode node) {
                    if (this.foundCurrent) {
                        if (node.isFilterAccepted()) {
                            foundVisited.setValue((Object)node);
                        }
                        return foundVisited.getValue() == null;
                    }
                    if (node == current) {
                        this.foundCurrent = true;
                    }
                    return true;
                }
            };
            this.visitVisibleTree(v);
            if (foundVisited.getValue() != null) {
                this.selectNode((ITreeNode)foundVisited.getValue());
            }
        } else {
            this.selectFirstNode();
        }
    }

    @Override
    public void selectPreviousNode() {
        final ITreeNode current = this.getSelectedNode();
        if (current != null) {
            final Holder foundVisited = new Holder(ITreeNode.class);
            ITreeVisitor v = new ITreeVisitor(){
                boolean foundCurrent;

                @Override
                public boolean visit(ITreeNode node) {
                    if (this.foundCurrent) {
                        return false;
                    }
                    if (node == current) {
                        this.foundCurrent = true;
                    } else if (node.isFilterAccepted()) {
                        foundVisited.setValue((Object)node);
                    }
                    return true;
                }
            };
            this.visitVisibleTree(v);
            if (foundVisited.getValue() != null) {
                this.selectNode((ITreeNode)foundVisited.getValue());
            }
        } else {
            this.selectLastNode();
        }
    }

    @Override
    public void selectFirstNode() {
        if (!this.isRootNodeVisible()) {
            try {
                this.getRootNode().ensureChildrenLoaded();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
        final Holder foundVisited = new Holder(ITreeNode.class);
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (foundVisited.getValue() != null) {
                    return false;
                }
                if (node.isFilterAccepted()) {
                    foundVisited.setValue((Object)node);
                }
                return true;
            }
        };
        this.visitVisibleTree(v);
        if (foundVisited.getValue() != null) {
            this.selectNode((ITreeNode)foundVisited.getValue());
        }
    }

    @Override
    public void selectLastNode() {
        if (!this.isRootNodeVisible()) {
            try {
                this.getRootNode().ensureChildrenLoaded();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
        final Holder foundVisited = new Holder(ITreeNode.class);
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isFilterAccepted()) {
                    foundVisited.setValue((Object)node);
                }
                return true;
            }
        };
        this.visitVisibleTree(v);
        if (foundVisited.getValue() != null) {
            this.selectNode((ITreeNode)foundVisited.getValue());
        }
    }

    @Override
    public void selectNextChildNode() {
        ITreeNode current = this.getSelectedNode();
        if (current != null) {
            current.setExpanded(true);
        }
        this.selectNextNode();
    }

    @Override
    public void selectPreviousParentNode() {
        ITreeNode n = this.getSelectedNode();
        if (n != null) {
            ITreeNode parent = n.getParentNode();
            while (parent != null) {
                if ((parent != this.getRootNode() || this.isRootNodeVisible()) && parent.isFilterAccepted()) {
                    this.selectNode(parent);
                    return;
                }
                parent = parent.getParentNode();
            }
        } else {
            this.selectFirstNode();
        }
    }

    @Override
    public void deselectNode(ITreeNode node) {
        if (node != null) {
            this.deselectNodes(CollectionUtility.hashSet((Object)node));
        } else {
            this.deselectNodes(null);
        }
    }

    @Override
    public void deselectNodes(Collection<? extends ITreeNode> nodes) {
        if (CollectionUtility.hasElements(nodes = this.resolveNodes(nodes))) {
            HashSet<ITreeNode> oldSelection = new HashSet<ITreeNode>(this.m_selectedNodes);
            HashSet<ITreeNode> newSelection = new HashSet<ITreeNode>();
            if (this.m_selectedNodes != null) {
                for (ITreeNode selChild : this.m_selectedNodes) {
                    boolean accept = true;
                    for (ITreeNode iTreeNode : nodes) {
                        if (!this.isAncestorNodeOf(iTreeNode, selChild)) continue;
                        accept = false;
                        break;
                    }
                    if (!accept) continue;
                    newSelection.add(selChild);
                }
            }
            if (oldSelection.size() != newSelection.size()) {
                this.fireBeforeNodesSelected(oldSelection, newSelection);
                this.m_selectedNodes = newSelection;
                this.fireNodesSelected(oldSelection, this.m_selectedNodes);
            }
        }
    }

    @Override
    public Set<ITreeNode> getCheckedNodes() {
        final ArrayList list = new ArrayList();
        this.visitTree(new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isChecked()) {
                    list.add(node);
                }
                return true;
            }
        });
        return CollectionUtility.hashSet(list);
    }

    @Override
    public boolean isScrollToSelection() {
        return this.propertySupport.getPropertyBool("scrollToSelection");
    }

    @Override
    public void setScrollToSelection(boolean b) {
        this.propertySupport.setPropertyBool("scrollToSelection", b);
    }

    @Override
    public void scrollToSelection() {
        this.fireTreeEventInternal(new TreeEvent(this, 830));
    }

    private ITreeNode resolveNode(ITreeNode node) {
        if (node instanceof IVirtualTreeNode && ((IVirtualTreeNode)node).getResolvedNode() != null) {
            node = ((IVirtualTreeNode)node).getResolvedNode();
        }
        if (node == null) {
            return null;
        }
        if (node.getTree() == this) {
            return node;
        }
        return null;
    }

    private List<ITreeNode> resolveNodes(Collection<? extends ITreeNode> nodes) {
        if (!CollectionUtility.hasElements(nodes)) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ITreeNode> resolvedNodes = new ArrayList<ITreeNode>(nodes.size());
        for (ITreeNode iTreeNode : nodes) {
            if (this.resolveNode(iTreeNode) == null) continue;
            resolvedNodes.add(iTreeNode);
        }
        return resolvedNodes;
    }

    @Override
    public void addTreeListener(TreeListener listener) {
        this.m_listenerList.add(TreeListener.class, (EventListener)listener);
    }

    @Override
    public void removeTreeListener(TreeListener listener) {
        this.m_listenerList.remove(TreeListener.class, (EventListener)listener);
    }

    @Override
    public void addUITreeListener(TreeListener listener) {
        this.m_listenerList.insertAtFront(TreeListener.class, (EventListener)listener);
    }

    protected IEventHistory<TreeEvent> createEventHistory() {
        return new DefaultTreeEventHistory(5000L);
    }

    @Override
    public IEventHistory<TreeEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    private void fireNodesInserted(ITreeNode parent, List<ITreeNode> children) {
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 10, parent, children));
        }
    }

    private void fireNodesUpdated(ITreeNode parent, Collection<ITreeNode> children) {
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 20, parent, children));
        }
    }

    @Override
    public void fireNodeChanged(ITreeNode node) {
        this.fireTreeEventInternal(new TreeEvent((ITree)this, 850, node));
    }

    private void fireNodeFilterChanged() {
        this.fireTreeEventInternal(new TreeEvent((ITree)this, 400, this.getRootNode()));
    }

    private void fireNodesDeleted(ITreeNode parent, Collection<? extends ITreeNode> children) {
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 30, parent, children));
        }
    }

    private void fireChildNodeOrderChanged(ITreeNode parent, List<? extends ITreeNode> children) {
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 50, parent, children));
        }
    }

    private void fireBeforeNodesSelected(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        TreeEvent e = new TreeEvent((ITree)this, 35, newSelection);
        HashSet<ITreeNode> deselectedNodes = new HashSet<ITreeNode>(oldSelection);
        deselectedNodes.removeAll(newSelection);
        e.setDeselectedNodes(deselectedNodes);
        HashSet<ITreeNode> newSelectedNodes = new HashSet<ITreeNode>(newSelection);
        newSelectedNodes.removeAll(oldSelection);
        e.setNewSelectedNodes(newSelectedNodes);
        this.fireTreeEventInternal(e);
    }

    private void fireNodesSelected(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        if (this.isAutoTitle()) {
            this.rebuildTitleInternal();
        }
        TreeEvent e = new TreeEvent((ITree)this, 40, newSelection);
        HashSet<ITreeNode> deselectedNodes = new HashSet<ITreeNode>(oldSelection);
        deselectedNodes.removeAll(newSelection);
        e.setDeselectedNodes(deselectedNodes);
        HashSet<ITreeNode> newSelectedNodes = new HashSet<ITreeNode>(newSelection);
        newSelectedNodes.removeAll(oldSelection);
        e.setNewSelectedNodes(newSelectedNodes);
        this.updateNodeMenus(newSelection);
        try {
            this.interceptNodesSelected(e);
        }
        catch (ProcessingException ex) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
        this.fireTreeEventInternal(e);
    }

    protected void updateNodeMenus(Set<ITreeNode> newSelectedNodes) {
        if (this.m_currentNodeMenus != null) {
            this.getContextMenu().removeChildActions(this.m_currentNodeMenus);
            this.m_currentNodeMenus = null;
        }
        ArrayList<IMenu> nodeMenus = new ArrayList<IMenu>();
        if (CollectionUtility.hasElements(newSelectedNodes)) {
            nodeMenus.addAll(((ITreeNode)CollectionUtility.firstElement(newSelectedNodes)).getMenus());
            this.m_currentNodeMenus = nodeMenus;
            this.getContextMenu().addChildActions(nodeMenus);
        }
    }

    private void fireNodeExpanded(ITreeNode node, boolean b) {
        if (node != null) {
            if (b) {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 100, node));
            } else {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 101, node));
            }
        }
    }

    private void fireNodeClick(ITreeNode node, MouseButton mouseButton) {
        if (node != null) {
            try {
                this.interceptNodeClickSingleObserver(node);
                this.interceptNodeClick(node, mouseButton);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }

    protected void interceptNodeClickSingleObserver(ITreeNode node) {
        if (this.isCheckable() && node.isEnabled() && this.isEnabled()) {
            node.setChecked(!node.isChecked());
        }
    }

    private void fireNodeAction(ITreeNode node) {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                if (node != null && node.isLeaf()) {
                    try {
                        this.interceptNodeAction(node);
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                    }
                }
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    private void fireRequestFocus() {
        TreeEvent e = new TreeEvent(this, 800);
        this.fireTreeEventInternal(e);
    }

    private TransferObject fireNodesDragRequest(Collection<ITreeNode> nodes) {
        if (CollectionUtility.hasElements(nodes)) {
            TreeEvent e = new TreeEvent((ITree)this, 730, nodes);
            this.fireTreeEventInternal(e);
            return e.getDragObject();
        }
        return null;
    }

    private void fireNodeDropAction(ITreeNode node, TransferObject dropData) {
        TreeEvent e = new TreeEvent((ITree)this, 740, node);
        e.setDropObject(dropData);
        this.fireTreeEventInternal(e);
    }

    public void fireNodeDropTargetChanged(ITreeNode node) {
        TreeEvent e = new TreeEvent((ITree)this, 860, node);
        this.fireTreeEventInternal(e);
    }

    public void fireDragFinished() {
        TreeEvent e = new TreeEvent(this, 735);
        this.fireTreeEventInternal(e);
    }

    private void fireNodeRequestFocus(ITreeNode node) {
        TreeEvent e = new TreeEvent((ITree)this, 200, node);
        this.fireTreeEventInternal(e);
    }

    private void fireNodeEnsureVisible(ITreeNode node) {
        TreeEvent e = new TreeEvent((ITree)this, 300, node);
        this.fireTreeEventInternal(e);
    }

    protected void fireTreeEventInternal(TreeEvent e) {
        if (this.isTreeChanging()) {
            this.m_treeEventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(TreeListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    try {
                        ((TreeListener)listeners[i]).treeChanged(e);
                    }
                    catch (Throwable t) {
                        LOG.error("fire " + e, t);
                    }
                    ++i;
                }
            }
        }
    }

    private void fireTreeEventBatchInternal(List<? extends TreeEvent> batch) {
        EventListener[] listeners;
        if (CollectionUtility.hasElements(batch) && (listeners = this.m_listenerList.getListeners(TreeListener.class)) != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((TreeListener)listeners[i]).treeChangedBatch(batch);
                ++i;
            }
        }
    }

    private void decorateAffectedNodeCells(ITreeNode parent, Collection<ITreeNode> children) {
        this.decorateAffectedNodeCellsOnPathToRoot(parent);
        for (ITreeNode child : children) {
            this.decorateAffectedNodeCellsOnSubtree(child);
        }
    }

    private void decorateAffectedNodeCellsOnPathToRoot(ITreeNode node) {
        ITreeNode tmp = node;
        while (tmp != null) {
            this.m_nodeDecorationBuffer.add(tmp);
            tmp = tmp.getParentNode();
        }
    }

    private void decorateAffectedNodeCellsOnSubtree(ITreeNode node) {
        this.m_nodeDecorationBuffer.add(node);
        for (ITreeNode child : node.getChildNodes()) {
            this.decorateAffectedNodeCellsOnSubtree(child);
        }
    }

    private void processTreeBuffers() {
        try {
            ++this.m_processTreeBufferLoopDetection;
            if (this.m_processTreeBufferLoopDetection > 100) {
                LOG.error("LOOP DETECTION in " + this.getClass() + ". see stack trace for more details.", (Throwable)new Exception("LOOP DETECTION"));
                return;
            }
            this.processDecorationBuffer();
            this.processEventBuffer();
        }
        finally {
            --this.m_processTreeBufferLoopDetection;
        }
    }

    private void processDecorationBuffer() {
        if (this.m_nodeDecorationBuffer.size() > 0) {
            Set<ITreeNode> set = this.m_nodeDecorationBuffer;
            this.m_nodeDecorationBuffer = new HashSet<ITreeNode>();
            try {
                this.setTreeChanging(true);
                for (ITreeNode node : set) {
                    if (node.getTree() == null) continue;
                    try {
                        this.interceptDecorateCell(node, node.getCellForUpdate());
                    }
                    catch (Throwable t) {
                        LOG.warn("node " + node.getClass() + " " + node.getCell().getText(), t);
                    }
                }
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    private void processEventBuffer() {
        if (this.m_treeEventBuffer.size() > 0) {
            List<TreeEvent> list = this.m_treeEventBuffer;
            this.m_treeEventBuffer = new ArrayList<TreeEvent>();
            boolean foundSelectionEvent = false;
            ListIterator<TreeEvent> it = list.listIterator(list.size());
            while (it.hasPrevious()) {
                if (it.previous().getType() != 40) continue;
                if (!foundSelectionEvent) {
                    foundSelectionEvent = true;
                    continue;
                }
                it.remove();
            }
            try {
                this.setTreeChanging(true);
                this.fireTreeEventBatchInternal(list);
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean b) {
        this.propertySupport.setPropertyBool("multiSelect", b);
    }

    @Override
    public boolean isMultiCheck() {
        return this.propertySupport.getPropertyBool("multiCheck");
    }

    @Override
    public void setMultiCheck(boolean b) {
        this.propertySupport.setPropertyBool("multiCheck", b);
    }

    @Override
    public void unloadNode(ITreeNode node) throws ProcessingException {
        try {
            this.setTreeChanging(true);
            this.setNodeExpanded(node, false);
            this.removeAllChildNodes(node);
            node.setChildrenLoaded(false);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void doHyperlinkAction(ITreeNode node, URL url) throws ProcessingException {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                if (node != null) {
                    this.selectNode(node);
                    this.interceptHyperlinkAction(url, url.getPath(), url != null && "local".equals(url.getHost()));
                }
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    @Override
    public void exportTreeData(AbstractTreeFieldData target) throws ProcessingException {
        this.exportTreeNodeDataRec(this.getRootNode().getChildNodes(), target, null);
    }

    private void exportTreeNodeDataRec(List<ITreeNode> nodes, AbstractTreeFieldData treeData, TreeNodeData parentNodeData) throws ProcessingException {
        ArrayList<TreeNodeData> nodeDataList = new ArrayList<TreeNodeData>(nodes.size());
        for (ITreeNode node : nodes) {
            TreeNodeData nodeData = this.exportTreeNodeData(node, treeData);
            if (nodeData == null) continue;
            this.exportTreeNodeDataRec(node.getChildNodes(), treeData, nodeData);
            nodeDataList.add(nodeData);
        }
        if (parentNodeData != null) {
            parentNodeData.setChildNodes(nodeDataList);
        } else {
            treeData.setRoots(nodeDataList);
        }
    }

    protected TreeNodeData exportTreeNodeData(ITreeNode node, AbstractTreeFieldData treeData) throws ProcessingException {
        TreeNodeData nodeData = new TreeNodeData();
        return nodeData;
    }

    @Override
    public void importTreeData(AbstractTreeFieldData source) throws ProcessingException {
        if (source.isValueSet()) {
            try {
                this.setTreeChanging(true);
                this.removeAllChildNodes(this.getRootNode());
                this.importTreeNodeDataRec(this.getRootNode(), source, source.getRoots());
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    private void importTreeNodeDataRec(ITreeNode parentNode, AbstractTreeFieldData treeData, List<TreeNodeData> nodeDataList) throws ProcessingException {
        if (nodeDataList != null) {
            for (TreeNodeData nodeData : nodeDataList) {
                ITreeNode node = this.importTreeNodeData(parentNode, treeData, nodeData);
                if (node == null) continue;
                this.importTreeNodeDataRec(node, treeData, nodeData.getChildNodes());
            }
        }
    }

    protected ITreeNode importTreeNodeData(ITreeNode parentNode, AbstractTreeFieldData treeData, TreeNodeData nodeData) throws ProcessingException {
        return null;
    }

    @Override
    public ITreeUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public boolean isSaveAndRestoreScrollbars() {
        return this.m_saveAndRestoreScrollbars;
    }

    @Override
    public void setSaveAndRestoreScrollbars(boolean b) {
        this.m_saveAndRestoreScrollbars = b;
    }

    protected final void interceptDrop(ITreeNode node, TransferObject t) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDropChain chain = new TreeChains.TreeDropChain(extensions);
        chain.execDrop(node, t);
    }

    protected final void interceptInitTree() throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeInitTreeChain chain = new TreeChains.TreeInitTreeChain(extensions);
        chain.execInitTree();
    }

    protected final void interceptDropTargetChanged(ITreeNode node) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDropTargetChangedChain chain = new TreeChains.TreeDropTargetChangedChain(extensions);
        chain.execDropTargetChanged(node);
    }

    protected final TransferObject interceptDrag(Collection<ITreeNode> nodes) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDragNodesChain chain = new TreeChains.TreeDragNodesChain(extensions);
        return chain.execDrag(nodes);
    }

    protected final void interceptNodeAction(ITreeNode node) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodeActionChain chain = new TreeChains.TreeNodeActionChain(extensions);
        chain.execNodeAction(node);
    }

    protected final void interceptNodeClick(ITreeNode node, MouseButton mouseButton) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodeClickChain chain = new TreeChains.TreeNodeClickChain(extensions);
        chain.execNodeClick(node, mouseButton);
    }

    protected final void interceptHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeHyperlinkActionChain chain = new TreeChains.TreeHyperlinkActionChain(extensions);
        chain.execHyperlinkAction(url, path, local);
    }

    protected final void interceptNodesSelected(TreeEvent e) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodesSelectedChain chain = new TreeChains.TreeNodesSelectedChain(extensions);
        chain.execNodesSelected(e);
    }

    protected final void interceptDisposeTree() throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDisposeTreeChain chain = new TreeChains.TreeDisposeTreeChain(extensions);
        chain.execDisposeTree();
    }

    protected final void interceptDecorateCell(ITreeNode node, Cell cell) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDecorateCellChain chain = new TreeChains.TreeDecorateCellChain(extensions);
        chain.execDecorateCell(node, cell);
    }

    protected final TransferObject interceptDrag(ITreeNode node) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDragNodeChain chain = new TreeChains.TreeDragNodeChain(extensions);
        return chain.execDrag(node);
    }

    protected static class LocalTreeExtension<OWNER extends AbstractTree>
    extends AbstractExtension<OWNER>
    implements ITreeExtension<OWNER> {
        public LocalTreeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDrop(TreeChains.TreeDropChain chain, ITreeNode node, TransferObject t) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execDrop(node, t);
        }

        @Override
        public void execInitTree(TreeChains.TreeInitTreeChain chain) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execInitTree();
        }

        @Override
        public void execDropTargetChanged(TreeChains.TreeDropTargetChangedChain chain, ITreeNode node) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execDropTargetChanged(node);
        }

        @Override
        public TransferObject execDrag(TreeChains.TreeDragNodesChain chain, Collection<ITreeNode> nodes) throws ProcessingException {
            return ((AbstractTree)this.getOwner()).execDrag(nodes);
        }

        @Override
        public void execNodeAction(TreeChains.TreeNodeActionChain chain, ITreeNode node) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execNodeAction(node);
        }

        @Override
        public void execNodeClick(TreeChains.TreeNodeClickChain chain, ITreeNode node, MouseButton mouseButton) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execNodeClick(node, mouseButton);
        }

        @Override
        public void execHyperlinkAction(TreeChains.TreeHyperlinkActionChain chain, URL url, String path, boolean local) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execHyperlinkAction(url, path, local);
        }

        @Override
        public void execNodesSelected(TreeChains.TreeNodesSelectedChain chain, TreeEvent e) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execNodesSelected(e);
        }

        @Override
        public void execDisposeTree(TreeChains.TreeDisposeTreeChain chain) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execDisposeTree();
        }

        @Override
        public void execDecorateCell(TreeChains.TreeDecorateCellChain chain, ITreeNode node, Cell cell) throws ProcessingException {
            ((AbstractTree)this.getOwner()).execDecorateCell(node, cell);
        }

        @Override
        public TransferObject execDrag(TreeChains.TreeDragNodeChain chain, ITreeNode node) throws ProcessingException {
            return ((AbstractTree)this.getOwner()).execDrag(node);
        }
    }

    private abstract class P_AbstractCollectingTreeVisitor
    implements ITreeVisitor {
        private final List<ITreeNode> m_list = new ArrayList<ITreeNode>();

        private P_AbstractCollectingTreeVisitor() {
        }

        protected void addNodeToList(ITreeNode node) {
            this.m_list.add(node);
        }

        public List<ITreeNode> getNodes() {
            return CollectionUtility.arrayList(this.m_list);
        }
    }

    private abstract class P_AbstractCountingTreeVisitor
    implements ITreeVisitor {
        private int m_count;

        private P_AbstractCountingTreeVisitor() {
        }

        protected void addCount(int n) {
            this.m_count += n;
        }

        public int getCount() {
            return this.m_count;
        }
    }

    private class P_UIFacade
    implements ITreeUIFacade {
        private int m_uiProcessorCount = 0;

        private P_UIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void setNodeExpandedFromUI(ITreeNode node, boolean on) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        node = AbstractTree.this.resolveNode(node);
                        node = AbstractTree.this.resolveVirtualNode(node);
                        if (node != null && node.isExpanded() != on) {
                            if (on && (node.isChildrenDirty() || node.isChildrenVolatile())) {
                                node.loadChildren();
                            }
                            AbstractTree.this.setNodeExpanded(node, on);
                        }
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(node.getCell().getText());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setNodeSelectedAndExpandedFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        node = AbstractTree.this.resolveNode(node);
                        node = AbstractTree.this.resolveVirtualNode(node);
                        if (node != null) {
                            if (node.isChildrenDirty() || node.isChildrenVolatile()) {
                                node.loadChildren();
                            }
                            AbstractTree.this.setNodeExpanded(node, true);
                            AbstractTree.this.selectNode(node, false);
                            if (!AbstractTree.this.isScrollToSelection()) {
                                AbstractTree.this.scrollToSelection();
                            }
                        }
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(node.getCell().getText());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setNodesSelectedFromUI(List<ITreeNode> nodes) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        Set<ITreeNode> validNodes = AbstractTree.this.resolveVirtualNodes(AbstractTree.this.resolveNodes(nodes));
                        Iterator<ITreeNode> iterator = validNodes.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next().isFilterAccepted()) continue;
                            iterator.remove();
                        }
                        for (ITreeNode node : validNodes) {
                            if (!node.isChildrenLoaded() || !node.isChildrenDirty() && !node.isChildrenVolatile()) continue;
                            node.loadChildren();
                        }
                        AbstractTree.this.selectNodes(validNodes, false);
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(nodes.toString());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeClickFromUI(ITreeNode node, MouseButton mouseButton) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeClick(node, mouseButton);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeActionFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeAction(node);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireNodesDragRequestFromUI() {
            try {
                this.pushUIProcessor();
                Set<ITreeNode> nodes = AbstractTree.this.resolveVirtualNodes(AbstractTree.this.getSelectedNodes());
                TransferObject transferObject = AbstractTree.this.fireNodesDragRequest(nodes);
                return transferObject;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                return null;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireDragFinishedFromUI() {
            try {
                this.pushUIProcessor();
                AbstractTree.this.fireDragFinished();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeDropTargetChangedFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeDropTargetChanged(node);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeDropActionFromUI(ITreeNode node, TransferObject dropData) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeDropAction(node, dropData);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHyperlinkActionFromUI(ITreeNode node, URL url) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.doHyperlinkAction(node, url);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

