/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractAddAttributeMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public class EntityNode
extends AbstractComposerNode {
    private IDataModelEntity m_entity;
    private boolean m_negated = false;
    private List<Object> m_values;
    private List<String> m_texts;

    public EntityNode(IComposerField composerField, IDataModelEntity entity) {
        super(composerField, false);
        this.m_entity = entity;
        this.callInitializer();
    }

    @Override
    protected void execInitTreeNode() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        for (IMenu m : this.getMenus()) {
            if (m.getClass() == AddEntityPlaceholderOnEntityMenu.class) {
                this.attachAddEntityMenus(menus);
                continue;
            }
            menus.add(m);
        }
        if (menus.size() > 0 && ((IMenu)menus.get(menus.size() - 1)).getClass() == Separator2Menu.class) {
            menus.remove(menus.size() - 1);
        }
        this.setMenus(menus);
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        StringBuffer label = new StringBuffer();
        if (this.getSiblingBefore() != null) {
            label.append(String.valueOf(ScoutTexts.get((String)"ExtendedSearchAnd", (String[])new String[0])) + " ");
        }
        if (this.isNegative()) {
            label.append(String.valueOf(ScoutTexts.get((String)"ExtendedSearchNot", (String[])new String[0])) + " ");
        }
        label.append(this.m_entity.getText());
        if (this.getChildNodeCount() > 0) {
            label.append(" " + ScoutTexts.get((String)"ExtendedSearchEntitySuffix", (String[])new String[0]));
        }
        cell.setText(label.toString());
    }

    public IDataModelEntity getEntity() {
        return this.m_entity;
    }

    public void setEntity(IDataModelEntity e) {
        this.m_entity = e;
    }

    public boolean isNegative() {
        return this.m_negated;
    }

    public void setNegative(boolean b) {
        this.m_negated = b;
    }

    public List<Object> getValues() {
        return CollectionUtility.arrayList(this.m_values);
    }

    public void setValues(List<? extends Object> values) {
        this.m_values = CollectionUtility.arrayListWithoutNullElements(values);
    }

    public List<String> getTexts() {
        return CollectionUtility.arrayList(this.m_texts);
    }

    public void setTexts(List<String> texts) {
        this.m_texts = CollectionUtility.arrayListWithoutNullElements(texts);
    }

    @Order(value=10.0)
    public class AddAttributeOnEntityMenu
    extends AbstractAddAttributeMenu {
        public AddAttributeOnEntityMenu() {
            super(EntityNode.this.getComposerField(), EntityNode.this);
        }
    }

    @Order(value=20.0)
    public class AddEitherOrOnEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchAddEitherOrMenu", (String[])new String[0]);
        }

        @Override
        protected void execInitAction() throws ProcessingException {
            List atts = EntityNode.this.m_entity.getAttributes();
            List ents = EntityNode.this.m_entity.getEntities();
            this.setVisible(CollectionUtility.hasElements((Collection)atts) || CollectionUtility.hasElements((Collection)ents));
        }

        @Override
        protected void execAction() throws ProcessingException {
            EitherOrNode node = EntityNode.this.getComposerField().addEitherNode(EntityNode.this, false);
            EntityNode.this.getComposerField().addAdditionalOrNode(node, false);
        }
    }

    @Order(value=70.0)
    public class AddEntityPlaceholderOnEntityMenu
    extends AbstractMenuSeparator {
    }

    @Order(value=50.0)
    public class DeleteEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchRemoveMenu", (String[])new String[0]);
        }

        @Override
        protected String getConfiguredKeyStroke() {
            return "delete";
        }

        @Override
        protected void execAction() throws ProcessingException {
            EntityNode.this.getTree().selectPreviousParentNode();
            EntityNode.this.getTree().removeNode(EntityNode.this);
        }
    }

    @Order(value=40.0)
    public class NegateEntityMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchNegateMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EntityNode.this.setNegative(!EntityNode.this.isNegative());
            if (!EntityNode.this.isStatusInserted()) {
                EntityNode.this.setStatusInternal(2);
            }
            EntityNode.this.update();
        }
    }

    @Order(value=60.0)
    public class Separator2Menu
    extends AbstractMenuSeparator {
    }
}

