/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.inspector;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;

public class ReflectServiceInventory {
    private HashSet<PropertyDescriptor> m_properties = new HashSet();
    private HashSet<Method> m_operations = new HashSet();
    private ArrayList<String> m_states = new ArrayList();

    public ReflectServiceInventory(Object service) {
        this.analyzeService(service);
    }

    private void analyzeService(Object service) {
        Method[] methods;
        int n;
        HashSet<Method> propertyMethods = new HashSet<Method>();
        try {
            PropertyDescriptor[] a;
            BeanInfo info = Introspector.getBeanInfo(service.getClass());
            PropertyDescriptor[] propertyDescriptorArray = a = info.getPropertyDescriptors();
            int n2 = a.length;
            n = 0;
            while (n < n2) {
                PropertyDescriptor desc = propertyDescriptorArray[n];
                if (desc.getReadMethod() != null && desc.getWriteMethod() != null) {
                    this.addProperty(desc);
                } else if (desc.getName().startsWith("configured")) {
                    this.addProperty(desc);
                }
                if (desc.getReadMethod() != null) {
                    propertyMethods.add(desc.getReadMethod());
                }
                if (desc.getWriteMethod() != null) {
                    propertyMethods.add(desc.getWriteMethod());
                }
                ++n;
            }
        }
        catch (Throwable t) {
            this.m_states.add("Failure to analyze properties: " + t);
        }
        Method[] methodArray = methods = service.getClass().getMethods();
        n = methods.length;
        int n3 = 0;
        while (n3 < n) {
            Method m = methodArray[n3];
            if (Object.class.isAssignableFrom(m.getDeclaringClass()) && !propertyMethods.contains(m)) {
                this.addOperation(m);
            }
            ++n3;
        }
    }

    public PropertyDescriptor[] getProperties() {
        TreeMap<CompositeObject, PropertyDescriptor> sortMap = new TreeMap<CompositeObject, PropertyDescriptor>();
        int index = 0;
        for (PropertyDescriptor p : this.m_properties) {
            if (!p.getName().equals("class")) {
                if (p.getName().startsWith("configured")) {
                    sortMap.put(new CompositeObject(new Object[]{1, p.getName(), index}), p);
                } else {
                    sortMap.put(new CompositeObject(new Object[]{2, p.getName(), index}), p);
                }
            }
            ++index;
        }
        return sortMap.values().toArray(new PropertyDescriptor[0]);
    }

    public void addProperty(PropertyDescriptor desc) {
        this.m_properties.add(desc);
    }

    public void removeProperty(PropertyDescriptor desc) {
        this.m_properties.remove(desc);
    }

    public Method[] getOperations() {
        TreeMap<CompositeObject, Method> sortMap = new TreeMap<CompositeObject, Method>();
        int index = 0;
        for (Method m : this.m_operations) {
            if (!m.getName().equals("getInventory")) {
                if (m.getName().startsWith("exec")) {
                    sortMap.put(new CompositeObject(new Object[]{1, m.getName(), index}), m);
                } else {
                    sortMap.put(new CompositeObject(new Object[]{2, m.getName(), index}), m);
                }
            }
            ++index;
        }
        return sortMap.values().toArray(new Method[0]);
    }

    public void addOperation(Method op) {
        this.m_operations.add(op);
    }

    public void removeOperation(Method op) {
        this.m_operations.remove(op);
    }

    public String[] getStates() {
        return this.m_states.toArray(new String[0]);
    }

    public void addState(String text) {
        this.m_states.add(text);
    }
}

