/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.scheduler.AbstractScheduler;
import org.eclipse.scout.rt.server.scheduler.IScheduler;
import org.eclipse.scout.rt.server.scheduler.ISchedulerJob;
import org.eclipse.scout.rt.server.scheduler.TickSignal;
import org.eclipse.scout.rt.server.scheduler.Ticker;
import org.eclipse.scout.service.SERVICES;

public class Scheduler
extends AbstractScheduler
implements IScheduler {
    private final IServerJobFactory m_serverJobFactory;

    public Scheduler() throws ProcessingException {
        super(new Ticker(12));
        IServerJobService backendService = (IServerJobService)SERVICES.getService(IServerJobService.class);
        this.m_serverJobFactory = backendService.createJobFactory();
    }

    public Scheduler(Subject subject, Class<? extends IServerSession> serverSessionType) throws ProcessingException {
        this(subject, serverSessionType, new Ticker(12));
    }

    public Scheduler(Subject subject, Class<? extends IServerSession> serverSessionType, Ticker ticker) throws ProcessingException {
        super(ticker);
        IServerJobService backendService = (IServerJobService)SERVICES.getService(IServerJobService.class);
        this.m_serverJobFactory = backendService.createJobFactory(backendService.createServerSession(serverSessionType, subject), subject);
    }

    @Override
    public void handleJobExecution(final ISchedulerJob job, final TickSignal signal) throws ProcessingException {
        this.m_serverJobFactory.runNow(this.getJobName(job), new ITransactionRunnable(){

            @Override
            public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                job.run(Scheduler.this, signal);
                return Status.OK_STATUS;
            }
        });
    }

    protected String getJobName(ISchedulerJob job) {
        return "Scheduler." + job.getGroupId() + "." + job.getJobId();
    }
}

