/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.util.Collection;
import java.util.Set;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.rt.spec.client.AbstractSpecGenTest;
import org.eclipse.scout.rt.spec.client.config.entity.IDocEntityTableConfig;
import org.eclipse.scout.rt.spec.client.filter.FilterUtility;
import org.eclipse.scout.rt.spec.client.gen.TypeSpecGenerator;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.utility.SpecUtility;

public abstract class AbstractTypeSpecTest
extends AbstractSpecGenTest {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTypeSpecTest.class);
    protected Class<?> m_supertype;
    protected String m_id;
    protected String m_title;
    protected boolean m_listTypesWithoutDoc;
    private String m_introduction;

    public AbstractTypeSpecTest(String id, String title, String introduction, Class<? extends ITypeWithClassId> supertype, boolean listTypesWithoutDoc) {
        this.m_id = id;
        this.m_title = title;
        this.m_introduction = introduction;
        this.m_supertype = supertype;
        this.m_listTypesWithoutDoc = listTypesWithoutDoc;
    }

    public AbstractTypeSpecTest(String id, String title, String introduction, Class<? extends ITypeWithClassId> supertype) {
        this(id, title, introduction, supertype, false);
    }

    @Override
    public void generateSpec() throws ProcessingException {
        IDocSection doc = this.generate(this.getAllClasses());
        this.writeMediawikiFile(doc, this.m_id, new String[0]);
    }

    protected Set<Class<?>> getAllClasses() throws ProcessingException {
        return SpecUtility.getAllClasses(new BundleInspector.IClassFilter(){

            public boolean accept(Class c) {
                return AbstractTypeSpecTest.this.acceptClass(c);
            }
        });
    }

    protected boolean acceptClass(Class c) {
        return FilterUtility.isAccepted(c, this.getEntityListConfig().getFilters()) && SpecUtility.isDocType(c, this.m_supertype, this.m_listTypesWithoutDoc);
    }

    protected IDocSection generate(Collection<Class<?>> fieldTypes) {
        TypeSpecGenerator g = new TypeSpecGenerator(this.getEntityListConfig(), this.m_id, this.m_title, this.m_introduction);
        return g.getDocSection(fieldTypes);
    }

    protected IDocEntityTableConfig<Class<?>> getEntityListConfig() {
        return this.getConfiguration().getGenericTypesTableConfig();
    }
}

