/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.mediawiki;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.spec.client.out.IDocTable;

public class MediawikiTableWriter {
    private final Writer m_writer;
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final String TABLE_START = "{|";
    private static final String TABLE_END = "|}";
    private static final String TABLE_NEW_ROW = "|-" + NEWLINE;
    private static final String TABLE_COLUMN_SEPARATOR = "| ";
    private static final String EMPTY_CELL_TEXT = "&nbsp;";
    private static final char HEADING_CHAR = '=';
    private static final String DEFAULT_TABLE_BORDER = "border=\"1\" ";
    private final String m_table_options;

    public MediawikiTableWriter(Writer writer) {
        this(writer, DEFAULT_TABLE_BORDER);
    }

    public MediawikiTableWriter(Writer writer, String tableOptions) {
        this.m_writer = writer;
        this.m_table_options = tableOptions;
    }

    public void appendTable(IDocTable table) throws IOException {
        this.m_writer.append(TABLE_START);
        this.m_writer.append(StringUtility.nvl((Object)this.m_table_options, (String)""));
        this.m_writer.append(NEWLINE);
        this.appendTableHeaders(table.getHeaderTexts());
        this.appendDataRows(table.getCellTexts());
        this.m_writer.append(TABLE_END);
        this.m_writer.append(NEWLINE);
        this.m_writer.flush();
    }

    public void appendTableTransposed(IDocTable table) throws IOException {
        this.m_writer.append(TABLE_START);
        this.m_writer.append(StringUtility.nvl((Object)this.m_table_options, (String)""));
        this.m_writer.append(NEWLINE);
        String[] headerTexts = table.getHeaderTexts();
        String[][] cellTexts = table.getCellTexts();
        int i = 0;
        while (i < headerTexts.length) {
            int rowLength = cellTexts.length + 1;
            this.m_writer.append(TABLE_NEW_ROW);
            int j = 0;
            while (j < rowLength) {
                String text = j == 0 ? this.getHeaderCellText(headerTexts[i]) : this.getCellText(cellTexts[j - 1][i]);
                this.m_writer.append(text);
                this.m_writer.append(NEWLINE);
                ++j;
            }
            ++i;
        }
        this.m_writer.append(TABLE_END);
        this.m_writer.append(NEWLINE);
        this.m_writer.flush();
    }

    private void appendDataRows(String[][] cellTexts) throws IOException {
        String[][] stringArray = cellTexts;
        int n = cellTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            this.m_writer.append(TABLE_NEW_ROW);
            String[] stringArray2 = row;
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                String cell = stringArray2[n4];
                this.m_writer.append(TABLE_COLUMN_SEPARATOR);
                String cellText = this.getEscapedText(cell);
                this.m_writer.append(cellText);
                this.m_writer.append(System.getProperty("line.separator"));
                ++n4;
            }
            ++n2;
        }
    }

    private String getHeaderCellText(String text) {
        return "!" + this.getEscapedText(text);
    }

    private String getCellText(String text) {
        return TABLE_COLUMN_SEPARATOR + this.getEscapedText(text);
    }

    private String getEscapedText(String text) {
        return StringUtility.isNullOrEmpty((CharSequence)text) ? EMPTY_CELL_TEXT : text;
    }

    private void appendTableHeaders(String[] headerTexts) throws IOException {
        String[] stringArray = headerTexts;
        int n = headerTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String text = this.getHeaderCellText(header);
            this.m_writer.append(text);
            this.m_writer.append(NEWLINE);
            ++n2;
        }
    }

    public void appendHeading(String name, int level) throws IOException {
        String prefix = StringUtility.repeat((CharSequence)String.valueOf('='), (int)level);
        this.m_writer.append(prefix);
        this.m_writer.append(" ");
        this.m_writer.append(name);
        this.m_writer.append(" ");
        this.m_writer.append(prefix);
        this.m_writer.append(NEWLINE);
    }

    public void appendText(String text) throws IOException {
        this.m_writer.append(text);
        this.m_writer.append(NEWLINE);
    }
}

