/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTableForm;
import org.eclipse.scout.rt.client.ui.form.outline.DefaultOutlineTreeForm;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.testing.commons.ScoutAssert;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.testing.client.IGuiMock;
import org.eclipse.scout.testing.client.IGuiMockService;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestWithGuiScript {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTestWithGuiScript.class);
    private boolean m_testActive;
    private PrintStream m_originalSystemErrStream = null;
    private ByteArrayOutputStream m_monitoringSystemErrStream = null;
    protected IClientSession m_clientSession;

    protected abstract Class<? extends IClientSession> getSessionClass();

    protected void runGui(IGuiMock gui) throws Throwable {
    }

    protected void runModel() throws Throwable {
    }

    protected void disposeModel() throws Throwable {
    }

    protected void resetSession() throws Throwable {
        IDesktop desktop = this.m_clientSession.getDesktop();
        desktop.setAvailableOutlines(null);
        desktop.setOutline(null);
        for (IMessageBox m : desktop.getMessageBoxStack()) {
            try {
                m.getUIFacade().setResultFromUI(2);
            }
            catch (Throwable t) {
                LOG.warn("closing messagebox " + m.getClass(), t);
            }
        }
        for (IForm f : desktop.getDialogStack()) {
            try {
                f.doClose();
            }
            catch (Throwable t) {
                LOG.warn("closing dialog " + f.getClass(), t);
            }
        }
        for (IForm f : desktop.getViewStack()) {
            if (f instanceof DefaultOutlineTreeForm || f instanceof DefaultOutlineTableForm) continue;
            try {
                f.doClose();
            }
            catch (Throwable t) {
                LOG.warn("closing view " + f.getClass(), t);
            }
        }
    }

    @Test(timeout=0L)
    public void test() throws Throwable {
        this.doTest();
    }

    public final void doTest() throws Throwable {
        IGuiMockService guiMockService = (IGuiMockService)SERVICES.getService(IGuiMockService.class);
        if (guiMockService == null) {
            return;
        }
        this.m_clientSession = ((IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class)).newClientSession(this.getSessionClass(), guiMockService.initUserAgent());
        final IGuiMock gui = guiMockService.createMock(this.m_clientSession);
        gui.beforeTest();
        try {
            if (this.failWhenSystemErrIsNotEmpty()) {
                this.startMonitoringSystemErr();
            }
            ClientSyncJob runModelJob = new ClientSyncJob("Run", this.m_clientSession){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                    AbstractTestWithGuiScript.this.resetSession();
                    AbstractTestWithGuiScript.this.runModel();
                }
            };
            runModelJob.setUser(false);
            runModelJob.setSystem(true);
            ClientSyncJob disposeModelJob = new ClientSyncJob("Dispose", this.m_clientSession){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                    try {
                        AbstractTestWithGuiScript.this.disposeModel();
                    }
                    finally {
                        AbstractTestWithGuiScript.this.resetSession();
                    }
                }
            };
            disposeModelJob.setUser(false);
            disposeModelJob.setSystem(true);
            JobEx guiScriptJob = new JobEx("Gui Script"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        gui.waitForIdle();
                        AbstractTestWithGuiScript.this.runGui(gui);
                        return Status.OK_STATUS;
                    }
                    catch (Throwable t) {
                        return new Status(2, AbstractTestWithGuiScript.this.getClass().getName(), t.getMessage(), t);
                    }
                }
            };
            guiScriptJob.setUser(false);
            guiScriptJob.setSystem(true);
            try {
                this.m_testActive = true;
                runModelJob.schedule();
                while (!runModelJob.isWaitFor() && runModelJob.getState() != 0) {
                    runModelJob.join(100L);
                }
                guiScriptJob.schedule();
                guiScriptJob.join();
            }
            finally {
                this.m_testActive = false;
                disposeModelJob.schedule();
                disposeModelJob.join();
            }
            runModelJob.join();
            ScoutAssert.jobSuccessfullyCompleted((JobEx)runModelJob);
            ScoutAssert.jobSuccessfullyCompleted((JobEx)guiScriptJob);
            ScoutAssert.jobSuccessfullyCompleted((JobEx)disposeModelJob);
        }
        finally {
            gui.afterTest();
            if (this.failWhenSystemErrIsNotEmpty()) {
                String errText = this.stopMonitoringSystemErr();
                Assert.assertTrue((String)("System.err is not empty!: " + errText), (boolean)StringUtility.isNullOrEmpty((CharSequence)errText));
            }
        }
    }

    protected void startMonitoringSystemErr() {
        this.m_originalSystemErrStream = System.err;
        this.m_monitoringSystemErrStream = new ByteArrayOutputStream();
        System.setErr(new PrintStream(this.m_monitoringSystemErrStream, true));
    }

    protected String stopMonitoringSystemErr() {
        System.setErr(this.m_originalSystemErrStream);
        String errText = new String(this.m_monitoringSystemErrStream.toByteArray());
        this.m_monitoringSystemErrStream = null;
        return errText;
    }

    public boolean isTestActive() {
        return this.m_testActive;
    }

    protected boolean failWhenSystemErrIsNotEmpty() {
        return false;
    }
}

