/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStrokeNormalizer;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SwtMenuUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtMenuUtility.class);

    private SwtMenuUtility() {
    }

    public static MenuItem createSwtMenuItem(Menu parentMenu, IMenu scoutMenu, IActionFilter filter, ISwtEnvironment environment) {
        MenuItem swtMenuItem = null;
        if (scoutMenu.isSeparator()) {
            swtMenuItem = new MenuItem(parentMenu, 2);
        } else if (scoutMenu.hasChildActions()) {
            swtMenuItem = new MenuItem(parentMenu, 64);
            SwtMenuUtility.createChildMenu(swtMenuItem, scoutMenu.getChildActions(), filter, environment);
        } else {
            swtMenuItem = scoutMenu.isToggleAction() ? new MenuItem(parentMenu, 32) : new MenuItem(parentMenu, 8);
        }
        return swtMenuItem;
    }

    public static Menu createChildMenu(MenuItem swtMenuItem, List<IMenu> childActions, IActionFilter filter, ISwtEnvironment environment) {
        Menu menu = new Menu(swtMenuItem);
        SwtMenuUtility.fillMenu(menu, childActions, filter, environment);
        swtMenuItem.setMenu(menu);
        return menu;
    }

    public static void fillMenu(Menu menu, List<IMenu> childActions, IActionFilter filter, ISwtEnvironment environment) {
        SwtMenuUtility.fillMenu(menu, childActions, filter, environment, false);
    }

    public static void fillMenu(Menu menu, List<IMenu> childActions, IActionFilter filter, ISwtEnvironment environment, boolean separatorFirstIfHasMenus) {
        List visibleNormalizedActions = ActionUtility.normalizedActions(childActions, (IActionFilter)filter);
        if (separatorFirstIfHasMenus && visibleNormalizedActions.size() > 0) {
            new MenuItem(menu, 2);
        }
        for (IMenu childMenu : visibleNormalizedActions) {
            environment.createMenuItem(menu, childMenu, filter);
        }
    }

    public static String formatKeystroke(String keyStroke) {
        KeyStrokeNormalizer scoutKeystroke = new KeyStrokeNormalizer(keyStroke);
        scoutKeystroke.normalize();
        int naturalKey = 0;
        if (StringUtility.hasText((CharSequence)scoutKeystroke.getKey())) {
            if (scoutKeystroke.getKey().length() == 1) {
                naturalKey = scoutKeystroke.getKey().charAt(0);
            } else if (SwtUtility.getScoutSwtKeyMap().containsKey(scoutKeystroke.getKey().toLowerCase())) {
                naturalKey = SwtUtility.getScoutSwtKeyMap().get(scoutKeystroke.getKey().toLowerCase());
            } else {
                LOG.error("Was not able to create shortcut label for " + keyStroke);
            }
        }
        if (naturalKey != 0) {
            KeyStroke ks = KeyStroke.getInstance((int)((scoutKeystroke.hasShift() ? 131072 : 0) | (scoutKeystroke.hasCtrl() ? 262144 : 0) | (scoutKeystroke.hasAlt() ? 65536 : 0)), (int)naturalKey);
            return ks.format();
        }
        return "";
    }
}

