/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DateBrowserBar
extends Composite {
    private SwtCalendar m_calendar;
    private Button m_fastbackward;
    private Button m_backward;
    private Label m_label;
    private Button m_forward;
    private Button m_fastforward;

    public DateBrowserBar(SwtCalendar parent, int style) {
        super((Composite)parent, style);
        this.m_calendar = parent;
        this.createControls();
        this.hookListeners();
    }

    protected void createControls() {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 2;
        this.setLayoutData(gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 5;
        this.setLayout((Layout)layout);
        this.m_fastbackward = new Button((Composite)this, 0x800000);
        this.m_fastbackward.setText("\u00ab");
        this.m_fastbackward.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.m_fastbackward.setLayoutData((Object)gd);
        this.m_backward = new Button((Composite)this, 0x800000);
        this.m_backward.setText("\u2039");
        this.m_backward.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.m_backward.setLayoutData((Object)gd);
        this.m_label = new Label((Composite)this, 0x1000000);
        this.m_label.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 2;
        gd.grabExcessHorizontalSpace = true;
        this.m_label.setLayoutData((Object)gd);
        this.m_forward = new Button((Composite)this, 0x800000);
        this.m_forward.setText("\u203a");
        this.m_forward.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.m_forward.setLayoutData((Object)gd);
        this.m_fastforward = new Button((Composite)this, 0x800000);
        this.m_fastforward.setText("\u00bb");
        this.m_fastforward.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 3;
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.m_fastforward.setLayoutData((Object)gd);
        this.setBackground(SwtColors.getInstance().getWhite());
    }

    public void setHeaderText(String header) {
        this.m_label.setText(header);
    }

    protected void hookListeners() {
        this.m_fastbackward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateBrowserBar.this.m_calendar.fastBackward();
            }
        });
        this.m_backward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateBrowserBar.this.m_calendar.backward();
            }
        });
        this.m_forward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateBrowserBar.this.m_calendar.forward();
            }
        });
        this.m_fastforward.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateBrowserBar.this.m_calendar.fastForward();
            }
        });
    }

    public void dispose() {
        if (this.m_fastbackward != null && !this.m_fastbackward.isDisposed()) {
            this.m_fastbackward.dispose();
        }
        if (this.m_backward != null && !this.m_backward.isDisposed()) {
            this.m_backward.dispose();
        }
        if (this.m_label != null && !this.m_label.isDisposed()) {
            this.m_label.dispose();
        }
        if (this.m_forward != null && !this.m_forward.isDisposed()) {
            this.m_forward.dispose();
        }
        if (this.m_fastforward != null && !this.m_fastforward.isDisposed()) {
            this.m_fastforward.dispose();
        }
        super.dispose();
    }
}

