/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.AbstractDateSelectionListener;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateEquality;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateSelectionEvent;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.TimeCell;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TimeChooserContent
extends Composite {
    private List<AbstractDateSelectionListener> m_eventListenerList = new ArrayList<AbstractDateSelectionListener>();
    private Composite m_rootPane;
    private List<TimeCell> m_timeCells = new ArrayList<TimeCell>();
    private Date m_date = null;
    private AbstractDateSelectionListener m_timeChangedListener = new P_TimeChangedListener();
    private TimeCell m_selectedCell;
    private final ISwtEnvironment m_environment;

    public TimeChooserContent(Composite parent, Date date, ISwtEnvironment environment) {
        super(parent, 0);
        this.m_date = date;
        this.m_environment = environment;
        this.createDialogContent(this);
        this.setLayout((Layout)new FillLayout());
    }

    public void createDialogContent(Composite parent) {
        this.m_rootPane = new Composite(parent, 0);
        Composite timeCellBag = this.createCalendarCells(this.m_rootPane);
        FormLayout rootLayout = new FormLayout();
        this.m_rootPane.setLayout((Layout)rootLayout);
        FormData cellBagData = new FormData(-1, -1);
        cellBagData.right = new FormAttachment(100, 0);
        cellBagData.left = new FormAttachment(0, 0);
        cellBagData.top = new FormAttachment(0, 0);
        timeCellBag.setLayoutData((Object)cellBagData);
        this.setDate(this.m_date);
    }

    private Composite createCalendarCells(Composite parent) {
        Composite timeCellBag = new Composite(parent, 0);
        GridLayout timeCellBagLayout = new GridLayout(4, false);
        timeCellBagLayout.horizontalSpacing = 1;
        timeCellBagLayout.verticalSpacing = 1;
        timeCellBagLayout.marginHeight = 0;
        timeCellBagLayout.marginWidth = 0;
        timeCellBag.setLayout((Layout)timeCellBagLayout);
        int i = 0;
        while (i < 96) {
            TimeCell cell = new TimeCell(timeCellBag, this.m_timeChangedListener, this.getEnvironment());
            this.m_timeCells.add(cell);
            ++i;
        }
        return timeCellBag;
    }

    private void updateStates() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.m_date);
        c.set(11, 0);
        c.set(12, 0);
        for (TimeCell cell : this.m_timeCells) {
            DateEquality dateEquality = this.compareDates(c.getTime());
            cell.setRepresentedState(c, dateEquality);
            if (dateEquality.equals(DateEquality.QUARTER_EQUAL)) {
                this.m_selectedCell = cell;
            }
            c.add(12, 15);
        }
    }

    public TimeCell getSelectedCell() {
        return this.m_selectedCell;
    }

    private DateEquality compareDates(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(this.m_date);
        int selHour = c.get(11);
        int selMin = this.round(c.get(12));
        c.setTime(d);
        int cellHour = c.get(11);
        int cellMin = c.get(12);
        if (selHour == cellHour) {
            if (selMin == cellMin) {
                return DateEquality.QUARTER_EQUAL;
            }
            return DateEquality.HOUR_EQUAL;
        }
        return DateEquality.NOT_EQUAL;
    }

    private int round(int i) {
        int diff = i % 15;
        return i - diff;
    }

    public void setDate(Date d) {
        this.m_date = d == null ? new Date() : d;
        this.updateStates();
    }

    public void setTime(float f) {
        Calendar c = Calendar.getInstance();
        int minutes = (int)(f * 24.0f * 60.0f);
        int h = minutes / 60;
        int m = minutes % 60;
        c.set(11, h);
        c.set(12, m);
        this.m_date = c.getTime();
        this.updateStates();
    }

    public void addTimeChangedListener(AbstractDateSelectionListener listener) {
        this.m_eventListenerList.add(listener);
    }

    public void removeTimeChangedListener(AbstractDateSelectionListener listener) {
        this.m_eventListenerList.remove(listener);
    }

    private void fireTimeSelected(DateSelectionEvent e) {
        for (AbstractDateSelectionListener listener : this.m_eventListenerList) {
            listener.dateChanged(e);
        }
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    private class P_TimeChangedListener
    extends AbstractDateSelectionListener {
        private P_TimeChangedListener() {
        }

        @Override
        public void dateChanged(DateSelectionEvent e) {
            TimeChooserContent.this.setDate((Date)e.getData());
            TimeChooserContent.this.fireTimeSelected(e);
        }
    }
}

