/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility.v45.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.target.ExternalFileTargetHandle;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.eclipse.scout.sdk.compatibility.P2Utility;
import org.eclipse.scout.sdk.compatibility.internal.FeatureDefinition;
import org.eclipse.scout.sdk.compatibility.internal.ScoutCompatibilityActivator;
import org.eclipse.scout.sdk.compatibility.internal.service.ITargetPlatformCompatService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetPlatformCompatService
implements ITargetPlatformCompatService {
    public IStatus resolveTargetPlatform(IFile targetFile, boolean loadPlatform, IProgressMonitor monitor) throws CoreException {
        ITargetPlatformService targetService = (ITargetPlatformService)ScoutCompatibilityActivator.getDefault().acquireService(ITargetPlatformService.class);
        ITargetHandle handle = targetService.getTarget(targetFile);
        ITargetDefinition def = handle.getTargetDefinition();
        return this.resolveTarget(def, loadPlatform, monitor);
    }

    public URI getCurrentTargetFile() throws CoreException {
        ITargetPlatformService targetService = (ITargetPlatformService)ScoutCompatibilityActivator.getDefault().acquireService(ITargetPlatformService.class);
        ITargetHandle workspaceTargetHandle = targetService.getWorkspaceTargetHandle();
        if (workspaceTargetHandle instanceof WorkspaceFileTargetHandle && workspaceTargetHandle.exists()) {
            IFile f = ((WorkspaceFileTargetHandle)workspaceTargetHandle).getTargetFile();
            if (f != null && f.exists()) {
                return f.getLocationURI();
            }
        } else if (workspaceTargetHandle instanceof ExternalFileTargetHandle && workspaceTargetHandle.exists()) {
            return ((ExternalFileTargetHandle)workspaceTargetHandle).getLocation();
        }
        return null;
    }

    public IStatus resolveTargetPlatform(Set<File> absolutePaths, String targetName, boolean loadPlatform, IProgressMonitor monitor) throws CoreException {
        ITargetPlatformService tpService = (ITargetPlatformService)ScoutCompatibilityActivator.getDefault().acquireService(ITargetPlatformService.class);
        ITargetDefinition targetDef = tpService.newTarget();
        targetDef.setName(targetName);
        ArrayList<ITargetLocation> bundleContainers = new ArrayList<ITargetLocation>();
        for (File dir : absolutePaths) {
            bundleContainers.add(tpService.newDirectoryLocation(dir.getAbsolutePath()));
        }
        targetDef.setTargetLocations(bundleContainers.toArray(new ITargetLocation[bundleContainers.size()]));
        targetDef.setArch(Platform.getOSArch());
        targetDef.setOS(Platform.getOS());
        targetDef.setWS(Platform.getWS());
        targetDef.setNL(Platform.getNL());
        tpService.saveTargetDefinition(targetDef);
        return this.resolveTarget(targetDef, loadPlatform, monitor);
    }

    private IStatus resolveTarget(ITargetDefinition def, boolean loadPlatform, IProgressMonitor monitor) {
        IStatus result = def.resolve(monitor);
        if (loadPlatform && result.isOK()) {
            LoadTargetDefinitionJob loadJob = new LoadTargetDefinitionJob(def);
            result = loadJob.run(monitor);
        }
        return result;
    }

    public void removeInstallableUnitsFromTarget(IFile targetFile, final String[] unitIds) throws CoreException {
        this.modifyTargetFile(targetFile, new ITargetFileModification(){

            @Override
            public void contribute(List<ITargetLocation> liveList, Map<IUBundleContainer, Set<FeatureDefinition>> features, ITargetPlatformService svc) throws CoreException {
                for (Set<FeatureDefinition> featureOfContainer : features.values()) {
                    Iterator<FeatureDefinition> it = featureOfContainer.iterator();
                    while (it.hasNext()) {
                        FeatureDefinition def = it.next();
                        String[] stringArray = unitIds;
                        int n = unitIds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String featureToRemove = stringArray[n2];
                            if (featureToRemove != null && featureToRemove.equals(def.id)) {
                                it.remove();
                            }
                            ++n2;
                        }
                    }
                }
            }
        });
    }

    public void addDirectoryLocationToTarget(IFile targetFile, final String[] dirs) throws CoreException {
        this.modifyTargetFile(targetFile, new ITargetFileModification(){

            @Override
            public void contribute(List<ITargetLocation> liveList, Map<IUBundleContainer, Set<FeatureDefinition>> features, ITargetPlatformService svc) {
                String[] stringArray = dirs;
                int n = dirs.length;
                int n2 = 0;
                while (n2 < n) {
                    String cleanDir;
                    String dir = stringArray[n2];
                    if (dir != null && (cleanDir = dir.trim()).length() > 0) {
                        liveList.add(svc.newDirectoryLocation(cleanDir));
                    }
                    ++n2;
                }
            }
        });
    }

    private static IUBundleContainer getContainer(String uri, Set<IUBundleContainer> containers) throws URISyntaxException {
        URI searchUri = URIUtil.fromString((String)uri);
        for (IUBundleContainer container : containers) {
            URI[] uRIArray = container.getRepositories();
            int n = uRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI repo = uRIArray[n2];
                if (URIUtil.sameURI((URI)searchUri, (URI)repo)) {
                    return container;
                }
                ++n2;
            }
        }
        return null;
    }

    public void addInstallableUnitToTarget(IFile targetFile, final String unitId, final String version, final String repository, final IProgressMonitor monitor) throws CoreException {
        this.modifyTargetFile(targetFile, new ITargetFileModification(){

            @Override
            public void contribute(List<ITargetLocation> liveList, Map<IUBundleContainer, Set<FeatureDefinition>> features, ITargetPlatformService svc) throws CoreException {
                try {
                    String ver = version;
                    if (ver == null || ver.trim().length() < 1) {
                        ver = P2Utility.getLatestVersion((String)unitId, (URI)URIUtil.fromString((String)repository), (IProgressMonitor)monitor);
                    }
                    IUBundleContainer container = TargetPlatformCompatService.getContainer(repository, features.keySet());
                    FeatureDefinition fd = new FeatureDefinition();
                    fd.id = unitId;
                    fd.version = ver;
                    if (container == null) {
                        URI uri = URIUtil.fromString((String)repository);
                        IUBundleContainer newIULocation = (IUBundleContainer)svc.newIULocation(new String[]{unitId}, new String[]{ver}, new URI[]{uri}, 0);
                        HashSet<FeatureDefinition> set = new HashSet<FeatureDefinition>(1);
                        set.add(fd);
                        features.put(newIULocation, set);
                    } else {
                        features.get(container).add(fd);
                    }
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.compatibility", "Unable to parse url '" + repository + "'.", (Throwable)e));
                }
            }
        });
    }

    private List<NameVersionDescriptor> getFeatures(IUBundleContainer iubc) throws CoreException {
        String INSTALLABLE_UNIT = "unit";
        String ATTR_ID = "id";
        String ATTR_VERSION = "version";
        try {
            String xml = iubc.serialize();
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            NodeList childNodes = document.getDocumentElement().getChildNodes();
            ArrayList<NameVersionDescriptor> result = new ArrayList<NameVersionDescriptor>(childNodes.getLength());
            int i = 0;
            while (i < childNodes.getLength()) {
                Element e;
                Node n = childNodes.item(i);
                if (n.getNodeType() == 1 && "unit".equals(n.getNodeName()) && (e = (Element)n).hasAttribute("id")) {
                    String id = e.getAttribute("id");
                    String version = e.getAttribute("version");
                    result.add(new NameVersionDescriptor(id, version));
                }
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.compatibility", "Unable to parse installable units.", (Throwable)e));
        }
    }

    private Set<FeatureDefinition> getValueOf(Map<IUBundleContainer, Set<FeatureDefinition>> map, IUBundleContainer objectToFind) {
        for (Map.Entry<IUBundleContainer, Set<FeatureDefinition>> entry : map.entrySet()) {
            if (objectToFind == null || !objectToFind.equals((Object)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private void modifyTargetFile(IFile targetFile, ITargetFileModification modification) throws CoreException {
        ITargetPlatformService svc = (ITargetPlatformService)ScoutCompatibilityActivator.getDefault().acquireService(ITargetPlatformService.class);
        ITargetHandle handle = svc.getTarget(targetFile);
        ITargetDefinition td = handle.getTargetDefinition();
        ITargetLocation[] features = td.getTargetLocations();
        int size = 1;
        if (features != null) {
            size += features.length;
        }
        HashMap<IUBundleContainer, Set<FeatureDefinition>> p2FeatureMap = new HashMap<IUBundleContainer, Set<FeatureDefinition>>(size);
        ArrayList<ITargetLocation> locations = new ArrayList<ITargetLocation>(size);
        if (features != null) {
            ITargetLocation[] iTargetLocationArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                if (container instanceof IUBundleContainer) {
                    IUBundleContainer iubc = (IUBundleContainer)container;
                    List<NameVersionDescriptor> fs = this.getFeatures(iubc);
                    Set<FeatureDefinition> featureSet = this.getValueOf(p2FeatureMap, iubc);
                    if (featureSet == null) {
                        featureSet = new HashSet<FeatureDefinition>(fs.size());
                        p2FeatureMap.put(iubc, featureSet);
                    }
                    for (NameVersionDescriptor f : fs) {
                        FeatureDefinition fd = new FeatureDefinition();
                        fd.id = f.getId();
                        fd.version = f.getVersion();
                        featureSet.add(fd);
                    }
                } else {
                    locations.add(container);
                }
                ++n2;
            }
        }
        modification.contribute(locations, p2FeatureMap, svc);
        for (Map.Entry entry : p2FeatureMap.entrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            String[] unitIds = new String[((Set)entry.getValue()).size()];
            String[] versions = new String[((Set)entry.getValue()).size()];
            int i = 0;
            for (FeatureDefinition f : (Set)entry.getValue()) {
                unitIds[i] = f.id;
                versions[i] = f.version == null ? "0.0.0" : f.version;
                ++i;
            }
            locations.add(svc.newIULocation(unitIds, versions, ((IUBundleContainer)entry.getKey()).getRepositories(), 12));
        }
        td.setTargetLocations(locations.toArray(new ITargetLocation[locations.size()]));
        svc.saveTargetDefinition(td);
    }

    private static interface ITargetFileModification {
        public void contribute(List<ITargetLocation> var1, Map<IUBundleContainer, Set<FeatureDefinition>> var2, ITargetPlatformService var3) throws CoreException;
    }
}

