/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.dnd;

import java.util.HashSet;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.dnd.FormFieldDndOperation;
import org.eclipse.scout.sdk.ui.dialog.RenameConfirmationDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.widgets.Shell;

public class FormFieldRelocateAction
extends Action {
    private boolean m_createCopy;
    private int m_location;
    private IType m_formField;
    private IType m_targetDeclaringType;
    private IType m_neighborField;
    private final Shell m_shell;

    public FormFieldRelocateAction(IType formFieldToMove, Shell shell) {
        super(Texts.get((String)"RelocateFormField"));
        this.m_formField = formFieldToMove;
        this.m_shell = shell;
    }

    public void run() {
        String fieldName = this.getFormField().getElementName();
        HashSet<String> usedNames = new HashSet<String>();
        try {
            IType[] iTypeArray = this.m_targetDeclaringType.getCompilationUnit().getAllTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                usedNames.add(t.getElementName());
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("During finding used names.", e);
        }
        if (this.getFormField().getCompilationUnit().equals(this.getTargetDeclaringType().getCompilationUnit()) && !this.isCreateCopy()) {
            usedNames.remove(this.getFormField().getElementName());
        }
        if (usedNames.contains(this.getFormField().getElementName())) {
            String message = Texts.get((String)"EnterFieldName", (String[])new String[]{this.isCreateCopy() ? Texts.get((String)"Copied") : Texts.get((String)"Moved")});
            RenameConfirmationDialog dialog = new RenameConfirmationDialog(this.m_shell, Texts.get((String)"FormFieldName"), message);
            dialog.setNotAllowedNames(usedNames);
            dialog.setTypeName(String.valueOf(Texts.get((String)"CopyOf")) + this.getFormField().getElementName());
            if (dialog.open() != 0) {
                return;
            }
            fieldName = dialog.getTypeName();
        }
        int mode = 2;
        if (this.isCreateCopy()) {
            mode = 1;
        }
        FormFieldDndOperation dndOp = new FormFieldDndOperation(this.getFormField(), this.getTargetDeclaringType(), fieldName, mode);
        dndOp.setPosition(this.getLocation());
        dndOp.setPositionType(this.getNeighborField());
        new OperationJob(new IOperation[]{dndOp}).schedule();
    }

    public void setFormField(IType formField) {
        this.m_formField = formField;
    }

    public IType getFormField() {
        return this.m_formField;
    }

    public void setTargetDeclaringType(IType targetDeclaringType) {
        this.m_targetDeclaringType = targetDeclaringType;
    }

    public IType getTargetDeclaringType() {
        return this.m_targetDeclaringType;
    }

    public void setNeighborField(IType neighborField) {
        this.m_neighborField = neighborField;
    }

    public IType getNeighborField() {
        return this.m_neighborField;
    }

    public void setCreateCopy(boolean createCopy) {
        this.m_createCopy = createCopy;
    }

    public boolean isCreateCopy() {
        return this.m_createCopy;
    }

    public void setLocation(int location) {
        this.m_location = location;
    }

    public int getLocation() {
        return this.m_location;
    }
}

