/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.config.parser.MenuTypesConfig;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MenuTypeDialog
extends TitleAreaDialog {
    private static final String TREE_NODE_TYPE = "type";
    private static final String TREE_NODE_ENUM = "enum";
    private final MenuTypesConfig m_config;
    private final IType m_menu;
    private CheckableTree m_tree;

    public MenuTypeDialog(Shell parentShell, MenuTypesConfig config, IType menu) {
        super(parentShell);
        this.m_config = config;
        this.m_menu = menu;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Texts.get((String)"ChooseMenuTypes"));
        this.setTitle(Texts.get((String)"ChooseMenuTypes"));
        this.setMessage(Texts.get((String)"ChooseTheTypesForMenu", (String[])new String[]{this.m_menu.getFullyQualifiedName('.')}));
        Composite rootArea = new Composite(parent, 2048);
        ITreeNode root = this.createTree();
        this.m_tree = new CheckableTree(rootArea, root);
        this.m_tree.setChecked(TreeUtility.findNodes(root, new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                if (MenuTypeDialog.TREE_NODE_ENUM.equals(node.getType())) {
                    IField f = (IField)node.getData();
                    IType enumType = (IType)node.getParent().getData();
                    return MenuTypeDialog.this.m_config.getValuesFor(enumType).contains(f.getElementName());
                }
                return false;
            }
        }));
        this.m_tree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                IType enumType = (IType)node.getParent().getData();
                IField f = (IField)node.getData();
                if (checkState) {
                    MenuTypeDialog.this.m_config.add(enumType, f.getElementName());
                } else {
                    MenuTypeDialog.this.m_config.remove(enumType, f.getElementName());
                }
            }
        });
        if (parent.getLayout() instanceof GridLayout) {
            rootArea.setLayoutData((Object)new GridData(1808));
        }
        rootArea.setLayout((Layout)new GridLayout(1, true));
        this.m_tree.setLayoutData(new GridData(1808));
        return rootArea;
    }

    private ITreeNode createTree() {
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        ICachedTypeHierarchy menuTypeHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenuType"));
        Set menuTypeEnums = menuTypeHierarchy.getAllTypes(TypeFilters.getEnumTypesFilter(), TypeComparators.getTypeNameComparator());
        int i = 0;
        for (IType m : menuTypeEnums) {
            ITreeNode typeNode = TreeUtility.createNode(rootNode, TREE_NODE_TYPE, m.getElementName(), UiUtility.getTypeImageDescriptor(m, false), i++, m, false, false);
            String enumSig = SignatureCache.createTypeSignature((String)m.getFullyQualifiedName());
            try {
                IField[] iFieldArray = m.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int flags;
                    IField f = iFieldArray[n2];
                    if (f.getTypeSignature().equals(enumSig) && Flags.isPublic((int)(flags = f.getFlags())) && Flags.isStatic((int)flags) && Flags.isFinal((int)flags) && !Flags.isDeprecated((int)flags)) {
                        TreeUtility.createNode(typeNode, TREE_NODE_ENUM, f.getElementName(), JavaElementImageProvider.getFieldImageDescriptor((boolean)false, (int)flags), i++, f, false, true);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Unable to get the available menu types", e);
            }
        }
        return rootNode;
    }

    public MenuTypesConfig openDialog() {
        if (this.open() == 0) {
            return this.m_config;
        }
        return null;
    }
}

