/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.AbstractInnerTypeWizard;
import org.eclipse.scout.sdk.ui.extensions.IFormFieldExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtension;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.osgi.framework.Bundle;

public final class FormFieldExtensionPoint {
    private static volatile List<? extends IFormFieldExtension> extensions;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    private FormFieldExtensionPoint() {
    }

    public static AbstractInnerTypeWizard createNewWizard(IType modelType) {
        ITypeHierarchy superTypeHierarchy = TypeUtility.getSupertypeHierarchy((IType)modelType);
        for (IFormFieldExtension ext : FormFieldExtensionPoint.getSortedExtensions(modelType, superTypeHierarchy, -1)) {
            if (ext.getNewWizardClazz() == null) continue;
            return ext.createNewWizard();
        }
        return null;
    }

    public static IFormFieldExtension findExtension(IType modelType, int maxDistance, ITypeHierarchy hierarchy) {
        List<IFormFieldExtension> sortedExtensions = FormFieldExtensionPoint.getSortedExtensions(modelType, hierarchy, maxDistance);
        if (sortedExtensions.size() > 0) {
            return (IFormFieldExtension)CollectionUtility.firstElement(sortedExtensions);
        }
        return null;
    }

    public static IPage createNodePage(IType modelType, ITypeHierarchy formFieldHierarchy) {
        for (IFormFieldExtension ext : FormFieldExtensionPoint.getSortedExtensions(modelType, formFieldHierarchy, -1)) {
            if (ext.getNodePage() == null) continue;
            return ext.createNodePage();
        }
        return null;
    }

    private static List<IFormFieldExtension> getSortedExtensions(IType modelType, ITypeHierarchy formFieldHierarchy, int maxDistance) {
        List<? extends IFormFieldExtension> allExtensions = FormFieldExtensionPoint.getExtensions();
        ArrayList<IFormFieldExtension> ret = new ArrayList<IFormFieldExtension>(allExtensions.size());
        for (IFormFieldExtension iFormFieldExtension : allExtensions) {
            if (maxDistance < 0) {
                HashSet allSubTypes = CollectionUtility.hashSet((Collection)formFieldHierarchy.getAllSubtypes(iFormFieldExtension.getModelType()));
                allSubTypes.add(iFormFieldExtension.getModelType());
                if (!allSubTypes.contains(modelType)) continue;
                ret.add(iFormFieldExtension);
                continue;
            }
            if (FormFieldExtensionPoint.distanceToIFormField(modelType, iFormFieldExtension.getModelType(), 0, formFieldHierarchy, maxDistance) > maxDistance) continue;
            ret.add(iFormFieldExtension);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<? extends IFormFieldExtension> getExtensions() {
        if (extensions == null) {
            Object object = LOCK;
            synchronized (object) {
                if (extensions == null) {
                    ArrayList result;
                    IExtension[] ex;
                    TreeMap<CompositeObject, FormFieldExtension> formFieldExtensions = new TreeMap<CompositeObject, FormFieldExtension>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "formField");
                    IExtension[] iExtensionArray = ex = xp.getExtensions();
                    int n = ex.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if ("true".equalsIgnoreCase(element.getAttribute("active"))) {
                                String name = element.getAttribute("name");
                                String modClassName = element.getAttribute("model");
                                if (!StringUtility.hasText((CharSequence)modClassName)) {
                                    ScoutSdkUi.logWarning("Could not find model in '" + extension.getUniqueIdentifier() + "'. Skiping this extension.");
                                } else {
                                    IType modelType = TypeUtility.getType((String)modClassName);
                                    if (!TypeUtility.exists((IJavaElement)modelType)) {
                                        ScoutSdkUi.logWarning("FormFieldExtension: the model type '" + modClassName + "' can not be found.");
                                    } else {
                                        ITypeHierarchy superTypeHierarchy = null;
                                        superTypeHierarchy = TypeUtility.getSupertypeHierarchy((IType)modelType);
                                        if (superTypeHierarchy == null) {
                                            ScoutSdkUi.logWarning("could not create super type hierarchy of '" + modelType.getFullyQualifiedName() + "'.");
                                        } else {
                                            Bundle contributerBundle;
                                            Class<AbstractInnerTypeWizard> wizardClazz;
                                            int distance = -FormFieldExtensionPoint.distanceToIFormField(modelType, TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField"), 0, superTypeHierarchy);
                                            CompositeObject key = new CompositeObject(new Object[]{distance, modelType.getFullyQualifiedName()});
                                            FormFieldExtension formFieldExtension = (FormFieldExtension)formFieldExtensions.get(key);
                                            if (formFieldExtension == null) {
                                                formFieldExtension = new FormFieldExtension(name, modelType);
                                                formFieldExtensions.put(key, formFieldExtension);
                                            }
                                            if ((wizardClazz = FormFieldExtensionPoint.getClassOfContribution(contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier()), element.getChildren("newWizard"), "wizard", AbstractInnerTypeWizard.class)) != null) {
                                                if (formFieldExtension.getNewWizardClazz() != null) {
                                                    ScoutSdkUi.logWarning("double defined new wizard class.");
                                                } else {
                                                    formFieldExtension.setNewWizardClazz(wizardClazz);
                                                }
                                            }
                                            String isInShortList = FormFieldExtensionPoint.getAttributeOfContribution(contributerBundle, element.getChildren("newWizard"), "inShortList");
                                            formFieldExtension.setInShortList("true".equalsIgnoreCase(isInShortList));
                                            Class<AbstractScoutTypePage> nodePageClazz = FormFieldExtensionPoint.getClassOfContribution(contributerBundle, element.getChildren("nodePage"), "nodePage", AbstractScoutTypePage.class);
                                            if (nodePageClazz != null) {
                                                if (formFieldExtension.getNodePage() != null) {
                                                    ScoutSdkUi.logWarning("double defined node page class.");
                                                } else {
                                                    formFieldExtension.setNodePage(nodePageClazz);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    extensions = result = CollectionUtility.arrayList(formFieldExtensions.values());
                }
            }
        }
        return extensions;
    }

    private static <T> Class<? extends T> getClassOfContribution(Bundle bundle, IConfigurationElement[] elements, String attribute, Class<T> t) {
        String clazzName;
        Class clazz = null;
        if (bundle != null && elements != null && elements.length == 1 && !StringUtility.isNullOrEmpty((CharSequence)(clazzName = elements[0].getAttribute(attribute)))) {
            try {
                clazz = bundle.loadClass(clazzName);
            }
            catch (Exception tt) {
                ScoutSdkUi.logWarning("could not load class of extension '" + elements[0].getName() + "'.", tt);
            }
        }
        return clazz;
    }

    private static String getAttributeOfContribution(Bundle bundle, IConfigurationElement[] elements, String attribute) {
        String value = null;
        if (bundle != null && elements != null && elements.length == 1) {
            value = elements[0].getAttribute(attribute);
        }
        return value;
    }

    private static int distanceToIFormField(IType visitee, IType superType, int dist, ITypeHierarchy superTypeHierarchy) {
        return FormFieldExtensionPoint.distanceToIFormField(visitee, superType, dist, superTypeHierarchy, Integer.MAX_VALUE);
    }

    private static int distanceToIFormField(IType visitee, IType superType, int dist, ITypeHierarchy superTypeHierarchy, int maxDistance) {
        if (visitee == null) {
            throw new IllegalArgumentException("try to determ the distance to IFormField of a instance not in subhierarchy of IFormField.");
        }
        if (dist > maxDistance) {
            return Integer.MAX_VALUE;
        }
        if (superType.getFullyQualifiedName().equals(visitee.getFullyQualifiedName())) {
            return dist;
        }
        int locDist = 100000;
        IType superclass = superTypeHierarchy.getSuperclass(visitee);
        if (superclass != null) {
            locDist = FormFieldExtensionPoint.distanceToIFormField(superclass, superType, dist + 1, superTypeHierarchy, maxDistance);
        }
        Set interfaces = superTypeHierarchy.getSuperInterfaces(visitee);
        for (IType i : interfaces) {
            locDist = Math.min(locDist, FormFieldExtensionPoint.distanceToIFormField(i, superType, dist + 1, superTypeHierarchy, maxDistance));
        }
        dist = locDist;
        return dist;
    }
}

