/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.quickassist.ClassIdDocumentationSupport;
import org.eclipse.scout.sdk.ui.extensions.quickassist.IClassIdDocumentationListener;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DocumentationPresenter
extends AbstractPresenter {
    private final IType m_type;
    private final ClassIdDocumentationSupport m_support;
    private Text m_textComponent;
    private ImageHyperlink m_editText;

    public DocumentationPresenter(PropertyViewFormToolkit toolkit, Composite parent, AbstractScoutTypePage page) {
        super(toolkit, parent);
        this.m_type = page.getType();
        this.m_support = new ClassIdDocumentationSupport(this.m_type, page.getScoutBundle().getDocsNlsProject());
        this.m_support.addModifiedListener(new IClassIdDocumentationListener(){

            @Override
            public void modified(int eventType, INlsEntry entry, IType owner) {
                DocumentationPresenter.this.refresh(entry);
            }
        });
        this.createContent(this.getContainer());
        this.refresh(this.m_support.getNlsEntry());
    }

    public IType getType() {
        return this.m_type;
    }

    protected void createContent(Composite container) {
        this.m_textComponent = this.getToolkit().createText(container, "", 19266);
        this.m_textComponent.setEnabled(false);
        this.m_editText = this.getToolkit().createImageHyperlink(container, 8);
        this.m_editText.setImage(ScoutSdkUi.getImage("usereditor.gif"));
        this.m_editText.setToolTipText(Texts.get((String)"EditDocumentation"));
        this.m_editText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DocumentationPresenter.this.handleLinkClicked();
            }
        });
        this.m_editText.setEnabled(!this.getType().isBinary());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.m_textComponent.setLayoutData((Object)data);
        data = new GridData(1040);
        data.verticalAlignment = 0x1000000;
        this.m_editText.setLayoutData((Object)data);
    }

    protected void handleLinkClicked() {
        this.m_support.editDocumentation(this.getContainer().getShell());
    }

    protected void refresh(INlsEntry entry) {
        if (entry != null) {
            String text = entry.getTranslation(entry.getProject().getDevelopmentLanguage(), true);
            if (StringUtility.hasText((CharSequence)text)) {
                this.m_textComponent.setText(text);
            } else {
                this.m_textComponent.setText("");
            }
        }
    }
}

