/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.presenter.multi;

import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiMethodPresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractMultiValuePresenter<T>
extends AbstractMultiMethodPresenter<T> {
    private Text m_textComponent;
    private final Pattern m_regexAllowedCharacters;

    public AbstractMultiValuePresenter(PropertyViewFormToolkit toolkit, Composite parent, String regexAllowedInput) {
        super(toolkit, parent);
        this.m_regexAllowedCharacters = Pattern.compile(regexAllowedInput);
    }

    @Override
    protected Control createContent(Composite container) {
        this.m_textComponent = this.getToolkit().createText(container, "", this.getTextAlignment());
        P_TextListener listener = new P_TextListener();
        this.m_textComponent.addListener(15, (Listener)listener);
        this.m_textComponent.addListener(16, (Listener)listener);
        this.m_textComponent.addListener(25, (Listener)listener);
        return this.m_textComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_textComponent.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_textComponent.getEnabled() && super.isEnabled();
        }
        return false;
    }

    protected abstract void storeMethods(Collection<MethodBean<T>> var1, T var2);

    protected int getTextAlignment() {
        return 16384;
    }

    public Text getTextComponent() {
        return this.m_textComponent;
    }

    private class P_TextListener
    implements Listener {
        private P_TextListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 25: {
                    String string = event.text;
                    if ("###".equals(string)) {
                        return;
                    }
                    if (string == null) break;
                    event.doit = AbstractMultiValuePresenter.this.m_regexAllowedCharacters.matcher(string).matches();
                    break;
                }
                case 16: {
                    String input = AbstractMultiValuePresenter.this.getTextComponent().getText();
                    if ("###".equals(input)) {
                        return;
                    }
                    try {
                        Object value = AbstractMultiValuePresenter.this.parseDisplayInput(input);
                        AbstractMultiValuePresenter.this.getTextComponent().setText(AbstractMultiValuePresenter.this.formatDisplayValue(value));
                        AbstractMultiValuePresenter.this.storeMethods(AbstractMultiValuePresenter.this.getMethodBeans(), value);
                    }
                    catch (CoreException e) {
                        ScoutSdkUi.logInfo("input is not well fomed: " + input, e);
                        AbstractMultiValuePresenter.this.getTextComponent().setForeground(AbstractMultiValuePresenter.this.getTextComponent().getDisplay().getSystemColor(3));
                    }
                    break;
                }
                case 15: {
                    AbstractMultiValuePresenter.this.getTextComponent().setForeground(null);
                    break;
                }
            }
        }
    }
}

