/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.jdt.finegrained;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.ast.AstUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.jdt.finegrained.AbstractFineGrainedAstMatcher;

class FineGrainedAstAnalyzer {
    private final IJavaElementDelta m_delta;
    private final ICompilationUnit m_icu;

    public FineGrainedAstAnalyzer(IJavaElementDelta delta) {
        this.m_delta = delta;
        this.m_icu = (ICompilationUnit)delta.getElement();
    }

    public Set<IJavaElement> calculateDeltas(String oldContent, String newContent) {
        CompilationUnit newAst;
        if (CompareUtility.equals((Object)oldContent, (Object)newContent)) {
            return CollectionUtility.hashSet((Object[])new IJavaElement[0]);
        }
        CompilationUnit oldAst = null;
        if (oldAst == null) {
            ASTParser parser = AstUtility.newParser();
            parser.setCompilerOptions((Map)JavaCore.getOptions());
            parser.setKind(8);
            parser.setSource(oldContent.toCharArray());
            oldAst = (CompilationUnit)parser.createAST(null);
        }
        if ((newAst = this.m_delta.getCompilationUnitAST()) == null) {
            ASTParser parser = AstUtility.newParser();
            parser.setCompilerOptions((Map)JavaCore.getOptions());
            parser.setKind(8);
            parser.setSource(newContent.toCharArray());
            newAst = (CompilationUnit)parser.createAST(null);
        }
        return this.calculateDeltas(oldAst, newAst);
    }

    public Set<IJavaElement> calculateDeltas(CompilationUnit oldAst, CompilationUnit newAst) {
        final HashSet<IJavaElement> set = new HashSet<IJavaElement>();
        AbstractFineGrainedAstMatcher matcher = new AbstractFineGrainedAstMatcher(){

            @Override
            protected boolean processDelta(boolean match, ASTNode node, Object other) {
                if (!match) {
                    try {
                        IJavaElement e = FineGrainedAstAnalyzer.this.m_icu.getElementAt(node.getStartPosition());
                        if (e != null) {
                            set.add(e);
                        }
                    }
                    catch (JavaModelException e1) {
                        SdkUtilActivator.logError(e1);
                    }
                }
                return true;
            }
        };
        newAst.subtreeMatch((ASTMatcher)matcher, (Object)oldAst);
        return set;
    }
}

