/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.sequencebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.sequencebox.ISequenceBoxExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.sequencebox.SequenceBoxChains;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.InvalidSequenceStatus;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.internal.SequenceBoxGrid;
import org.eclipse.scout.rt.shared.ScoutTexts;

@ClassId(value="e71e8b93-1168-4f5e-8781-4774f01eee26")
public abstract class AbstractSequenceBox
extends AbstractCompositeField
implements ISequenceBox {
    private boolean m_autoCheckFromTo;
    private OptimisticLock m_labelCompositionLock;
    private SequenceBoxGrid m_grid;
    private String m_labelBase;
    private String m_labelSuffix;
    private boolean m_equalColumnWidths;

    public AbstractSequenceBox() {
        this(true);
    }

    public AbstractSequenceBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredAutoCheckFromTo() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    protected boolean getConfiguredEqualColumnWidths() {
        return false;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @ConfigOperation
    @Order(value=200.0)
    protected <T extends Comparable<T>> void execCheckFromTo(IValueField<T>[] valueFields, int changedIndex) throws ProcessingException {
        ArrayList<IValueField<T>> nonEmptyFields = new ArrayList<IValueField<T>>();
        HashSet beanTypes = new HashSet();
        int nonEmptyIndex = -1;
        int i = 0;
        while (i < valueFields.length) {
            if (valueFields[i].getValue() != null) {
                beanTypes.add(((Comparable)valueFields[i].getValue()).getClass());
                nonEmptyFields.add(valueFields[i]);
                if (i == changedIndex) {
                    nonEmptyIndex = nonEmptyFields.size() - 1;
                }
            }
            ++i;
        }
        if (nonEmptyFields.size() != 2 || beanTypes.size() != 1) {
            this.clearInvalidSequenceStatus(valueFields);
            return;
        }
        if (nonEmptyIndex >= 0) {
            IValueField left;
            IValueField v = (IValueField)nonEmptyFields.get(nonEmptyIndex);
            if (nonEmptyIndex - 1 >= 0 && CompareUtility.compareTo((Comparable)((Comparable)(left = (IValueField)nonEmptyFields.get(nonEmptyIndex - 1)).getValue()), (Comparable)((Comparable)v.getValue())) > 0) {
                InvalidSequenceStatus errorStatus = new InvalidSequenceStatus(ScoutTexts.get((String)"XMustBeGreaterThanOrEqualY", (String[])new String[]{v.getLabel(), left.getLabel()}));
                if (!v.isLabelSuppressed()) {
                    v.setErrorStatus((IProcessingStatus)errorStatus);
                } else {
                    this.setErrorStatus((IProcessingStatus)errorStatus);
                }
                return;
            }
            if (nonEmptyIndex + 1 < nonEmptyFields.size()) {
                IValueField right = (IValueField)nonEmptyFields.get(nonEmptyIndex + 1);
                if (CompareUtility.compareTo((Comparable)((Comparable)v.getValue()), (Comparable)((Comparable)right.getValue())) > 0) {
                    InvalidSequenceStatus errorStatus = new InvalidSequenceStatus(ScoutTexts.get((String)"XMustBeLessThanOrEqualY", (String[])new String[]{v.getLabel(), right.getLabel()}));
                    if (!v.isLabelSuppressed()) {
                        v.setErrorStatus((IProcessingStatus)errorStatus);
                    } else {
                        this.setErrorStatus((IProcessingStatus)errorStatus);
                    }
                    return;
                }
            }
        }
        this.clearInvalidSequenceStatus(valueFields);
    }

    private void clearInvalidSequenceStatus(IValueField[] valueFields) {
        IValueField[] iValueFieldArray = valueFields;
        int n = valueFields.length;
        int n2 = 0;
        while (n2 < n) {
            IValueField v = iValueFieldArray[n2];
            if (v.getErrorStatus() instanceof InvalidSequenceStatus) {
                v.clearErrorStatus();
            }
            ++n2;
        }
        if (this.getErrorStatus() instanceof InvalidSequenceStatus) {
            this.clearErrorStatus();
        }
    }

    @Override
    protected void initConfig() {
        this.m_labelCompositionLock = new OptimisticLock();
        this.m_grid = new SequenceBoxGrid(this);
        super.initConfig();
        this.setAutoCheckFromTo(this.getConfiguredAutoCheckFromTo());
        this.setEqualColumnWidths(this.getConfiguredEqualColumnWidths());
        this.propertySupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("labelVisible") || e.getPropertyName().equals("label") || e.getPropertyName().equals("visible")) {
                    AbstractSequenceBox.this.updateLabelComposition();
                }
            }
        });
        for (IFormField field : this.getFields()) {
            field.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("labelVisible") || e.getPropertyName().equals("label") || e.getPropertyName().equals("visible")) {
                        AbstractSequenceBox.this.updateLabelComposition();
                    }
                }
            });
        }
        this.updateLabelComposition();
        Class sharedType = null;
        ArrayList<IValueField> valueFieldList = new ArrayList<IValueField>();
        for (IFormField f : this.getFields()) {
            IValueField v;
            Class valueType;
            if (!(f instanceof IValueField) || !Comparable.class.isAssignableFrom(valueType = (v = (IValueField)f).getHolderType()) || sharedType != null && valueType != sharedType) continue;
            sharedType = valueType;
            valueFieldList.add(v);
        }
        if (valueFieldList.size() >= 2) {
            final IValueField[] valueFields = valueFieldList.toArray(new IValueField[valueFieldList.size()]);
            int i = 0;
            while (i < valueFields.length) {
                final int index = i++;
                valueFields[index].addPropertyChangeListener("value", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (AbstractSequenceBox.this.getForm() != null && AbstractSequenceBox.this.isAutoCheckFromTo()) {
                            AbstractSequenceBox.this.checkFromTo(valueFields, index);
                        }
                    }
                });
            }
        }
    }

    @Override
    public boolean isEqualColumnWidths() {
        return this.m_equalColumnWidths;
    }

    @Override
    public void setEqualColumnWidths(boolean b) {
        this.m_equalColumnWidths = b;
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_grid.validate();
        if (this.isInitialized() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    protected void handleFieldVisibilityChanged() {
        super.handleFieldVisibilityChanged();
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_grid.getGridColumnCount();
    }

    @Override
    public final int getGridRowCount() {
        return this.m_grid.getGridRowCount();
    }

    @Override
    public boolean isAutoCheckFromTo() {
        return this.m_autoCheckFromTo;
    }

    @Override
    public void setAutoCheckFromTo(boolean b) {
        this.m_autoCheckFromTo = b;
    }

    private void checkFromTo(IValueField[] valueFields, int changedIndex) {
        try {
            this.interceptCheckFromTo(valueFields, changedIndex);
        }
        catch (VetoException e) {
            valueFields[changedIndex].setErrorStatus(e.getStatus());
        }
        catch (ProcessingException e) {
            valueFields[changedIndex].setErrorStatus(e.getStatus());
        }
    }

    private void updateLabelComposition() {
        if (!this.isLabelVisible()) {
            return;
        }
        try {
            if (this.m_labelCompositionLock.acquire()) {
                this.m_labelSuffix = this.interceptCreateLabelSuffix();
                this.computeCompoundLabel();
            }
        }
        finally {
            this.m_labelCompositionLock.release();
        }
    }

    @ConfigOperation
    @Order(value=210.0)
    protected String execCreateLabelSuffix() {
        for (IFormField f : this.getFields()) {
            f.setLabelSuppressed(false);
        }
        for (IFormField formField : this.getFields()) {
            if (!this.interceptIsLabelSuffixCandidate(formField)) continue;
            formField.setLabelSuppressed(true);
            return formField.getLabel();
        }
        return null;
    }

    @ConfigOperation
    @Order(value=211.0)
    protected boolean execIsLabelSuffixCandidate(IFormField formField) {
        if (!formField.isVisible()) {
            return false;
        }
        if (!formField.isLabelVisible()) {
            return false;
        }
        if (formField.getLabelPosition() == 2) {
            return false;
        }
        if (formField.getLabelPosition() == 4) {
            return false;
        }
        if (formField instanceof IBooleanField) {
            return false;
        }
        return !(formField instanceof IButton);
    }

    @Override
    public void setLabel(String name) {
        this.m_labelBase = name;
        this.computeCompoundLabel();
    }

    private void computeCompoundLabel() {
        if (StringUtility.hasText((CharSequence)this.m_labelBase) && StringUtility.hasText((CharSequence)this.m_labelSuffix)) {
            super.setLabel(String.valueOf(this.m_labelBase) + " " + this.m_labelSuffix);
        } else {
            super.setLabel(String.valueOf(StringUtility.emptyIfNull((Object)this.m_labelBase)) + StringUtility.emptyIfNull((Object)this.m_labelSuffix));
        }
    }

    @Override
    public String getFullyQualifiedLabel(String separator) {
        String s;
        StringBuffer b = new StringBuffer();
        ICompositeField p = this.getParentField();
        if (p != null && (s = p.getFullyQualifiedLabel(separator)) != null) {
            b.append(s);
        }
        if ((s = this.m_labelBase) != null) {
            if (b.length() > 0) {
                b.append(separator);
            }
            b.append(s);
        }
        return b.toString();
    }

    protected final boolean interceptIsLabelSuffixCandidate(IFormField formField) {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SequenceBoxChains.SequenceBoxIsLabelSuffixCandidateChain chain = new SequenceBoxChains.SequenceBoxIsLabelSuffixCandidateChain(extensions);
        return chain.execIsLabelSuffixCandidate(formField);
    }

    protected final <T extends Comparable<T>> void interceptCheckFromTo(IValueField<T>[] valueFields, int changedIndex) throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SequenceBoxChains.SequenceBoxCheckFromToChain chain = new SequenceBoxChains.SequenceBoxCheckFromToChain(extensions);
        chain.execCheckFromTo(valueFields, changedIndex);
    }

    protected final String interceptCreateLabelSuffix() {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        SequenceBoxChains.SequenceBoxCreateLabelSuffixChain chain = new SequenceBoxChains.SequenceBoxCreateLabelSuffixChain(extensions);
        return chain.execCreateLabelSuffix();
    }

    @Override
    protected ISequenceBoxExtension<? extends AbstractSequenceBox> createLocalExtension() {
        return new LocalSequenceBoxExtension<AbstractSequenceBox>(this);
    }

    protected static class LocalSequenceBoxExtension<OWNER extends AbstractSequenceBox>
    extends AbstractCompositeField.LocalCompositeFieldExtension<OWNER>
    implements ISequenceBoxExtension<OWNER> {
        public LocalSequenceBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public boolean execIsLabelSuffixCandidate(SequenceBoxChains.SequenceBoxIsLabelSuffixCandidateChain chain, IFormField formField) {
            return ((AbstractSequenceBox)this.getOwner()).execIsLabelSuffixCandidate(formField);
        }

        @Override
        public <T extends Comparable<T>> void execCheckFromTo(SequenceBoxChains.SequenceBoxCheckFromToChain chain, IValueField<T>[] valueFields, int changedIndex) throws ProcessingException {
            ((AbstractSequenceBox)this.getOwner()).execCheckFromTo(valueFields, changedIndex);
        }

        @Override
        public String execCreateLabelSuffix(SequenceBoxChains.SequenceBoxCreateLabelSuffixChain chain) {
            return ((AbstractSequenceBox)this.getOwner()).execCreateLabelSuffix();
        }
    }
}

