/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.bookmark;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkVisitor;

public class BookmarkFolder
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long m_id;
    private String m_title;
    private String m_iconId;
    private List<BookmarkFolder> m_folders = new ArrayList<BookmarkFolder>();
    private List<Bookmark> m_bookmarks = new ArrayList<Bookmark>();
    private Bookmark m_startupBookmark;

    public long getId() {
        return this.m_id;
    }

    public void setId(long id) {
        this.m_id = id;
    }

    public String getIconId() {
        return this.m_iconId;
    }

    public void setIconId(String iconid) {
        this.m_iconId = iconid;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String s) {
        this.m_title = s;
    }

    public Bookmark getStartupBookmark() {
        return this.m_startupBookmark;
    }

    public void setStartupBookmark(Bookmark startupBookmark) {
        this.m_startupBookmark = startupBookmark;
    }

    public void addBookmarks(BookmarkFolder folder, boolean replaceDuplicates, boolean byReference) {
        if (folder == null) {
            return;
        }
        for (Bookmark b : folder.getBookmarks()) {
            Bookmark existingBm;
            if (!byReference) {
                b = (Bookmark)b.clone();
            }
            if (replaceDuplicates && (existingBm = this.getBookmark(b.getTitle())) != null) {
                this.getBookmarks().remove(existingBm);
            }
            this.getBookmarks().add(b);
        }
        for (BookmarkFolder subFolder : folder.getFolders()) {
            BookmarkFolder existingFolder = this.getFolder(subFolder.getTitle());
            if (existingFolder == null) {
                if (byReference) {
                    existingFolder = subFolder;
                    this.getFolders().add(existingFolder);
                    continue;
                }
                existingFolder = (BookmarkFolder)subFolder.clone();
                this.getFolders().add(existingFolder);
                continue;
            }
            existingFolder.addBookmarks(subFolder, replaceDuplicates, byReference);
        }
    }

    public List<BookmarkFolder> getFolders() {
        return this.m_folders;
    }

    public List<Bookmark> getBookmarks() {
        return this.m_bookmarks;
    }

    public Bookmark getBookmark(String title) {
        for (Bookmark b : this.getBookmarks()) {
            if (!CompareUtility.equals((Object)b.getTitle(), (Object)title)) continue;
            return b;
        }
        return null;
    }

    public BookmarkFolder getFolder(String title) {
        for (BookmarkFolder f : this.getFolders()) {
            if (!CompareUtility.equals((Object)f.getTitle(), (Object)title)) continue;
            return f;
        }
        return null;
    }

    public Object clone() {
        try {
            BookmarkFolder f = (BookmarkFolder)super.clone();
            f.m_folders = new ArrayList<BookmarkFolder>();
            for (BookmarkFolder bookmarkFolder : this.m_folders) {
                f.m_folders.add((BookmarkFolder)bookmarkFolder.clone());
            }
            f.m_bookmarks = new ArrayList<Bookmark>();
            for (Bookmark bookmark : this.m_bookmarks) {
                f.m_bookmarks.add((Bookmark)bookmark.clone());
            }
            return f;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public boolean visit(IBookmarkVisitor v) {
        ArrayList<BookmarkFolder> path = new ArrayList<BookmarkFolder>();
        return this.visitInternal(v, path);
    }

    boolean visitInternal(IBookmarkVisitor v, List<BookmarkFolder> path) {
        boolean result = true;
        try {
            path.add(this);
            result = v.visitFolder(path);
            if (!result) {
                boolean bl = result;
                return bl;
            }
            for (Bookmark b : new ArrayList<Bookmark>(this.getBookmarks())) {
                result = v.visitBookmark(path, b);
                if (result) continue;
                boolean bl = result;
                return bl;
            }
            for (BookmarkFolder f : new ArrayList<BookmarkFolder>(this.getFolders())) {
                result = f.visitInternal(v, path);
                if (result) continue;
                boolean bl = result;
                return bl;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            path.remove(this);
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof BookmarkFolder) {
            BookmarkFolder other = (BookmarkFolder)o;
            if (this.m_id == other.m_id && CompareUtility.equals((Object)this.m_title, (Object)other.m_title) && CompareUtility.equals((Object)this.m_iconId, (Object)other.m_iconId)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " title=" + this.getTitle() + ", id=" + this.getId() + "]";
    }
}

