/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.celleditor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.IFormFieldPopupListener;
import org.eclipse.scout.rt.ui.swt.window.popup.SwtScoutDropDownPopup;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SwtScoutFormFieldPopup
extends SwtScoutComposite<IFormField> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutFormFieldPopup.class);
    private SwtScoutDropDownPopup m_swtScoutPopup;
    private Composite m_owner;
    private int m_minWidth;
    private int m_prefWidth;
    private int m_minHeight;
    private int m_prefHeight;
    private int m_style;
    private final Set<IFormFieldPopupListener> m_listeners = Collections.synchronizedSet(new HashSet());

    public SwtScoutFormFieldPopup(Composite owner) {
        this.m_owner = owner;
        this.m_style = 8;
    }

    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        this.m_swtScoutPopup = new SwtScoutDropDownPopup(this.getEnvironment(), (Control)this.m_owner, true, this.m_style);
        this.m_swtScoutPopup.setPopupOnField(true);
        this.m_swtScoutPopup.setHeightHint(this.m_prefHeight);
        this.m_swtScoutPopup.setWidthHint(this.m_prefWidth);
        this.m_swtScoutPopup.getShell().setMinimumSize(this.m_minWidth, this.m_minHeight);
        final TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: {
                        e.doit = false;
                        SwtScoutFormFieldPopup.this.notifyListeners(5);
                        break;
                    }
                    case 8: {
                        e.doit = false;
                        SwtScoutFormFieldPopup.this.notifyListeners(9);
                        break;
                    }
                    case 2: {
                        e.doit = false;
                        SwtScoutFormFieldPopup.this.notifyListeners(2);
                        break;
                    }
                    case 4: {
                        e.doit = false;
                        SwtScoutFormFieldPopup.this.notifyListeners(1);
                    }
                }
            }
        };
        this.m_swtScoutPopup.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                SwtScoutFormFieldPopup.this.notifyListeners(1);
            }
        });
        this.m_owner.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (SwtScoutFormFieldPopup.this.m_owner.isDisposed()) {
                    return;
                }
                SwtScoutFormFieldPopup.this.m_owner.removePaintListener((PaintListener)this);
                IForm form = SwtScoutFormFieldPopup.this.createForm();
                if (form != null) {
                    SwtScoutFormFieldPopup.this.m_swtScoutPopup.showForm(form);
                    Control swtFormField = SwtScoutFormFieldPopup.findSwtFormField(SwtScoutFormFieldPopup.this.m_swtScoutPopup.getUiForm().getSwtField(), (IFormField)SwtScoutFormFieldPopup.this.getScoutObject());
                    if (swtFormField == null) {
                        LOG.warn("UI-FormField could not be found in UI-Form");
                    }
                    SwtScoutFormFieldPopup.this.setSwtField(swtFormField);
                    SwtScoutFormFieldPopup.this.installTraverseListener((Control)SwtScoutFormFieldPopup.this.m_swtScoutPopup.getShell(), traverseListener);
                } else {
                    LOG.error("Failed to create the Form for the form-field.");
                }
            }
        });
        this.setSwtContainer(this.m_owner);
    }

    public void setMinWidth(int minWidth) {
        this.m_minWidth = minWidth;
    }

    public void setPrefWidth(int prefWidth) {
        this.m_prefWidth = prefWidth;
    }

    public void setMinHeight(int minHeight) {
        this.m_minHeight = minHeight;
    }

    public void setPrefHeight(int prefHeight) {
        this.m_prefHeight = prefHeight;
    }

    public void closePopup() {
        this.m_swtScoutPopup.closePart();
    }

    public void addListener(IFormFieldPopupListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeListener(IFormFieldPopupListener listener) {
        this.m_listeners.remove(listener);
    }

    private void notifyListeners(int eventType) {
        for (IFormFieldPopupListener listener : this.m_listeners) {
            listener.handleEvent(eventType);
        }
    }

    private void installTraverseListener(Control control, TraverseListener listener) {
        control.addTraverseListener(listener);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.installTraverseListener(child, listener);
                ++n2;
            }
        }
    }

    private IForm createForm() {
        final Holder result = new Holder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    P_Form form = new P_Form((IFormField)SwtScoutFormFieldPopup.this.getScoutObject());
                    form.setAutoAddRemoveOnDesktop(false);
                    form.startForm();
                    result.setValue((Object)form);
                }
                catch (Exception e) {
                    LOG.error("Failed to create and start popup form.", (Throwable)e);
                }
            }
        };
        try {
            this.getEnvironment().invokeScoutLater(runnable, 2345L).join(2345L);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the popup form to be started.", (Throwable)e);
        }
        return (IForm)result.getValue();
    }

    private static Control findSwtFormField(Control control, IFormField formField) {
        Object o = control.getData("org.eclipse.scout.rt.object");
        if (o == formField) {
            return control;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control candiate = SwtScoutFormFieldPopup.findSwtFormField(child, formField);
                if (candiate != null) {
                    return candiate;
                }
                ++n2;
            }
        }
        return null;
    }

    private static class P_Form
    extends AbstractForm {
        private final IFormField m_formField;

        public P_Form(IFormField formField) throws ProcessingException {
            super(false);
            this.m_formField = formField;
            this.callInitializer();
        }

        protected boolean getConfiguredModal() {
            return false;
        }

        protected int getConfiguredDisplayHint() {
            return 20;
        }

        public String getDisplayViewId() {
            return "C";
        }

        protected boolean getConfiguredAskIfNeedSave() {
            return false;
        }

        public void startForm() throws ProcessingException {
            this.startInternal((IFormHandler)new FormHandler());
        }

        public MainBox getMainBox() {
            return (MainBox)this.getRootGroupBox();
        }

        private class FormHandler
        extends AbstractFormHandler {
            private FormHandler() {
            }
        }

        @Order(value=10.0)
        public class MainBox
        extends AbstractGroupBox {
            protected void injectFieldsInternal(OrderedCollection<IFormField> fields) {
                fields.addOrdered((IOrdered)P_Form.this.m_formField);
            }

            protected boolean getConfiguredBorderVisible() {
                return false;
            }

            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            protected boolean getConfiguredGridUseUiWidth() {
                return true;
            }

            protected boolean getConfiguredGridUseUiHeight() {
                return true;
            }
        }
    }
}

