/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public abstract class MultilineButton
extends Composite {
    protected Label m_label;
    protected Button m_btn;
    private boolean m_hasFocus;

    public MultilineButton(Composite parent, int style) {
        super(parent, style);
        this.createContent(this, style);
        this.createLayout();
    }

    protected void createContent(Composite parent, int style) {
        this.m_btn = new Button(parent, style);
        this.m_label = new Label(parent, 0);
        this.m_label.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (MultilineButton.this.m_hasFocus) {
                    GC gc = e.gc;
                    int lineStyleBackup = gc.getLineStyle();
                    Color foregroundBackup = gc.getForeground();
                    int lineWidthBackup = gc.getLineWidth();
                    try {
                        gc.setLineStyle(3);
                        gc.setForeground(gc.getDevice().getSystemColor(10));
                        gc.setLineWidth(1);
                        gc.drawRectangle(0, 0, e.width - 1, e.height - 1);
                    }
                    finally {
                        gc.setLineStyle(lineStyleBackup);
                        gc.setForeground(foregroundBackup);
                        gc.setLineWidth(lineWidthBackup);
                    }
                }
            }
        });
        this.m_btn.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MultilineButton.this.m_hasFocus = false;
                MultilineButton.this.m_label.redraw();
            }

            public void focusGained(FocusEvent e) {
                MultilineButton.this.m_hasFocus = true;
                MultilineButton.this.m_label.redraw();
            }
        });
    }

    protected void createLayout() {
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.horizontalSpacing = 5;
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.verticalSpacing = 0;
        GridData labelData = new GridData(4, 4, false, false);
        labelData.verticalIndent = 3;
        this.m_label.setLayoutData((Object)labelData);
        GridData buttonData = new GridData(4, 128, false, false);
        buttonData.verticalIndent = 3;
        this.m_btn.setLayoutData((Object)buttonData);
        this.setLayout((Layout)containerLayout);
    }

    public void setText(String text) {
        this.m_label.setText(text);
    }

    public void setFont(Font font) {
        this.m_label.setFont(font);
        this.m_btn.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.m_label.setForeground(color);
        this.m_btn.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_label.setBackground(color);
        this.m_btn.setBackground(color);
    }

    public void removeListener(int eventType, Listener listener) {
        super.removeListener(eventType, listener);
        this.m_btn.removeListener(eventType, listener);
        this.m_label.removeListener(eventType, listener);
    }

    public void setSelection(boolean selected) {
        this.m_btn.setSelection(selected);
    }

    public boolean getSelection() {
        return this.m_btn.getSelection();
    }

    public void addListener(int eventType, Listener listener) {
        super.addListener(eventType, listener);
        this.m_btn.addListener(eventType, (Listener)new P_ProxyListener(listener));
        this.m_label.addListener(eventType, (Listener)new P_ProxyListener(listener));
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.m_btn.setMenu(menu);
        this.m_label.setMenu(menu);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.m_btn.setToolTipText(string);
        this.m_label.setToolTipText(string);
    }

    public void setData(Object data) {
        super.setData(data);
        this.m_btn.setData(data);
    }

    public void setData(String key, Object value) {
        super.setData(key, value);
        this.m_btn.setData(key, value);
    }

    public void setImage(Image icon) {
        this.m_btn.setImage(icon);
    }

    public Label getLabel() {
        return this.m_label;
    }

    public Button getButton() {
        return this.m_btn;
    }

    public boolean setFocus() {
        return this.m_btn.setFocus();
    }

    public boolean isFocusControl() {
        return this.m_btn.isFocusControl();
    }

    class P_ProxyListener
    implements Listener {
        private Listener m_originalListener;

        public P_ProxyListener(Listener listener) {
            this.m_originalListener = listener;
        }

        public void handleEvent(Event event) {
            event.widget = MultilineButton.this;
            this.m_originalListener.handleEvent(event);
        }
    }
}

