/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard;

import java.util.Set;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.IRuntimeClasses;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.WizardStepNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IScoutPageConstants;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeComparators;

/**
 * <h3>WizardStepTablePage</h3>
 */
public class WizardStepTablePage extends AbstractPage {

  private final IType m_wizardType;
  private InnerTypePageDirtyListener m_innerTypeListener;

  public WizardStepTablePage(IPage parent, IType wizardType) {
    m_wizardType = wizardType;
    setParent(parent);
    setName(Texts.get("WizardStepTablePage"));
    setImageDescriptor(ScoutSdkUi.getImageDescriptor(ScoutSdkUi.WizardSteps));
  }

  @Override
  public String getPageId() {
    return IScoutPageConstants.WIZARD_STEP_TABLE_PAGE;
  }

  @Override
  public boolean isFolder() {
    return true;
  }

  @Override
  public void unloadPage() {
    super.unloadPage();
    if (m_innerTypeListener != null) {
      ScoutSdkCore.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(getWizardType(), m_innerTypeListener);
      m_innerTypeListener = null;
    }
  }

  @Override
  protected void loadChildrenImpl() {
    IType iWizardStep = TypeUtility.getType(IRuntimeClasses.IWizardStep);

    if (m_innerTypeListener == null) {
      m_innerTypeListener = new InnerTypePageDirtyListener(this, iWizardStep);
      ScoutSdkCore.getJavaResourceChangedEmitter().addInnerTypeChangedListener(getWizardType(), m_innerTypeListener);
    }
    Set<IType> wizardSteps = TypeUtility.getInnerTypes(getWizardType(), TypeFilters.getSubtypeFilter(iWizardStep), ScoutTypeComparators.getOrderAnnotationComparator());
    for (IType wizardStep : wizardSteps) {
      WizardStepNodePage childPage = new WizardStepNodePage();
      childPage.setParent(this);
      childPage.setType(wizardStep);
    }
  }

  @Override
  public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
    return newSet(WizardStepNewAction.class);
  }

  public IType getWizardType() {
    return m_wizardType;
  }
}
