/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk.ui.wizard.form.fields;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.ui.extensions.AbstractInnerTypeWizard;
import org.eclipse.ui.IWorkbench;

public class FormFieldNewWizard extends AbstractInnerTypeWizard {

  @Override
  public void init(IWorkbench workbench, IStructuredSelection selection) {
    super.init(workbench, selection);
    FormFieldSelectionWizardPage page1 = new FormFieldSelectionWizardPage(getDeclaringType());
    if (getSiblingProposal() != null) {
      page1.setSibling(getSiblingProposal().getElement());
    }
    page1.setTypeName(getTypeName());
    addPage(page1);
  }

  @Override
  protected boolean beforeFinish() throws CoreException {
    // we never want to execute the finish operations on this wizard.
    // They have been passed to the concrete nested wizard and will be executed there.
    getPerformFinishOperationsInternal().clear();
    return super.beforeFinish();
  }

  @Override
  public boolean needsPreviousAndNextButtons() {
    return true;
  }

  @Override
  public boolean canFinish() {
    return false;
  }
}
