/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.dialog.AbstractStatusDialog;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TemplateFromFormFieldDialog
extends AbstractStatusDialog {
    private StyledTextField m_templateNameField;
    private Button m_replaceExistingFormField;
    private Button m_createExternalFormDataField;
    private EntityTextField m_entityField;
    private final IType m_formField;
    private final IScoutBundle m_clientBundle;
    private String m_templateName;
    private String m_packageName;
    private boolean m_replaceFormField;
    private boolean m_createExternalFormData;

    public TemplateFromFormFieldDialog(Shell parentShell, String templateName, IType formField) {
        super(parentShell);
        this.m_formField = formField;
        this.m_templateName = templateName;
        this.m_replaceFormField = true;
        this.m_createExternalFormData = true;
        this.m_clientBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)formField.getJavaProject());
        this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)this.m_clientBundle, (String)"client.template.formfield"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Texts.get((String)"CreateTemplateOf", (String[])new String[]{this.getFormField().getElementName()}));
        this.setMessage(Texts.get((String)"TemplateDesc"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Texts.get((String)"TemplateSupport"));
    }

    protected Control createDialogArea(Composite parent) {
        int labelColWidthPercent = 20;
        Composite container = new Composite(parent, 0);
        this.m_templateNameField = this.getFieldToolkit().createStyledTextField(container, Texts.get((String)"TemplateName"), labelColWidthPercent);
        this.m_templateNameField.setReadOnlyPrefix("Abstract");
        this.m_templateNameField.setText(this.getTemplateName());
        this.m_templateNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TemplateFromFormFieldDialog.this.m_templateName = TemplateFromFormFieldDialog.this.m_templateNameField.getText();
                TemplateFromFormFieldDialog.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(container, Texts.get((String)"EntityTextField"), this.m_clientBundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TemplateFromFormFieldDialog.this.setTargetPackageInternal(TemplateFromFormFieldDialog.this.m_entityField.getText());
                    TemplateFromFormFieldDialog.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        this.m_replaceExistingFormField = new Button(container, 32);
        this.m_replaceExistingFormField.setText(Texts.get((String)"UseTemplateFor", (String[])new String[]{this.getFormField().getElementName()}));
        this.m_replaceExistingFormField.setSelection(this.isReplaceFormField());
        this.m_replaceExistingFormField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateFromFormFieldDialog.this.m_replaceFormField = TemplateFromFormFieldDialog.this.m_replaceExistingFormField.getSelection();
                TemplateFromFormFieldDialog.this.pingStateChanging();
            }
        });
        this.m_createExternalFormDataField = new Button(container, 32);
        this.m_createExternalFormDataField.setText(Texts.get((String)"CreateExternalFormData"));
        this.m_createExternalFormDataField.setSelection(this.isCreateExternalFormData());
        this.m_createExternalFormDataField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateFromFormFieldDialog.this.m_createExternalFormData = TemplateFromFormFieldDialog.this.m_createExternalFormDataField.getSelection();
                TemplateFromFormFieldDialog.this.pingStateChanging();
            }
        });
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, true));
        this.m_templateNameField.setLayoutData(new GridData(768));
        this.m_replaceExistingFormField.setLayoutData((Object)new GridData(768));
        this.m_createExternalFormDataField.setLayoutData((Object)new GridData(768));
        return container;
    }

    @Override
    protected void validate(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusTemplateName());
        multiStatus.add(this.getStatusTargetPackge());
    }

    protected IStatus getStatusTargetPackge() {
        return ScoutUtility.validatePackageName((String)this.getTargetPackage());
    }

    private IStatus getStatusTemplateName() {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getTemplateName()) || "Abstrat".equals(this.getTemplateName())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NameNotValid"));
        }
        IScoutBundle bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.getFormField());
        if (TypeUtility.existsType((String)(String.valueOf(bundle.getPackageName(this.getTargetPackage())) + "." + this.getTemplateName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TemplateAlreadyExists"));
        }
        return Status.OK_STATUS;
    }

    public IType getFormField() {
        return this.m_formField;
    }

    public String getTemplateName() {
        return this.m_templateName;
    }

    public boolean isReplaceFormField() {
        return this.m_replaceFormField;
    }

    public boolean isCreateExternalFormData() {
        return this.m_createExternalFormData;
    }

    public String getTargetPackage() {
        return this.m_packageName;
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.m_packageName = targetPackage;
    }
}

