/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.dto.pagedata.DataAnnotation;
import org.eclipse.scout.sdk.workspace.dto.pagedata.PageDataDtoUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PageDataUpdateExecutor
extends AbstractExecutor {
    private IType m_pageDataOwner;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_pageDataOwner = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_pageDataOwner) && this.m_pageDataOwner.getDeclaringType() == null;
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        try {
            DataAnnotation pageDataAnnotation = ScoutTypeUtility.findDataAnnotation((IType)this.m_pageDataOwner, (ITypeHierarchy)TypeUtility.getSupertypeHierarchy((IType)this.m_pageDataOwner));
            if (pageDataAnnotation != null && !StringUtility.isNullOrEmpty((CharSequence)pageDataAnnotation.getDataTypeSignature())) {
                OperationJob job = new OperationJob(new IOperation[]{new PageDataDtoUpdateOperation(this.m_pageDataOwner, pageDataAnnotation)});
                job.schedule();
            } else {
                MessageBox box = new MessageBox(shell, 34);
                box.setMessage(Texts.get((String)"CheckPageData"));
                box.open();
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("unable to calculate page data type for update of element '" + this.m_pageDataOwner + "'.", e);
        }
        return null;
    }
}

