/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.AbstractWorkspaceBlockingJob;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PageWithTableDeleteExecutor
extends AbstractExecutor {
    private IType m_pageType;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_pageType = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_pageType);
    }

    @Override
    public Object run(final Shell shell, final IStructuredSelection selection, final ExecutionEvent event) {
        new AbstractWorkspaceBlockingJob("Collect elements to delete"){

            protected void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
                PageWithTableDeleteExecutor.this.runAsync(shell, selection, event);
            }
        }.schedule();
        return null;
    }

    protected void runAsync(final Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        final LinkedHashSet<IMember> members = new LinkedHashSet<IMember>();
        final LinkedHashSet<IMember> selectedMembers = new LinkedHashSet<IMember>();
        this.collectAffectedMembers(members, selectedMembers, selection);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                final MemberSelectionDialog confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"Action_deleteTypeX", (String[])new String[]{PageWithTableDeleteExecutor.this.m_pageType.getElementName()}));
                confirmDialog.setMembers(members);
                confirmDialog.setSelectedMembers(selectedMembers);
                confirmDialog.addMemberSelectionListener(new IMemberSelectionChangedListener(){

                    @Override
                    public void handleSelectionChanged(Set<? extends IMember> s) {
                        confirmDialog.setMessage("");
                        confirmDialog.getOkButton().setEnabled(CollectionUtility.hasElements(s));
                    }
                });
                if (confirmDialog.open() == 0) {
                    JavaElementDeleteOperation op = new JavaElementDeleteOperation();
                    op.setMembers(confirmDialog.getSelectedMembers());
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        });
    }

    protected void collectAffectedMembers(Set<IMember> members, Set<IMember> selectedMembers, IStructuredSelection selection) {
        members.add((IMember)this.m_pageType);
        selectedMembers.add((IMember)this.m_pageType);
        IType pageData = null;
        try {
            pageData = ScoutTypeUtility.findDtoForPage((IType)this.m_pageType);
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError(e);
        }
        if (TypeUtility.exists((IJavaElement)pageData)) {
            members.add((IMember)pageData);
            selectedMembers.add((IMember)pageData);
        }
    }
}

