/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.executor.AbstractRenameExecutor;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class TypeRenameExecutor
extends AbstractRenameExecutor {
    private IType m_type;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        boolean superRun = super.canRun(selection);
        if (!superRun) {
            return false;
        }
        this.m_type = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_type);
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.m_type, newName);
    }

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = ScoutUtility.validateJavaName((String)newName, (String)this.getReadOnlySuffix());
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        IType declaringType = this.m_type.getDeclaringType();
        if (declaringType != null ? TypeUtility.exists((IJavaElement)declaringType.getType(newName)) : TypeUtility.existsType((String)(String.valueOf(packName = this.m_type.getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return inheritedStatus;
    }
}

