/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformClientBundleOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformCodeTypesOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformFormsOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformLookupCallsOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformOutlinesOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformPagesOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformSearchFormsOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformServerBundleOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformSharedBundleOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformWizardsOperation;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.BundleNodeGroupTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ProjectsTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientLookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.SearchFormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.AllPagesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedNodePage;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class WellformExecutor
extends AbstractExecutor {
    private List<IOperation> m_operations;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        IScoutBundle scoutBundle = UiUtility.getScoutBundleFromSelection(selection);
        if (selectedElement instanceof BundleNodeGroupTablePage) {
            Set childBundles = scoutBundle.getChildBundles(ScoutBundleFilters.getWorkspaceBundlesFilter(), true);
            this.m_operations = this.getWellformOperationsFor(childBundles);
        } else if (selectedElement instanceof ProjectsTablePage) {
            Set workspaceBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getWorkspaceBundlesFilter());
            this.m_operations = this.getWellformOperationsFor(workspaceBundles);
        } else if (selectedElement instanceof ClientLookupCallTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformLookupCallsOperation(scoutBundle));
        } else if (selectedElement instanceof ClientNodePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformClientBundleOperation((Set)CollectionUtility.hashSet((Object)scoutBundle)));
        } else if (selectedElement instanceof OutlineTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformOutlinesOperation(scoutBundle));
        } else if (selectedElement instanceof FormTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformFormsOperation(scoutBundle));
        } else if (selectedElement instanceof SearchFormTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformSearchFormsOperation(scoutBundle));
        } else if (selectedElement instanceof AllPagesTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformPagesOperation(scoutBundle));
        } else if (selectedElement instanceof WizardTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformWizardsOperation(scoutBundle));
        } else if (selectedElement instanceof ServerNodePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformServerBundleOperation(scoutBundle));
        } else if (selectedElement instanceof CodeTypeTablePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformCodeTypesOperation(scoutBundle));
        } else if (selectedElement instanceof SharedNodePage) {
            this.m_operations = new ArrayList<IOperation>(1);
            this.m_operations.add((IOperation)new WellformSharedBundleOperation(scoutBundle));
        }
        return CollectionUtility.hasElements(this.m_operations) && this.isEditable(scoutBundle);
    }

    protected List<IOperation> getWellformOperationsFor(Set<? extends IScoutBundle> bundles) {
        ArrayList<IOperation> operations = new ArrayList<IOperation>(bundles.size());
        for (IScoutBundle iScoutBundle : bundles) {
            if ("CLIENT".equals(iScoutBundle.getType())) {
                operations.add((IOperation)new WellformClientBundleOperation((Set)CollectionUtility.hashSet((Object)iScoutBundle)));
                continue;
            }
            if ("SERVER".equals(iScoutBundle.getType())) {
                operations.add((IOperation)new WellformServerBundleOperation(iScoutBundle));
                continue;
            }
            if (!"SHARED".equals(iScoutBundle.getType())) continue;
            operations.add((IOperation)new WellformSharedBundleOperation(iScoutBundle));
        }
        return operations;
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        MessageBox box = new MessageBox(shell, 292);
        box.setMessage(Texts.get((String)"WellformConfirmationMessage"));
        if (box.open() == 32) {
            new OperationJob(this.m_operations).schedule();
        }
        return null;
    }
}

